/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.internal.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DataBufferIterator<T>
implements Iterator<T> {
    protected final DataBuffer<T> mDataBuffer;
    protected int mPosition;

    public DataBufferIterator(DataBuffer<T> dataBuffer) {
        this.mDataBuffer = (DataBuffer)Preconditions.checkNotNull(dataBuffer);
        this.mPosition = -1;
    }

    @Override
    public boolean hasNext() {
        return this.mPosition < this.mDataBuffer.getCount() - 1;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            int n = this.mPosition;
            throw new NoSuchElementException(new StringBuilder(46).append("Cannot advance the iterator beyond ").append(n).toString());
        }
        return this.mDataBuffer.get(++this.mPosition);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove elements from a DataBufferIterator");
    }
}

