/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.GooglePlayServicesUpdatedReceiver;
import com.google.android.gms.common.api.internal.LifecycleActivity;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.StatusPendingResult;
import com.google.android.gms.common.api.internal.zzaw;
import com.google.android.gms.common.api.internal.zzax;
import com.google.android.gms.common.api.internal.zzay;
import com.google.android.gms.common.api.internal.zzaz;
import com.google.android.gms.common.api.internal.zzba;
import com.google.android.gms.common.api.internal.zzbb;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbq;
import com.google.android.gms.common.api.internal.zzch;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.api.internal.zzr;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClientEventManager;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.service.Common;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.signin.SignInClient;
import com.google.android.gms.signin.SignInOptions;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

public final class zzav
extends GoogleApiClient
implements zzbq {
    private final Lock zzga;
    private boolean zzdk;
    private final GmsClientEventManager zzie;
    private zzbp zzif = null;
    private final int zzde;
    private final Context mContext;
    private final Looper zzcn;
    @VisibleForTesting
    final Queue<BaseImplementation.ApiMethodImpl<?, ?>> zzgo = new LinkedList();
    private volatile boolean zzig;
    private long zzih = 120000L;
    private long zzii = 5000L;
    private final zzba zzij;
    private final GoogleApiAvailability zzdg;
    @VisibleForTesting
    private GooglePlayServicesUpdatedReceiver zzik;
    final Map<Api.AnyClientKey<?>, Api.Client> zzil;
    Set<Scope> zzim = new HashSet<Scope>();
    private final ClientSettings zzgf;
    private final Map<Api<?>, Boolean> zzgi;
    private final Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> zzdh;
    private final ListenerHolders zzin = new ListenerHolders();
    private final ArrayList<zzp> zzio;
    private Integer zzip = null;
    Set<zzch> zziq = null;
    final zzck zzir;
    private final GmsClientEventManager.GmsClientEventState zzis = new zzaw(this);

    public zzav(Context context, Lock lock, Looper looper, ClientSettings clientSettings, GoogleApiAvailability googleApiAvailability, Api.AbstractClientBuilder<? extends SignInClient, SignInOptions> abstractClientBuilder, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.AnyClientKey<?>, Api.Client> map2, int n, int n2, ArrayList<zzp> arrayList, boolean bl) {
        this.mContext = context;
        this.zzga = lock;
        this.zzdk = false;
        this.zzie = new GmsClientEventManager(looper, this.zzis);
        this.zzcn = looper;
        this.zzij = new zzba(this, looper);
        this.zzdg = googleApiAvailability;
        this.zzde = n;
        if (this.zzde >= 0) {
            this.zzip = n2;
        }
        this.zzgi = map;
        this.zzil = map2;
        this.zzio = arrayList;
        this.zzir = new zzck(this.zzil);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzie.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzie.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzgf = clientSettings;
        this.zzdh = abstractClientBuilder;
    }

    @Override
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        Preconditions.checkArgument((t.getClientKey() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.getApi() != null ? t.getApi().getName() : "the API";
        Preconditions.checkArgument((boolean)this.zzil.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzga.lock();
        try {
            if (this.zzif == null) {
                this.zzgo.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzif.enqueue(t);
            return (T)string2;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        Preconditions.checkArgument((t.getClientKey() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.getApi() != null ? t.getApi().getName() : "the API";
        Preconditions.checkArgument((boolean)this.zzil.containsKey(t.getClientKey()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzga.lock();
        try {
            if (this.zzif == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzig) {
                this.zzgo.add(t);
                while (!this.zzgo.isEmpty()) {
                    object = this.zzgo.remove();
                    this.zzir.zzb((BasePendingResult<? extends Result>)object);
                    ((BaseImplementation.ApiMethodImpl)object).setFailedResult(Status.RESULT_INTERNAL_ERROR);
                }
                object = t;
                return (T)object;
            }
            object = this.zzif.execute(t);
            return (T)object;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final <L> ListenerHolder<L> registerListener(@NonNull L l) {
        this.zzga.lock();
        try {
            Looper looper = this.zzcn;
            L l2 = l;
            ListenerHolder<L> listenerHolder = this.zzin.zza(l2, looper, "NO_TYPE");
            return listenerHolder;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.Client> C getClient(@NonNull Api.AnyClientKey<C> anyClientKey) {
        Api.Client client = this.zzil.get(anyClientKey);
        Preconditions.checkNotNull((Object)client, (Object)"Appropriate Api was not requested.");
        return (C)client;
    }

    @Override
    public final boolean hasApi(@NonNull Api<?> api) {
        return this.zzil.containsKey(api.getClientKey());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.Client client = this.zzil.get(api.getClientKey());
        return client != null && client.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzga.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zzig) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzil.containsKey(api.getClientKey())) break block6;
                    connectionResult = this.zzif.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzig) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.RESULT_SUCCESS;
                    this.zzga.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzbb());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzga.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzga.lock();
        try {
            if (this.zzde >= 0) {
                Preconditions.checkState((this.zzip != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzip == null) {
                this.zzip = zzav.zza(this.zzil.values(), false);
            } else if (this.zzip == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zzip);
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzga.lock();
        try {
            Preconditions.checkArgument((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzg(n);
            this.zzax();
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzga.lock();
        try {
            if (this.zzde >= 0) {
                Preconditions.checkState((this.zzip != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzip == null) {
                this.zzip = zzav.zza(this.zzil.values(), false);
            } else if (this.zzip == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzg(this.zzip);
            this.zzie.enableCallbacks();
            ConnectionResult connectionResult = this.zzif.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        Preconditions.checkState((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzga.lock();
        try {
            if (this.zzip == null) {
                this.zzip = zzav.zza(this.zzil.values(), false);
            } else if (this.zzip == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzg(this.zzip);
            this.zzie.enableCallbacks();
            ConnectionResult connectionResult = this.zzif.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzga.lock();
        try {
            this.zzir.release();
            if (this.zzif != null) {
                this.zzif.disconnect();
            }
            this.zzin.release();
            for (BaseImplementation.ApiMethodImpl apiMethodImpl : this.zzgo) {
                apiMethodImpl.zza(null);
                ((PendingResult)apiMethodImpl).cancel();
            }
            this.zzgo.clear();
            if (this.zzif == null) {
                return;
            }
            this.zzaz();
            this.zzie.disableCallbacks();
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        Preconditions.checkState((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        Preconditions.checkState((this.zzip != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        StatusPendingResult statusPendingResult = new StatusPendingResult(this);
        if (this.zzil.containsKey(Common.CLIENT_KEY)) {
            this.zza(this, statusPendingResult, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzax zzax2 = new zzax(this, atomicReference, statusPendingResult);
            zzay zzay2 = new zzay(this, statusPendingResult);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(Common.API).addConnectionCallbacks(zzax2).addOnConnectionFailedListener(zzay2).setHandler(this.zzij).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return statusPendingResult;
    }

    private final void zza(GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        Common.CommonApi.clearDefaultAccount(googleApiClient).setResultCallback(new zzaz(this, statusPendingResult, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        LifecycleActivity lifecycleActivity = new LifecycleActivity((Activity)fragmentActivity);
        zzav zzav2 = this;
        if (zzav2.zzde >= 0) {
            zzi.zza(lifecycleActivity).zzc(zzav2.zzde);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzif != null && this.zzif.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzif != null && this.zzif.isConnecting();
    }

    private final void zzg(int n) {
        if (this.zzip == null) {
            this.zzip = n;
        } else if (this.zzip != n) {
            String string2 = zzav.zzh(n);
            String string3 = zzav.zzh(this.zzip);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzif != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.Client client : this.zzil.values()) {
            if (client.requiresSignIn()) {
                bl = true;
            }
            if (!client.providesSignIn()) continue;
            bl2 = true;
        }
        switch (this.zzip) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzdk) {
                    this.zzif = new zzw(this.mContext, this.zzga, this.zzcn, this.zzdg, this.zzil, this.zzgf, this.zzgi, this.zzdh, this.zzio, this, true);
                    return;
                }
                this.zzif = zzr.zza(this.mContext, this, this.zzga, this.zzcn, this.zzdg, this.zzil, this.zzgf, this.zzgi, this.zzdh, this.zzio);
                return;
            }
        }
        if (this.zzdk && !bl2) {
            this.zzif = new zzw(this.mContext, this.zzga, this.zzcn, this.zzdg, this.zzil, this.zzgf, this.zzgi, this.zzdh, this.zzio, this, false);
            return;
        }
        this.zzif = new zzbd(this.mContext, this, this.zzga, this.zzcn, this.zzdg, this.zzil, this.zzgf, this.zzgi, this.zzdh, this.zzio, this);
    }

    @GuardedBy(value="mLock")
    private final void zzax() {
        this.zzie.enableCallbacks();
        this.zzif.connect();
    }

    private final void resume() {
        this.zzga.lock();
        try {
            if (this.zzig) {
                this.zzax();
            }
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    private final void zzay() {
        this.zzga.lock();
        try {
            if (this.zzaz()) {
                this.zzax();
            }
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @GuardedBy(value="mLock")
    final boolean zzaz() {
        if (!this.zzig) {
            return false;
        }
        this.zzig = false;
        this.zzij.removeMessages(2);
        this.zzij.removeMessages(1);
        if (this.zzik != null) {
            this.zzik.unregister();
            this.zzik = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzie.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzie.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzie.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzie.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzie.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzie.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zzb(Bundle bundle) {
        while (!this.zzgo.isEmpty()) {
            ((GoogleApiClient)this).execute(this.zzgo.remove());
        }
        this.zzie.onConnectionSuccess(bundle);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zzc(ConnectionResult connectionResult) {
        if (!this.zzdg.isPlayServicesPossiblyUpdating(this.mContext, connectionResult.getErrorCode())) {
            this.zzaz();
        }
        if (!this.zzig) {
            this.zzie.onConnectionFailure(connectionResult);
            this.zzie.disableCallbacks();
        }
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zzb(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzav zzav2 = this;
            if (!zzav2.zzig) {
                zzav2.zzig = true;
                if (zzav2.zzik == null) {
                    zzav2.zzik = zzav2.zzdg.registerCallbackOnUpdate(zzav2.mContext.getApplicationContext(), new zzbb(zzav2));
                }
                zzav2.zzij.sendMessageDelayed(zzav2.zzij.obtainMessage(1), zzav2.zzih);
                zzav2.zzij.sendMessageDelayed(zzav2.zzij.obtainMessage(2), zzav2.zzii);
            }
        }
        this.zzir.zzce();
        this.zzie.onUnintentionalDisconnection(n);
        this.zzie.disableCallbacks();
        if (n == 2) {
            this.zzax();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zzcn;
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        return this.zzif != null && this.zzif.maybeSignIn(signInConnectionListener);
    }

    @Override
    public final void maybeSignOut() {
        if (this.zzif != null) {
            this.zzif.maybeSignOut();
        }
    }

    @Override
    public final void zza(zzch zzch2) {
        this.zzga.lock();
        try {
            if (this.zziq == null) {
                this.zziq = new HashSet<zzch>();
            }
            this.zziq.add(zzch2);
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    @Override
    public final void zzb(zzch zzch2) {
        this.zzga.lock();
        try {
            if (this.zziq == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zziq.remove(zzch2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzba()) {
                this.zzif.zzz();
            }
            return;
        }
        finally {
            this.zzga.unlock();
        }
    }

    final boolean zzba() {
        this.zzga.lock();
        try {
            if (this.zziq == null) {
                return false;
            }
            boolean bl = !this.zziq.isEmpty();
            return bl;
        }
        finally {
            this.zzga.unlock();
        }
    }

    final String zzbb() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzig);
        printWriter.append(" mWorkQueue.size()=").print(this.zzgo.size());
        PrintWriter printWriter2 = printWriter;
        zzck zzck2 = this.zzir;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzck2.zzmo.size());
        if (this.zzif != null) {
            this.zzif.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.Client> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.Client client : iterable) {
            if (client.requiresSignIn()) {
                bl2 = true;
            }
            if (!client.providesSignIn()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzh(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzav zzav2) {
        zzav2.resume();
    }

    static /* synthetic */ void zzb(zzav zzav2) {
        zzav2.zzay();
    }

    static /* synthetic */ void zza(zzav zzav2, GoogleApiClient googleApiClient, StatusPendingResult statusPendingResult, boolean bl) {
        zzav2.zza(googleApiClient, statusPendingResult, true);
    }

    static /* synthetic */ Context zzc(zzav zzav2) {
        return zzav2.mContext;
    }
}

