/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.internal.ConnectionErrorMessages;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.dynamic.zzb;
import com.google.android.gms.dynamic.zzc;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.dynamic.zzg;
import java.util.LinkedList;

public abstract class DeferredLifecycleHelper<T extends LifecycleDelegate> {
    private T zzabc;
    private Bundle zzabd;
    private LinkedList<zza> zzabe;
    private final OnDelegateCreatedListener<T> zzabf = new com.google.android.gms.dynamic.zza(this);

    public DeferredLifecycleHelper() {
    }

    public T getDelegate() {
        return this.zzabc;
    }

    private final void zzm(int n) {
        while (!this.zzabe.isEmpty() && this.zzabe.getLast().getState() >= n) {
            this.zzabe.removeLast();
        }
    }

    private final void zza(Bundle bundle, zza zza2) {
        if (this.zzabc != null) {
            zza2.zza((LifecycleDelegate)this.zzabc);
            return;
        }
        if (this.zzabe == null) {
            this.zzabe = new LinkedList();
        }
        this.zzabe.add(zza2);
        if (bundle != null) {
            if (this.zzabd == null) {
                this.zzabd = (Bundle)bundle.clone();
            } else {
                this.zzabd.putAll(bundle);
            }
        }
        this.createDelegate(this.zzabf);
    }

    protected abstract void createDelegate(OnDelegateCreatedListener<T> var1);

    public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
        this.zza(bundle2, new zzb(this, activity, bundle, bundle2));
    }

    public void onCreate(Bundle bundle) {
        this.zza(bundle, new zzc(this, bundle));
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        FrameLayout frameLayout = new FrameLayout(layoutInflater.getContext());
        this.zza(bundle, new zzd(this, frameLayout, layoutInflater, viewGroup, bundle));
        if (this.zzabc == null) {
            this.handleGooglePlayUnavailable(frameLayout);
        }
        return frameLayout;
    }

    protected void handleGooglePlayUnavailable(FrameLayout frameLayout) {
        DeferredLifecycleHelper.showGooglePlayUnavailableMessage(frameLayout);
    }

    public static void showGooglePlayUnavailableMessage(FrameLayout frameLayout) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        FrameLayout frameLayout2 = frameLayout;
        Context context = frameLayout2.getContext();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        String string2 = ConnectionErrorMessages.getErrorMessage(context, n);
        String string3 = ConnectionErrorMessages.getErrorDialogButtonMessage(context, n);
        LinearLayout linearLayout = new LinearLayout(frameLayout2.getContext());
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        frameLayout2.addView((View)linearLayout);
        TextView textView = new TextView(frameLayout2.getContext());
        textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        textView.setText((CharSequence)string2);
        linearLayout.addView((View)textView);
        Intent intent = googleApiAvailability.getErrorResolutionIntent(context, n, null);
        if (intent != null) {
            Button button = new Button(context);
            button.setId(16908313);
            button.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            button.setText((CharSequence)string3);
            linearLayout.addView((View)button);
            button.setOnClickListener((View.OnClickListener)new zze(context, intent));
        }
    }

    public void onStart() {
        this.zza(null, new zzf(this));
    }

    public void onResume() {
        this.zza(null, new zzg(this));
    }

    public void onPause() {
        if (this.zzabc != null) {
            this.zzabc.onPause();
            return;
        }
        this.zzm(5);
    }

    public void onStop() {
        if (this.zzabc != null) {
            this.zzabc.onStop();
            return;
        }
        this.zzm(4);
    }

    public void onDestroyView() {
        if (this.zzabc != null) {
            this.zzabc.onDestroyView();
            return;
        }
        this.zzm(2);
    }

    public void onDestroy() {
        if (this.zzabc != null) {
            this.zzabc.onDestroy();
            return;
        }
        this.zzm(1);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (this.zzabc != null) {
            this.zzabc.onSaveInstanceState(bundle);
            return;
        }
        if (this.zzabd != null) {
            bundle.putAll(this.zzabd);
        }
    }

    public void onLowMemory() {
        if (this.zzabc != null) {
            this.zzabc.onLowMemory();
        }
    }

    static /* synthetic */ LifecycleDelegate zza(DeferredLifecycleHelper deferredLifecycleHelper, LifecycleDelegate lifecycleDelegate) {
        deferredLifecycleHelper.zzabc = lifecycleDelegate;
        return deferredLifecycleHelper.zzabc;
    }

    static /* synthetic */ LinkedList zza(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zzabe;
    }

    static /* synthetic */ LifecycleDelegate zzb(DeferredLifecycleHelper deferredLifecycleHelper) {
        return deferredLifecycleHelper.zzabc;
    }

    static /* synthetic */ Bundle zza(DeferredLifecycleHelper deferredLifecycleHelper, Bundle bundle) {
        deferredLifecycleHelper.zzabd = null;
        return null;
    }

    private static interface zza {
        public int getState();

        public void zza(LifecycleDelegate var1);
    }
}

