/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Handler;
import android.os.IInterface;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClientEventManager;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.Set;

public abstract class GmsClient<T extends IInterface>
extends BaseGmsClient<T>
implements Api.Client,
GmsClientEventManager.GmsClientEventState {
    private final ClientSettings zzgf;
    private final Set<Scope> mScopes;
    private final Account zzs;

    @VisibleForTesting
    protected GmsClient(Context context, Handler handler, int n, ClientSettings clientSettings) {
        this(context, handler, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, null, null);
    }

    protected GmsClient(Context context, Looper looper, int n, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, (GoogleApiClient.ConnectionCallbacks)Preconditions.checkNotNull((Object)connectionCallbacks), (GoogleApiClient.OnConnectionFailedListener)Preconditions.checkNotNull((Object)onConnectionFailedListener));
    }

    protected GmsClient(Context context, Looper looper, int n, ClientSettings clientSettings) {
        this(context, looper, GmsClientSupervisor.getInstance((Context)context), GoogleApiAvailability.getInstance(), n, clientSettings, null, null);
    }

    @VisibleForTesting
    protected GmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailability googleApiAvailability, int n, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, gmsClientSupervisor, (GoogleApiAvailabilityLight)googleApiAvailability, n, GmsClient.zza(connectionCallbacks), GmsClient.zza(onConnectionFailedListener), clientSettings.getRealClientClassName());
        this.zzgf = clientSettings;
        this.zzs = clientSettings.getAccount();
        this.mScopes = this.zza(clientSettings.getAllRequestedScopes());
    }

    @VisibleForTesting
    protected GmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailability googleApiAvailability, int n, ClientSettings clientSettings, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, handler, gmsClientSupervisor, (GoogleApiAvailabilityLight)googleApiAvailability, n, GmsClient.zza(connectionCallbacks), GmsClient.zza(onConnectionFailedListener));
        this.zzgf = (ClientSettings)Preconditions.checkNotNull((Object)clientSettings);
        this.zzs = clientSettings.getAccount();
        this.mScopes = this.zza(clientSettings.getAllRequestedScopes());
    }

    private final Set<Scope> zza(@NonNull Set<Scope> set) {
        Set<Scope> set2 = this.validateScopes(set);
        for (Scope scope : set2) {
            if (set.contains(scope)) continue;
            throw new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
        }
        return set2;
    }

    @NonNull
    protected Set<Scope> validateScopes(@NonNull Set<Scope> set) {
        return set;
    }

    public final Account getAccount() {
        return this.zzs;
    }

    protected final ClientSettings getClientSettings() {
        return this.zzgf;
    }

    protected final Set<Scope> getScopes() {
        return this.mScopes;
    }

    public Feature[] getRequiredFeatures() {
        return new Feature[0];
    }

    @Nullable
    private static BaseGmsClient.BaseConnectionCallbacks zza(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        if (connectionCallbacks == null) {
            return null;
        }
        return new zzf(connectionCallbacks);
    }

    @Nullable
    private static BaseGmsClient.BaseOnConnectionFailedListener zza(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        if (onConnectionFailedListener == null) {
            return null;
        }
        return new zzg(onConnectionFailedListener);
    }

    @Override
    public int getMinApkVersion() {
        return super.getMinApkVersion();
    }
}

