/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.DataBufferIterator;
import com.google.android.gms.common.internal.Asserts;
import java.util.Iterator;

public abstract class FilteredDataBuffer<T>
implements DataBuffer<T> {
    protected final DataBuffer<T> mDataBuffer;

    public FilteredDataBuffer(DataBuffer<T> dataBuffer) {
        Asserts.checkNotNull(dataBuffer);
        Asserts.checkState((!(dataBuffer instanceof FilteredDataBuffer) ? 1 : 0) != 0, (Object)"Not possible to have nested FilteredDataBuffers.");
        this.mDataBuffer = dataBuffer;
    }

    @Override
    public T get(int n) {
        return this.mDataBuffer.get(this.computeRealPosition(n));
    }

    protected abstract int computeRealPosition(int var1);

    @Override
    public void release() {
        this.mDataBuffer.release();
    }

    @Override
    @Deprecated
    public boolean isClosed() {
        return this.mDataBuffer.isClosed();
    }

    @Override
    public Iterator<T> iterator() {
        return new DataBufferIterator(this);
    }

    @Override
    public Iterator<T> singleRefIterator() {
        return this.iterator();
    }

    @Override
    public Bundle getMetadata() {
        return this.mDataBuffer.getMetadata();
    }

    @Override
    public void close() {
        this.release();
    }
}

