/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.DeadObjectException;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.SimpleClientAdapter;

@VisibleForTesting(otherwise=3)
@KeepForSdk
public class BaseImplementation {

    @KeepForSdk
    public static abstract class ApiMethodImpl<R extends Result, A extends Api.AnyClient>
    extends BasePendingResult<R>
    implements ResultHolder<R> {
        @KeepForSdk
        private final Api.AnyClientKey<A> mClientKey;
        @KeepForSdk
        private final Api<?> mApi;

        @Deprecated
        @KeepForSdk
        protected ApiMethodImpl(@NonNull Api.AnyClientKey<A> anyClientKey, @NonNull GoogleApiClient googleApiClient) {
            super((GoogleApiClient)Preconditions.checkNotNull((Object)googleApiClient, (Object)"GoogleApiClient must not be null"));
            this.mClientKey = (Api.AnyClientKey)Preconditions.checkNotNull(anyClientKey);
            this.mApi = null;
        }

        @KeepForSdk
        protected ApiMethodImpl(@NonNull Api<?> api, @NonNull GoogleApiClient googleApiClient) {
            super((GoogleApiClient)Preconditions.checkNotNull((Object)googleApiClient, (Object)"GoogleApiClient must not be null"));
            Preconditions.checkNotNull(api, (Object)"Api must not be null");
            this.mClientKey = api.getClientKey();
            this.mApi = api;
        }

        @VisibleForTesting
        @KeepForSdk
        protected ApiMethodImpl(@NonNull BasePendingResult.CallbackHandler<R> callbackHandler) {
            super(callbackHandler);
            this.mClientKey = null;
            this.mApi = null;
        }

        @KeepForSdk
        public final Api.AnyClientKey<A> getClientKey() {
            return this.mClientKey;
        }

        @KeepForSdk
        public final Api<?> getApi() {
            return this.mApi;
        }

        @KeepForSdk
        public final void run(@NonNull A object) throws DeadObjectException {
            if (object instanceof SimpleClientAdapter) {
                object = ((SimpleClientAdapter)object).getClient();
            }
            try {
                this.doExecute(object);
                return;
            }
            catch (DeadObjectException deadObjectException) {
                this.setFailedResult((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.setFailedResult(remoteException);
                return;
            }
        }

        @Override
        @KeepForSdk
        public final void setFailedResult(@NonNull Status status) {
            Preconditions.checkArgument((!status.isSuccess() ? 1 : 0) != 0, (Object)"Failed result must not be success");
            Object r = this.createFailedResult(status);
            ((BasePendingResult)this).setResult(r);
            this.onSetFailedResult(r);
        }

        @KeepForSdk
        protected void onSetFailedResult(@NonNull R r) {
        }

        @KeepForSdk
        protected abstract void doExecute(@NonNull A var1) throws RemoteException;

        @KeepForSdk
        private void setFailedResult(@NonNull RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.setFailedResult(status);
        }
    }

    @KeepForSdk
    public static interface ResultHolder<R> {
        @KeepForSdk
        public void setResult(R var1);

        @KeepForSdk
        public void setFailedResult(Status var1);
    }
}

