/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.support.annotation.Nullable;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class Api<O extends ApiOptions> {
    private final AbstractClientBuilder<?, O> zzby;
    private final zza<?, O> zzbz;
    private final ClientKey<?> zzca;
    private final zzb<?> zzcb;
    private final String mName;

    public <C extends Client> Api(String string2, AbstractClientBuilder<C, O> abstractClientBuilder, ClientKey<C> clientKey) {
        Preconditions.checkNotNull(abstractClientBuilder, (Object)"Cannot construct an Api with a null ClientBuilder");
        Preconditions.checkNotNull(clientKey, (Object)"Cannot construct an Api with a null ClientKey");
        this.mName = string2;
        this.zzby = abstractClientBuilder;
        this.zzbz = null;
        this.zzca = clientKey;
        this.zzcb = null;
    }

    public final BaseClientBuilder<?, O> zzj() {
        return this.zzby;
    }

    public final AbstractClientBuilder<?, O> zzk() {
        Preconditions.checkState((this.zzby != null ? 1 : 0) != 0, (Object)"This API was constructed with a SimpleClientBuilder. Use getSimpleClientBuilder");
        return this.zzby;
    }

    public final AnyClientKey<?> getClientKey() {
        if (this.zzca != null) {
            return this.zzca;
        }
        throw new IllegalStateException("This API was constructed with null client keys. This should not be possible.");
    }

    public final String getName() {
        return this.mName;
    }

    public static interface SimpleClient<T extends IInterface>
    extends AnyClient {
        public String getStartServiceAction();

        public String getServiceDescriptor();

        public T createServiceInterface(IBinder var1);

        public void setState(int var1, T var2);
    }

    @KeepForSdk
    public static interface Client
    extends AnyClient {
        public void connect(BaseGmsClient.ConnectionProgressReportCallbacks var1);

        public void disconnect();

        public boolean isConnected();

        public boolean isConnecting();

        public void getRemoteService(IAccountAccessor var1, Set<Scope> var2);

        public boolean requiresSignIn();

        public void onUserSignOut(BaseGmsClient.SignOutCallbacks var1);

        public boolean requiresGooglePlayServices();

        public boolean providesSignIn();

        public Intent getSignInIntent();

        public void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

        @Nullable
        public IBinder getServiceBrokerBinder();

        public String getEndpointPackageName();

        public int getMinApkVersion();

        public Feature[] getAvailableFeatures();
    }

    @KeepForSdk
    public static interface AnyClient {
    }

    @VisibleForTesting
    public static final class zzb<C extends SimpleClient>
    extends AnyClientKey<C> {
    }

    @VisibleForTesting
    @KeepForSdk
    public static final class ClientKey<C extends Client>
    extends AnyClientKey<C> {
    }

    @KeepForSdk
    public static class AnyClientKey<C extends AnyClient> {
    }

    public static interface ApiOptions {

        public static final class NoOptions
        implements NotRequiredOptions {
            private NoOptions() {
            }
        }

        public static interface HasGoogleSignInAccountOptions
        extends HasOptions {
            public GoogleSignInAccount getGoogleSignInAccount();
        }

        public static interface HasAccountOptions
        extends HasOptions,
        NotRequiredOptions {
            public Account getAccount();
        }

        public static interface Optional
        extends HasOptions,
        NotRequiredOptions {
        }

        public static interface HasOptions
        extends ApiOptions {
        }

        public static interface NotRequiredOptions
        extends ApiOptions {
        }
    }

    @VisibleForTesting
    public static abstract class zza<T extends SimpleClient, O>
    extends BaseClientBuilder<T, O> {
    }

    @VisibleForTesting
    @KeepForSdk
    public static abstract class AbstractClientBuilder<T extends Client, O>
    extends BaseClientBuilder<T, O> {
        @KeepForSdk
        public abstract T buildClient(Context var1, Looper var2, ClientSettings var3, O var4, GoogleApiClient.ConnectionCallbacks var5, GoogleApiClient.OnConnectionFailedListener var6);
    }

    @VisibleForTesting
    @KeepForSdk
    public static abstract class BaseClientBuilder<T extends AnyClient, O> {
        @KeepForSdk
        public static final int API_PRIORITY_GAMES = 1;
        @KeepForSdk
        public static final int API_PRIORITY_PLUS = 2;
        @KeepForSdk
        public static final int API_PRIORITY_OTHER = Integer.MAX_VALUE;

        @KeepForSdk
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @KeepForSdk
        public List<Scope> getImpliedScopes(O o) {
            return Collections.emptyList();
        }
    }
}

