/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzcs;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.api.internal.zzdj;
import com.google.android.gms.common.internal.zzbq;
import java.lang.ref.WeakReference;

public final class zzdh<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zza = null;
    private zzdh<? extends Result> zzb = null;
    private volatile ResultCallbacks<? super R> zzc = null;
    private PendingResult<R> zzd = null;
    private final Object zze = new Object();
    private Status zzf = null;
    private final WeakReference<GoogleApiClient> zzg;
    private final zzdj zzh;
    private boolean zzi = false;

    public zzdh(WeakReference<GoogleApiClient> weakReference) {
        zzbq.zza(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzg = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzg.get();
        this.zzh = new zzdj(this, googleApiClient != null ? googleApiClient.zzc() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zze;
        synchronized (object) {
            zzbq.zza((this.zza == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbq.zza((this.zzc == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zza = resultTransform;
            zzdh<R> zzdh2 = new zzdh<R>(this.zzg);
            this.zzb = zzdh2;
            this.zzb();
            return zzdh2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zze;
        synchronized (object) {
            zzbq.zza((this.zzc == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzbq.zza((this.zza == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzc = resultCallbacks;
            this.zzb();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zze;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zza != null) {
                    zzcs.zza().submit(new zzdi(this, (Result)r));
                } else if (this.zzc()) {
                    this.zzc.onSuccess(r);
                }
            } else {
                this.zza(r.getStatus());
                zzdh.zza(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zze;
        synchronized (object) {
            this.zzd = pendingResult;
            this.zzb();
            return;
        }
    }

    private final void zzb() {
        if (this.zza == null && this.zzc == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzg.get();
        if (!this.zzi && this.zza != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzi = true;
        }
        if (this.zzf != null) {
            this.zzb(this.zzf);
            return;
        }
        if (this.zzd != null) {
            this.zzd.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Status status) {
        Object object = this.zze;
        synchronized (object) {
            this.zzf = status;
            this.zzb(this.zzf);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzb(Status status) {
        Object object = this.zze;
        synchronized (object) {
            if (this.zza != null) {
                Status status2 = this.zza.onFailure(status);
                zzbq.zza((Object)status2, (Object)"onFailure must not return null");
                super.zza(status2);
            } else if (this.zzc()) {
                this.zzc.onFailure(status);
            }
            return;
        }
    }

    final void zza() {
        this.zzc = null;
    }

    private final boolean zzc() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzg.get();
        return this.zzc != null && googleApiClient != null;
    }

    private static void zza(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zza(zzdh zzdh2) {
        return zzdh2.zza;
    }

    static /* synthetic */ zzdj zzb(zzdh zzdh2) {
        return zzdh2.zzh;
    }

    static /* synthetic */ void zza(zzdh zzdh2, Result result) {
        zzdh.zza(result);
    }

    static /* synthetic */ WeakReference zzc(zzdh zzdh2) {
        return zzdh2.zzg;
    }

    static /* synthetic */ Object zzd(zzdh zzdh2) {
        return zzdh2.zze;
    }

    static /* synthetic */ zzdh zze(zzdh zzdh2) {
        return zzdh2.zzb;
    }

    static /* synthetic */ void zza(zzdh zzdh2, Status status) {
        zzdh2.zza(status);
    }
}

