/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzae;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbq;
import com.google.android.gms.common.api.internal.zzbr;
import com.google.android.gms.common.api.internal.zzbs;
import com.google.android.gms.common.api.internal.zzbu;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzcr;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.internal.zzbz;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbo<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzu {
    private final Queue<zza> zzb = new LinkedList<zza>();
    private final Api.zze zzc;
    private final Api.zzb zzd;
    private final zzh<O> zze;
    private final zzae zzf;
    private final Set<zzj> zzg = new HashSet<zzj>();
    private final Map<zzck<?>, zzcr> zzh = new HashMap();
    private final int zzi;
    private final zzcv zzj;
    private boolean zzk;
    private int zzl = -1;
    private ConnectionResult zzm = null;
    final /* synthetic */ zzbm zza;

    private final void zzn() {
        this.zzl = -1;
        zzbm.zza(this.zza, -1);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbo(zzbm zzbm2, GoogleApi googleApi) {
        this.zza = zzbm2;
        this.zzc = googleApi.zza(zzbm.zza(zzbm2).getLooper(), this);
        this.zzd = this.zzc instanceof zzbz ? zzbz.zzi() : this.zzc;
        this.zze = googleApi.zzc();
        this.zzf = new zzae();
        this.zzi = googleApi.zzd();
        if (this.zzc.l_()) {
            this.zzj = googleApi.zza(zzbm.zzc(zzbm2), zzbm.zza(zzbm2));
            return;
        }
        this.zzj = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzbm.zza(this.zza).getLooper()) {
            this.zzo();
            return;
        }
        zzbm.zza(this.zza).post((Runnable)new zzbp(this));
    }

    @WorkerThread
    private final void zzo() {
        this.zzd();
        this.zzb(ConnectionResult.zza);
        this.zzq();
        for (zzcr zzcr2 : this.zzh.values()) {
            try {
                zzcr2.zza.zza(this.zzd, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzc.zzg();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbo zzbo2 = this;
        while (zzbo2.zzc.zzs() && !zzbo2.zzb.isEmpty()) {
            zza zza2 = zzbo2.zzb.remove();
            zzbo2.zzb(zza2);
        }
        this.zzr();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzbm.zza(this.zza).getLooper()) {
            this.zzp();
            return;
        }
        zzbm.zza(this.zza).post((Runnable)new zzbq(this));
    }

    @WorkerThread
    private final void zzp() {
        this.zzd();
        this.zzk = true;
        this.zzf.zzc();
        zzbm.zza(this.zza).sendMessageDelayed(Message.obtain((Handler)zzbm.zza(this.zza), (int)9, this.zze), zzbm.zzd(this.zza));
        zzbm.zza(this.zza).sendMessageDelayed(Message.obtain((Handler)zzbm.zza(this.zza), (int)11, this.zze), zzbm.zze(this.zza));
        this.zzn();
    }

    @WorkerThread
    public final void zza(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        this.zzc.zzg();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzbm.zza(this.zza).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzbm.zza(this.zza).post((Runnable)new zzbr(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        if (this.zzj != null) {
            this.zzj.zzb();
        }
        this.zzd();
        this.zzn();
        this.zzb(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zza(zzbm.zzf());
            return;
        }
        if (this.zzb.isEmpty()) {
            this.zzm = connectionResult;
            return;
        }
        Object object = zzbm.zzg();
        synchronized (object) {
            if (zzbm.zzf(this.zza) != null && zzbm.zzg(this.zza).contains(this.zze)) {
                zzbm.zzf(this.zza).zzb(connectionResult, this.zzi);
                return;
            }
        }
        if (!this.zza.zza(connectionResult, this.zzi)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzk = true;
            }
            if (this.zzk) {
                zzbm.zza(this.zza).sendMessageDelayed(Message.obtain((Handler)zzbm.zza(this.zza), (int)9, this.zze), zzbm.zzd(this.zza));
                return;
            }
            object = this.zze.zza();
            this.zza(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zza zza2) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        if (this.zzc.zzs()) {
            this.zzb(zza2);
            this.zzr();
            return;
        }
        this.zzb.add(zza2);
        if (this.zzm != null && this.zzm.hasResolution()) {
            this.onConnectionFailed(this.zzm);
            return;
        }
        this.zzi();
    }

    @WorkerThread
    public final void zza() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        this.zza(zzbm.zza);
        this.zzf.zzb();
        for (zzck zzck2 : this.zzh.keySet().toArray(new zzck[this.zzh.size()])) {
            this.zza(new zzf(zzck2, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
        }
        this.zzb(new ConnectionResult(4));
        if (this.zzc.zzs()) {
            this.zzc.zza(new zzbs(this));
        }
    }

    public final Api.zze zzb() {
        return this.zzc;
    }

    public final Map<zzck<?>, zzcr> zzc() {
        return this.zzh;
    }

    @WorkerThread
    public final void zzd() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        this.zzm = null;
    }

    @WorkerThread
    public final ConnectionResult zze() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        return this.zzm;
    }

    @WorkerThread
    private final void zzb(zza zza2) {
        zza2.zza(this.zzf, this.zzk());
        try {
            zza2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzc.zzg();
            return;
        }
    }

    @WorkerThread
    public final void zza(Status status) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        Iterator iterator = this.zzb.iterator();
        while (iterator.hasNext()) {
            ((zza)iterator.next()).zza(status);
        }
        this.zzb.clear();
    }

    @WorkerThread
    public final void zzf() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        if (this.zzk) {
            this.zzi();
        }
    }

    @WorkerThread
    private final void zzq() {
        if (this.zzk) {
            zzbm.zza(this.zza).removeMessages(11, this.zze);
            zzbm.zza(this.zza).removeMessages(9, this.zze);
            this.zzk = false;
        }
    }

    @WorkerThread
    public final void zzg() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        if (this.zzk) {
            this.zzq();
            Status status = zzbm.zzh(this.zza).isGooglePlayServicesAvailable(zzbm.zzc(this.zza)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zza(status);
            this.zzc.zzg();
        }
    }

    private final void zzr() {
        zzbm.zza(this.zza).removeMessages(12, this.zze);
        zzbm.zza(this.zza).sendMessageDelayed(zzbm.zza(this.zza).obtainMessage(12, this.zze), zzbm.zzi(this.zza));
    }

    @WorkerThread
    public final void zzh() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        if (this.zzc.zzs() && this.zzh.size() == 0) {
            if (this.zzf.zza()) {
                this.zzr();
                return;
            }
            this.zzc.zzg();
        }
    }

    @WorkerThread
    public final void zzi() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        if (this.zzc.zzs() || this.zzc.zzt()) {
            return;
        }
        if (this.zzc.zzu()) {
            zzbo zzbo2 = this;
            zzbo2.zzc.zzx();
            if (zzbm.zzb(zzbo2.zza) != 0) {
                int n;
                zzbm.zzh(this.zza);
                int n2 = n = GoogleApiAvailability.zza((Context)zzbm.zzc(this.zza), (int)this.zzc.zzx());
                zzbo2 = this;
                zzbo2.zzc.zzx();
                zzbm.zza(zzbo2.zza, n2);
                if (n != 0) {
                    ConnectionResult connectionResult = new ConnectionResult(n, null);
                    this.onConnectionFailed(connectionResult);
                    return;
                }
            }
        }
        zzbu zzbu2 = new zzbu(this.zza, this.zzc, this.zze);
        if (this.zzc.l_()) {
            this.zzj.zza(zzbu2);
        }
        this.zzc.zza(zzbu2);
    }

    @WorkerThread
    public final void zza(zzj zzj2) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zza));
        this.zzg.add(zzj2);
    }

    @WorkerThread
    private final void zzb(ConnectionResult connectionResult) {
        for (zzj zzj2 : this.zzg) {
            String string2 = null;
            if (connectionResult == ConnectionResult.zza) {
                string2 = this.zzc.zzw();
            }
            zzj2.zza(this.zze, connectionResult, string2);
        }
        this.zzg.clear();
    }

    final boolean zzj() {
        return this.zzc.zzs();
    }

    public final boolean zzk() {
        return this.zzc.l_();
    }

    public final int zzl() {
        return this.zzi;
    }

    final zzcyj zzm() {
        if (this.zzj == null) {
            return null;
        }
        return this.zzj.zza();
    }

    static /* synthetic */ void zza(zzbo zzbo2) {
        zzbo2.zzo();
    }

    static /* synthetic */ void zzb(zzbo zzbo2) {
        zzbo2.zzp();
    }

    static /* synthetic */ Api.zze zzc(zzbo zzbo2) {
        return zzbo2.zzc;
    }
}

