/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArraySet;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzah;
import com.google.android.gms.common.api.internal.zzbn;
import com.google.android.gms.common.api.internal.zzbo;
import com.google.android.gms.common.api.internal.zzc;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzcp;
import com.google.android.gms.common.api.internal.zzcq;
import com.google.android.gms.common.api.internal.zzcr;
import com.google.android.gms.common.api.internal.zzd;
import com.google.android.gms.common.api.internal.zzda;
import com.google.android.gms.common.api.internal.zzde;
import com.google.android.gms.common.api.internal.zzdo;
import com.google.android.gms.common.api.internal.zze;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@Hide
public final class zzbm
implements Handler.Callback {
    public static final Status zza = new Status(4, "Sign-out occurred while this API call was in progress.");
    private static final Status zzb = new Status(4, "The user must be signed in to make this API call.");
    private long zzc = 5000L;
    private long zzd = 120000L;
    private long zze = 10000L;
    private static final Object zzf = new Object();
    private static zzbm zzg;
    private final Context zzh;
    private final GoogleApiAvailability zzi;
    private int zzj = -1;
    private final AtomicInteger zzk = new AtomicInteger(1);
    private final AtomicInteger zzl = new AtomicInteger(0);
    private final Map<zzh<?>, zzbo<?>> zzm = new ConcurrentHashMap(5, 0.75f, 1);
    private zzah zzn = null;
    private final Set<zzh<?>> zzo = new ArraySet();
    private final Set<zzh<?>> zzp = new ArraySet();
    private final Handler zzq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbm zza(Context context) {
        Object object = zzf;
        synchronized (object) {
            if (zzg == null) {
                HandlerThread handlerThread = new HandlerThread("GoogleApiHandler", 9);
                handlerThread.start();
                Looper looper = handlerThread.getLooper();
                zzg = new zzbm(context.getApplicationContext(), looper, GoogleApiAvailability.getInstance());
            }
            return zzg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbm zza() {
        Object object = zzf;
        synchronized (object) {
            zzbq.zza((Object)zzg, (Object)"Must guarantee manager is non-null before using getInstance");
            return zzg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzb() {
        Object object = zzf;
        synchronized (object) {
            if (zzg != null) {
                zzbm zzbm2 = zzg;
                zzbm2.zzl.incrementAndGet();
                zzbm2.zzq.sendMessageAtFrontOfQueue(zzbm2.zzq.obtainMessage(10));
            }
            return;
        }
    }

    private zzbm(Context context, Looper looper, GoogleApiAvailability googleApiAvailability) {
        this.zzh = context;
        this.zzq = new Handler(looper, (Handler.Callback)this);
        this.zzi = googleApiAvailability;
        this.zzq.sendMessage(this.zzq.obtainMessage(6));
    }

    public final int zzc() {
        return this.zzk.getAndIncrement();
    }

    public final void zza(GoogleApi<?> googleApi) {
        this.zzq.sendMessage(this.zzq.obtainMessage(7, googleApi));
    }

    @WorkerThread
    private final void zzb(GoogleApi<?> googleApi) {
        zzh<?> zzh2 = googleApi.zzc();
        zzbo<Object> zzbo2 = this.zzm.get(zzh2);
        if (zzbo2 == null) {
            zzbo2 = new zzbo(this, googleApi);
            this.zzm.put(zzh2, zzbo2);
        }
        if (zzbo2.zzk()) {
            this.zzp.add(zzh2);
        }
        zzbo2.zzi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(@NonNull zzah zzah2) {
        Object object = zzf;
        synchronized (object) {
            if (this.zzn != zzah2) {
                this.zzn = zzah2;
                this.zzo.clear();
                this.zzo.addAll((Collection<zzh<?>>)zzah2.zzf());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzb(@NonNull zzah zzah2) {
        Object object = zzf;
        synchronized (object) {
            if (this.zzn == zzah2) {
                this.zzn = null;
                this.zzo.clear();
            }
            return;
        }
    }

    public final Task<Map<zzh<?>, String>> zza(Iterable<? extends GoogleApi<?>> iterable) {
        zzj zzj2 = new zzj(iterable);
        for (GoogleApi<?> googleApi : iterable) {
            zzbo<?> zzbo2 = this.zzm.get(googleApi.zzc());
            if (zzbo2 == null || !zzbo2.zzj()) {
                this.zzq.sendMessage(this.zzq.obtainMessage(2, (Object)zzj2));
                return zzj2.zzb();
            }
            zzj2.zza(googleApi.zzc(), ConnectionResult.zza, zzbo2.zzb().zzw());
        }
        return zzj2.zzb();
    }

    public final void zzd() {
        this.zzq.sendMessage(this.zzq.obtainMessage(3));
    }

    final void zze() {
        this.zzl.incrementAndGet();
        this.zzq.sendMessage(this.zzq.obtainMessage(10));
    }

    @WorkerThread
    private final void zzh() {
        for (zzh<?> zzh2 : this.zzp) {
            this.zzm.remove(zzh2).zza();
        }
        this.zzp.clear();
    }

    public final <O extends Api.ApiOptions> void zza(GoogleApi<O> googleApi, int n, zzm<? extends Result, Api.zzb> zzm2) {
        zzc<zzm<? extends Result, Api.zzb>> zzc2 = new zzc<zzm<? extends Result, Api.zzb>>(n, zzm2);
        this.zzq.sendMessage(this.zzq.obtainMessage(4, (Object)new zzcp(zzc2, this.zzl.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions, TResult> void zza(GoogleApi<O> googleApi, int n, zzde<Api.zzb, TResult> zzde2, TaskCompletionSource<TResult> taskCompletionSource, zzda zzda2) {
        zze<TResult> zze2 = new zze<TResult>(n, zzde2, taskCompletionSource, zzda2);
        this.zzq.sendMessage(this.zzq.obtainMessage(4, (Object)new zzcp(zze2, this.zzl.get(), googleApi)));
    }

    public final <O extends Api.ApiOptions> Task<Void> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzcq<Api.zzb, ?> zzcq2, @NonNull zzdo<Api.zzb, ?> zzdo2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzd zzd2 = new zzd(new zzcr(zzcq2, zzdo2), (TaskCompletionSource<Void>)taskCompletionSource);
        this.zzq.sendMessage(this.zzq.obtainMessage(8, (Object)new zzcp(zzd2, this.zzl.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    public final <O extends Api.ApiOptions> Task<Boolean> zza(@NonNull GoogleApi<O> googleApi, @NonNull zzck<?> zzck2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        zzf zzf2 = new zzf(zzck2, (TaskCompletionSource<Boolean>)taskCompletionSource);
        this.zzq.sendMessage(this.zzq.obtainMessage(13, (Object)new zzcp(zzf2, this.zzl.get(), googleApi)));
        return taskCompletionSource.getTask();
    }

    @WorkerThread
    public final boolean handleMessage(Message message) {
        block0 : switch (message.what) {
            case 1: {
                boolean bl = (Boolean)message.obj;
                zzbm zzbm2 = this;
                this.zze = bl ? 10000L : 300000L;
                zzbm2.zzq.removeMessages(12);
                for (zzh<?> zzh2 : zzbm2.zzm.keySet()) {
                    zzbm2.zzq.sendMessageDelayed(zzbm2.zzq.obtainMessage(12, zzh2), zzbm2.zze);
                }
                break;
            }
            case 2: {
                zzj zzj2 = (zzj)message.obj;
                zzbm zzbm3 = this;
                for (zzh<?> zzh3 : zzj2.zza()) {
                    zzbo<?> zzbo2 = zzbm3.zzm.get(zzh3);
                    if (zzbo2 == null) {
                        ConnectionResult connectionResult = new ConnectionResult(13);
                        zzj2.zza(zzh3, connectionResult, null);
                        break block0;
                    }
                    if (zzbo2.zzj()) {
                        zzj2.zza(zzh3, ConnectionResult.zza, zzbo2.zzb().zzw());
                        continue;
                    }
                    if (zzbo2.zze() != null) {
                        zzj2.zza(zzh3, zzbo2.zze(), null);
                        continue;
                    }
                    zzbo2.zza(zzj2);
                }
                break;
            }
            case 3: {
                for (zzbo<?> zzbo3 : this.zzm.values()) {
                    zzbo3.zzd();
                    zzbo3.zzi();
                }
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                zzcp zzcp2 = (zzcp)message.obj;
                zzbm zzbm4 = this;
                zzbo<?> zzbo4 = zzbm4.zzm.get(zzcp2.zzc.zzc());
                if (zzbo4 == null) {
                    zzbm4.zzb(zzcp2.zzc);
                    zzbo4 = zzbm4.zzm.get(zzcp2.zzc.zzc());
                }
                if (zzbo4.zzk() && zzbm4.zzl.get() != zzcp2.zzb) {
                    zzcp2.zza.zza(zza);
                    zzbo4.zza();
                    break;
                }
                zzbo4.zza(zzcp2.zza);
                break;
            }
            case 5: {
                ConnectionResult connectionResult = (ConnectionResult)message.obj;
                int n = message.arg1;
                zzbm zzbm5 = this;
                zzbo<?> zzbo5 = null;
                for (zzbo<?> zzbo6 : zzbm5.zzm.values()) {
                    if (zzbo6.zzl() != n) continue;
                    zzbo5 = zzbo6;
                    break;
                }
                if (zzbo5 != null) {
                    zzbo<?> zzbo6;
                    String string2 = zzbm5.zzi.getErrorString(connectionResult.getErrorCode());
                    zzbo6 = connectionResult.getErrorMessage();
                    zzbo5.zza(new Status(17, new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(zzbo6).length()).append("Error resolution was canceled by the user, original error message: ").append(string2).append(": ").append((String)((Object)zzbo6)).toString()));
                    break;
                }
                Log.wtf((String)"GoogleApiManager", (String)new StringBuilder(76).append("Could not find API instance ").append(n).append(" while trying to fail enqueued calls.").toString(), (Throwable)new Exception());
                break;
            }
            case 6: {
                zzbm zzbm6 = this;
                if (!(zzbm6.zzh.getApplicationContext() instanceof Application)) break;
                com.google.android.gms.common.api.internal.zzk.zza((Application)((Application)zzbm6.zzh.getApplicationContext()));
                com.google.android.gms.common.api.internal.zzk.zza().zza((zzl)new zzbn(zzbm6));
                if (com.google.android.gms.common.api.internal.zzk.zza().zza(true)) break;
                zzbm6.zze = 300000L;
                break;
            }
            case 7: {
                this.zzb((GoogleApi)message.obj);
                break;
            }
            case 9: {
                if (!this.zzm.containsKey(message.obj)) break;
                this.zzm.get(message.obj).zzf();
                break;
            }
            case 10: {
                this.zzh();
                break;
            }
            case 11: {
                if (!this.zzm.containsKey(message.obj)) break;
                this.zzm.get(message.obj).zzg();
                break;
            }
            case 12: {
                if (!this.zzm.containsKey(message.obj)) break;
                this.zzm.get(message.obj).zzh();
                break;
            }
            default: {
                int n = message.what;
                Log.w((String)"GoogleApiManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                return false;
            }
        }
        return true;
    }

    final PendingIntent zza(zzh<?> zzh2, int n) {
        zzbo<?> zzbo2 = this.zzm.get(zzh2);
        if (zzbo2 == null) {
            return null;
        }
        zzcyj zzcyj2 = zzbo2.zzm();
        if (zzcyj2 == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.zzh, (int)n, (Intent)zzcyj2.zzf(), (int)0x8000000);
    }

    final boolean zza(ConnectionResult connectionResult, int n) {
        return this.zzi.zza(this.zzh, connectionResult, n);
    }

    public final void zzb(ConnectionResult connectionResult, int n) {
        if (!this.zza(connectionResult, n)) {
            this.zzq.sendMessage(this.zzq.obtainMessage(5, n, 0, (Object)connectionResult));
        }
    }

    static /* synthetic */ Handler zza(zzbm zzbm2) {
        return zzbm2.zzq;
    }

    static /* synthetic */ int zzb(zzbm zzbm2) {
        return zzbm2.zzj;
    }

    static /* synthetic */ int zza(zzbm zzbm2, int n) {
        zzbm2.zzj = n;
        return zzbm2.zzj;
    }

    static /* synthetic */ Context zzc(zzbm zzbm2) {
        return zzbm2.zzh;
    }

    static /* synthetic */ long zzd(zzbm zzbm2) {
        return zzbm2.zzc;
    }

    static /* synthetic */ long zze(zzbm zzbm2) {
        return zzbm2.zzd;
    }

    static /* synthetic */ Status zzf() {
        return zzb;
    }

    static /* synthetic */ Object zzg() {
        return zzf;
    }

    static /* synthetic */ zzah zzf(zzbm zzbm2) {
        return zzbm2.zzn;
    }

    static /* synthetic */ Set zzg(zzbm zzbm2) {
        return zzbm2.zzo;
    }

    static /* synthetic */ GoogleApiAvailability zzh(zzbm zzbm2) {
        return zzbm2.zzi;
    }

    static /* synthetic */ long zzi(zzbm zzbm2) {
        return zzbm2.zze;
    }

    static /* synthetic */ Map zzj(zzbm zzbm2) {
        return zzbm2.zzm;
    }
}

