/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzaa;
import com.google.android.gms.common.api.internal.zzbb;
import com.google.android.gms.common.api.internal.zzbc;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbe;
import com.google.android.gms.common.api.internal.zzbf;
import com.google.android.gms.common.api.internal.zzbg;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzbx;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzce;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzcm;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzdb;
import com.google.android.gms.common.api.internal.zzdh;
import com.google.android.gms.common.api.internal.zzdk;
import com.google.android.gms.common.api.internal.zzdn;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzbgs;
import com.google.android.gms.internal.zzcyj;
import com.google.android.gms.internal.zzcyk;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzba
extends GoogleApiClient
implements zzcd {
    private final Lock zzf;
    private boolean zzg;
    private final zzae zzh;
    private zzcc zzi = null;
    private final int zzj;
    private final Context zzk;
    private final Looper zzl;
    final Queue<zzm<?, ?>> zza = new LinkedList();
    private volatile boolean zzm;
    private long zzn = 120000L;
    private long zzo = 5000L;
    private final zzbf zzp;
    private final GoogleApiAvailability zzq;
    private zzbx zzr;
    final Map<Api.zzc<?>, Api.zze> zzb;
    Set<Scope> zzc = new HashSet<Scope>();
    private zzr zzs;
    private Map<Api<?>, Boolean> zzt;
    private Api.zza<? extends zzcyj, zzcyk> zzu;
    private final zzcm zzv = new zzcm();
    private final ArrayList<zzt> zzw;
    private Integer zzx = null;
    Set<zzdh> zzd = null;
    final zzdk zze;
    private final zzaf zzy = new zzbb(this);

    public zzba(Context context, Lock lock, Looper looper, zzr zzr2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzcyj, zzcyk> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzt> arrayList, boolean bl) {
        this.zzk = context;
        this.zzf = lock;
        this.zzg = false;
        this.zzh = new zzae(looper, this.zzy);
        this.zzl = looper;
        this.zzp = new zzbf(this, looper);
        this.zzq = googleApiAvailability;
        this.zzj = n;
        if (this.zzj >= 0) {
            this.zzx = n2;
        }
        this.zzt = map;
        this.zzb = map2;
        this.zzw = arrayList;
        this.zze = new zzdk(this.zzb);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzh.zza(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzh.zza(onConnectionFailedListener);
        }
        this.zzs = zzr2;
        this.zzu = zza2;
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zza(@NonNull T t) {
        zzbq.zzb((t.zzc() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzd() != null ? t.zzd().zzd() : "the API";
        zzbq.zzb((boolean)this.zzb.containsKey(t.zzc()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzf.lock();
        try {
            if (this.zzi == null) {
                this.zza.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzi.zza(t);
            return (T)string2;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        zzbq.zzb((t.zzc() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzd() != null ? t.zzd().zzd() : "the API";
        zzbq.zzb((boolean)this.zzb.containsKey(t.zzc()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzf.lock();
        try {
            if (this.zzi == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzm) {
                this.zza.add(t);
                while (!this.zza.isEmpty()) {
                    object = this.zza.remove();
                    this.zze.zza((BasePendingResult<? extends Result>)object);
                    ((zzm)object).zzc(Status.zzc);
                }
                object = t;
                return (T)object;
            }
            object = this.zzi.zzb(t);
            return (T)object;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final <L> zzci<L> zza(@NonNull L l) {
        this.zzf.lock();
        try {
            Looper looper = this.zzl;
            L l2 = l;
            zzci<L> zzci2 = this.zzv.zza(l2, looper, "NO_TYPE");
            return zzci2;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzb.get(zzc2);
        zzbq.zza((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public final boolean zza(@NonNull Api<?> api) {
        return this.zzb.containsKey(api.zzc());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzb.get(api.zzc());
        return zze2 != null && zze2.zzs();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzf.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zzm) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzb.containsKey(api.zzc())) break block6;
                    connectionResult = this.zzi.zza(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzm) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.zza;
                    this.zzf.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzh());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.zzd()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzf.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.zzd()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzf.lock();
        try {
            if (this.zzj >= 0) {
                zzbq.zza((this.zzx != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzx == null) {
                this.zzx = zzba.zza(this.zzb.values(), false);
            } else if (this.zzx == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zzx);
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzf.lock();
        try {
            zzbq.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zza(n);
            this.zzi();
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzf.lock();
        try {
            if (this.zzj >= 0) {
                zzbq.zza((this.zzx != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzx == null) {
                this.zzx = zzba.zza(this.zzb.values(), false);
            } else if (this.zzx == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zza(this.zzx);
            this.zzh.zzb();
            ConnectionResult connectionResult = this.zzi.zzb();
            return connectionResult;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzbq.zza((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzf.lock();
        try {
            if (this.zzx == null) {
                this.zzx = zzba.zza(this.zzb.values(), false);
            } else if (this.zzx == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zza(this.zzx);
            this.zzh.zzb();
            ConnectionResult connectionResult = this.zzi.zza(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzf.lock();
        try {
            this.zze.zza();
            if (this.zzi != null) {
                this.zzi.zzc();
            }
            this.zzv.zza();
            for (zzm zzm2 : this.zza) {
                ((BasePendingResult)zzm2).zza((zzdn)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zza.clear();
            if (this.zzi == null) {
                return;
            }
            this.zzf();
            this.zzh.zza();
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzbq.zza((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzbq.zza((this.zzx != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        zzdb zzdb2 = new zzdb(this);
        if (this.zzb.containsKey(zzbgs.zza)) {
            this.zza(this, zzdb2, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzbc zzbc2 = new zzbc(this, atomicReference, zzdb2);
            zzbd zzbd2 = new zzbd(this, zzdb2);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.zzk).addApi(zzbgs.zzb).addConnectionCallbacks(zzbc2).addOnConnectionFailedListener(zzbd2).setHandler(this.zzp).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzdb2;
    }

    private final void zza(GoogleApiClient googleApiClient, zzdb zzdb2, boolean bl) {
        zzbgs.zzc.zza(googleApiClient).setResultCallback(new zzbe(this, zzdb2, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        zzce zzce2 = new zzce((Activity)fragmentActivity);
        zzba zzba2 = this;
        if (zzba2.zzj >= 0) {
            com.google.android.gms.common.api.internal.zzi.zza(zzce2).zza(zzba2.zzj);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzi != null && this.zzi.zzd();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzi != null && this.zzi.zze();
    }

    private final void zza(int n) {
        if (this.zzx == null) {
            this.zzx = n;
        } else if (this.zzx != n) {
            String string2 = zzba.zzb(n);
            String string3 = zzba.zzb(this.zzx);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzi != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzb.values()) {
            if (zze2.l_()) {
                bl = true;
            }
            if (!zze2.zze()) continue;
            bl2 = true;
        }
        switch (this.zzx) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzg) {
                    this.zzi = new zzaa(this.zzk, this.zzf, this.zzl, this.zzq, this.zzb, this.zzs, this.zzt, this.zzu, this.zzw, this, true);
                    return;
                }
                this.zzi = com.google.android.gms.common.api.internal.zzv.zza(this.zzk, this, this.zzf, this.zzl, this.zzq, this.zzb, this.zzs, this.zzt, this.zzu, this.zzw);
                return;
            }
        }
        if (this.zzg && !bl2) {
            this.zzi = new zzaa(this.zzk, this.zzf, this.zzl, this.zzq, this.zzb, this.zzs, this.zzt, this.zzu, this.zzw, this, false);
            return;
        }
        this.zzi = new zzbi(this.zzk, this, this.zzf, this.zzl, this.zzq, this.zzb, this.zzs, this.zzt, this.zzu, this.zzw, this);
    }

    private final void zzi() {
        this.zzh.zzb();
        this.zzi.zza();
    }

    private final void zzj() {
        this.zzf.lock();
        try {
            if (this.zzm) {
                this.zzi();
            }
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    private final void zzk() {
        this.zzf.lock();
        try {
            if (this.zzf()) {
                this.zzi();
            }
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    final boolean zzf() {
        if (!this.zzm) {
            return false;
        }
        this.zzm = false;
        this.zzp.removeMessages(2);
        this.zzp.removeMessages(1);
        if (this.zzr != null) {
            this.zzr.zza();
            this.zzr = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzh.zza(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzh.zzb(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzh.zzc(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzh.zza(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzh.zzb(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzh.zzc(onConnectionFailedListener);
    }

    @Override
    public final void zza(Bundle bundle) {
        while (!this.zza.isEmpty()) {
            ((GoogleApiClient)this).zzb(this.zza.remove());
        }
        this.zzh.zza(bundle);
    }

    @Override
    public final void zza(ConnectionResult connectionResult) {
        if (!com.google.android.gms.common.zzf.zzb((Context)this.zzk, (int)connectionResult.getErrorCode())) {
            this.zzf();
        }
        if (!this.zzm) {
            this.zzh.zza(connectionResult);
            this.zzh.zza();
        }
    }

    @Override
    public final void zza(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzba zzba2 = this;
            if (!zzba2.zzm) {
                zzba2.zzm = true;
                if (zzba2.zzr == null) {
                    zzba2.zzr = GoogleApiAvailability.zza(zzba2.zzk.getApplicationContext(), new zzbg(zzba2));
                }
                zzba2.zzp.sendMessageDelayed(zzba2.zzp.obtainMessage(1), zzba2.zzn);
                zzba2.zzp.sendMessageDelayed(zzba2.zzp.obtainMessage(2), zzba2.zzo);
            }
        }
        this.zze.zzb();
        this.zzh.zza(n);
        this.zzh.zza();
        if (n == 2) {
            this.zzi();
        }
    }

    @Override
    public final Context zzb() {
        return this.zzk;
    }

    @Override
    public final Looper zzc() {
        return this.zzl;
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        return this.zzi != null && this.zzi.zza(zzcu2);
    }

    @Override
    public final void zzd() {
        if (this.zzi != null) {
            this.zzi.zzg();
        }
    }

    @Override
    public final void zza(zzdh zzdh2) {
        this.zzf.lock();
        try {
            if (this.zzd == null) {
                this.zzd = new HashSet<zzdh>();
            }
            this.zzd.add(zzdh2);
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    @Override
    public final void zzb(zzdh zzdh2) {
        this.zzf.lock();
        try {
            if (this.zzd == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzd.remove(zzdh2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzg()) {
                this.zzi.zzf();
            }
            return;
        }
        finally {
            this.zzf.unlock();
        }
    }

    final boolean zzg() {
        this.zzf.lock();
        try {
            if (this.zzd == null) {
                return false;
            }
            boolean bl = !this.zzd.isEmpty();
            return bl;
        }
        finally {
            this.zzf.unlock();
        }
    }

    final String zzh() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.zzk);
        printWriter.append(string2).append("mResuming=").print(this.zzm);
        printWriter.append(" mWorkQueue.size()=").print(this.zza.size());
        PrintWriter printWriter2 = printWriter;
        zzdk zzdk2 = this.zze;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzdk2.zzb.size());
        if (this.zzi != null) {
            this.zzi.zza(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.l_()) {
                bl2 = true;
            }
            if (!zze2.zze()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzb(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzba zzba2) {
        zzba2.zzj();
    }

    static /* synthetic */ void zzb(zzba zzba2) {
        zzba2.zzk();
    }

    static /* synthetic */ void zza(zzba zzba2, GoogleApiClient googleApiClient, zzdb zzdb2, boolean bl) {
        zzba2.zza(googleApiClient, zzdb2, true);
    }

    static /* synthetic */ Context zzc(zzba zzba2) {
        return zzba2.zzk;
    }
}

