/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzdh;
import com.google.android.gms.common.api.internal.zzdn;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzaq;
import com.google.android.gms.common.internal.zzbq;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@Hide
@KeepName
public abstract class BasePendingResult<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzc = new zzs();
    private final Object zza = new Object();
    @Hide
    private zza<R> zzb;
    private WeakReference<GoogleApiClient> zzd;
    private final CountDownLatch zze = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzf = new ArrayList();
    private ResultCallback<? super R> zzg;
    private final AtomicReference<zzdn> zzh = new AtomicReference();
    private R zzi;
    private Status zzj;
    @KeepName
    private zzb mResultGuardian;
    private volatile boolean zzk;
    private boolean zzl;
    private boolean zzm;
    private zzaq zzn;
    private volatile zzdh<R> zzo;
    private boolean zzp = false;

    @Deprecated
    BasePendingResult() {
        this.zzb = new zza(Looper.getMainLooper());
        this.zzd = new WeakReference<Object>(null);
    }

    protected BasePendingResult(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.zzc() : Looper.getMainLooper();
        this.zzb = new zza(looper);
        this.zzd = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected BasePendingResult(Looper looper) {
        this.zzb = new zza(looper);
        this.zzd = new WeakReference<Object>(null);
    }

    @Hide
    public final boolean zze() {
        return this.zze.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzbq.zzc((String)"await must not be called on the UI thread");
        zzbq.zza((!this.zzk ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzbq.zza((this.zzo == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zze.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzd(Status.zzb);
        }
        zzbq.zza((boolean)this.zze(), (Object)"Result is not ready.");
        return this.zza();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        if (l > 0L) {
            zzbq.zzc((String)"await must not be called on the UI thread when time is greater than zero.");
        }
        zzbq.zza((!this.zzk ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzbq.zza((this.zzo == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zze.await(l, timeUnit)) {
                this.zzd(Status.zzd);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzd(Status.zzb);
        }
        zzbq.zza((boolean)this.zze(), (Object)"Result is not ready.");
        return this.zza();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zza;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzg = null;
                return;
            }
            zzbq.zza((!this.zzk ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((this.zzo == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.zze()) {
                this.zzb.zza(resultCallback, (R)this.zza());
            } else {
                this.zzg = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zza;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzg = null;
                return;
            }
            zzbq.zza((!this.zzk ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((this.zzo == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.zze()) {
                this.zzb.zza(resultCallback, (R)this.zza());
            } else {
                this.zzg = resultCallback;
                long l2 = timeUnit.toMillis(l);
                BasePendingResult basePendingResult = this;
                zza<R> zza2 = this.zzb;
                zza2.sendMessageDelayed(zza2.obtainMessage(2, basePendingResult), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Hide
    public final void zza(PendingResult.zza zza2) {
        zzbq.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zza;
        synchronized (object) {
            if (this.zze()) {
                zza2.zza(this.zzj);
            } else {
                this.zzf.add(zza2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zza;
        synchronized (object) {
            if (this.zzl || this.zzk) {
                return;
            }
            if (this.zzn != null) {
                try {
                    this.zzn.zza();
                }
                catch (RemoteException remoteException) {}
            }
            BasePendingResult.zzb(this.zzi);
            this.zzl = true;
            this.zzc(this.zza(Status.zze));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public final boolean zzf() {
        Object object = this.zza;
        synchronized (object) {
            if ((GoogleApiClient)this.zzd.get() == null || !this.zzp) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zza;
        synchronized (object) {
            return this.zzl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Hide
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzbq.zza((!this.zzk ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zza;
        synchronized (object) {
            zzbq.zza((this.zzo == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbq.zza((this.zzg == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzbq.zza((!this.zzl ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzp = true;
            this.zzo = new zzdh(this.zzd);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zzo).then(resultTransform);
            if (this.zze()) {
                this.zzb.zza(this.zzo, this.zza());
            } else {
                this.zzg = this.zzo;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public final void zza(R r) {
        Object object = this.zza;
        synchronized (object) {
            if (!this.zzm && !this.zzl) {
                if (this.zze()) {
                    // empty if block
                }
            } else {
                BasePendingResult.zzb(r);
                return;
            }
            zzbq.zza((!this.zze() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzbq.zza((!this.zzk ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public final void zzd(Status status) {
        Object object = this.zza;
        synchronized (object) {
            if (!this.zze()) {
                this.zza(this.zza(status));
                this.zzm = true;
            }
            return;
        }
    }

    @Hide
    @NonNull
    protected abstract R zza(Status var1);

    @Hide
    public final void zza(zzdn zzdn2) {
        this.zzh.set(zzdn2);
    }

    @Override
    @Hide
    public final Integer zzb() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    protected final void zza(zzaq zzaq2) {
        Object object = this.zza;
        synchronized (object) {
            this.zzn = zzaq2;
            return;
        }
    }

    @Hide
    public final void zzg() {
        this.zzp = this.zzp || zzc.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R zza() {
        R r;
        Object object = this.zza;
        synchronized (object) {
            zzbq.zza((!this.zzk ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((boolean)this.zze(), (Object)"Result is not ready.");
            r = this.zzi;
            this.zzi = null;
            this.zzg = null;
            this.zzk = true;
        }
        BasePendingResult basePendingResult = this;
        zzdn zzdn2 = basePendingResult.zzh.getAndSet(null);
        if (zzdn2 != null) {
            zzdn2.zza(basePendingResult);
        }
        return r;
    }

    private final void zzc(R r) {
        this.zzi = r;
        this.zzn = null;
        this.zze.countDown();
        this.zzj = this.zzi.getStatus();
        if (this.zzl) {
            this.zzg = null;
        } else if (this.zzg == null) {
            if (this.zzi instanceof Releasable) {
                this.mResultGuardian = new zzb(this, null);
            }
        } else {
            this.zzb.removeMessages(2);
            this.zzb.zza(this.zzg, (R)this.zza());
        }
        ArrayList<PendingResult.zza> arrayList = this.zzf;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.zza zza2 = arrayList.get(i);
            zza2.zza(this.zzj);
        }
        this.zzf.clear();
    }

    @Hide
    public static void zzb(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    final class zzb {
        private /* synthetic */ BasePendingResult zza;

        private zzb(BasePendingResult basePendingResult) {
            this.zza = basePendingResult;
        }

        protected final void finalize() throws Throwable {
            BasePendingResult.zzb(this.zza.zzi);
            super.finalize();
        }

        /* synthetic */ zzb(BasePendingResult basePendingResult, zzs zzs2) {
            this(basePendingResult);
        }
    }

    @Hide
    public static final class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public final void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public final void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    Result result = (Result)pair.second;
                    ResultCallback resultCallback = (ResultCallback)pair.first;
                    try {
                        resultCallback.onResult(result);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        BasePendingResult.zzb(result);
                        throw runtimeException;
                    }
                }
                case 2: {
                    ((BasePendingResult)message.obj).zzd(Status.zzd);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }
    }
}

