/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.zza;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInAccount
extends zzbgl
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zzb();
    @Hide
    private static zze zza = com.google.android.gms.common.util.zzi.zzd();
    @Hide
    private int zzb;
    private String zzc;
    private String zzd;
    private String zze;
    private String zzf;
    private Uri zzg;
    private String zzh;
    private long zzi;
    private String zzj;
    private List<Scope> zzk;
    private String zzl;
    private String zzm;
    private Set<Scope> zzn = new HashSet<Scope>();

    @Hide
    @Nullable
    public static GoogleSignInAccount zza(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        Uri uri = null;
        String string3 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            uri = Uri.parse((String)string3);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        String string4 = jSONObject.optString("serverAuthCode", null);
        GoogleSignInAccount googleSignInAccount = GoogleSignInAccount.zza(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), jSONObject.optString("givenName", null), jSONObject.optString("familyName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet);
        GoogleSignInAccount.zza(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), jSONObject.optString("givenName", null), jSONObject.optString("familyName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet).zzh = string4;
        return googleSignInAccount;
    }

    @Hide
    private static GoogleSignInAccount zza(@Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable Uri uri, @Nullable Long l, @NonNull String string8, @NonNull Set<Scope> set) {
        if (l == null) {
            l = zza.zza() / 1000L;
        }
        return new GoogleSignInAccount(3, string2, string3, string4, string5, uri, null, l, zzbq.zza((String)string8), new ArrayList<Scope>((Collection)zzbq.zza(set)), string6, string7);
    }

    @Hide
    public static GoogleSignInAccount zza() {
        HashSet<Scope> hashSet = new HashSet<Scope>();
        Account account = new Account("<<default account>>", "com.google");
        return GoogleSignInAccount.zza(null, null, account.name, null, null, null, null, 0L, account.name, hashSet);
    }

    GoogleSignInAccount(int n, String string2, String string3, String string4, String string5, Uri uri, String string6, long l, String string7, List<Scope> list, String string8, String string9) {
        this.zzb = n;
        this.zzc = string2;
        this.zzd = string3;
        this.zze = string4;
        this.zzf = string5;
        this.zzg = uri;
        this.zzh = string6;
        this.zzi = l;
        this.zzj = string7;
        this.zzk = list;
        this.zzl = string8;
        this.zzm = string9;
    }

    @Nullable
    public String getId() {
        return this.zzc;
    }

    @Nullable
    public String getIdToken() {
        return this.zzd;
    }

    @Nullable
    public String getEmail() {
        return this.zze;
    }

    @Nullable
    public Account getAccount() {
        if (this.zze == null) {
            return null;
        }
        return new Account(this.zze, "com.google");
    }

    @Nullable
    public String getDisplayName() {
        return this.zzf;
    }

    @Nullable
    public String getGivenName() {
        return this.zzl;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzm;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zzg;
    }

    @Hide
    public final GoogleSignInAccount zza(Scope ... scopeArray) {
        if (scopeArray != null) {
            Collections.addAll(this.zzn, scopeArray);
        }
        return this;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zzh;
    }

    @Hide
    public final boolean zzb() {
        return zza.zza() / 1000L >= this.zzi - 300L;
    }

    @Hide
    @NonNull
    public final String zzc() {
        return this.zzj;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zzk);
    }

    @Hide
    @NonNull
    public final Set<Scope> zzd() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzk);
        hashSet.addAll(this.zzn);
        return hashSet;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInAccount googleSignInAccount = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (int)googleSignInAccount.zzb);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)googleSignInAccount.getId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)googleSignInAccount.getIdToken(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)googleSignInAccount.getEmail(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)googleSignInAccount.getDisplayName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (Parcelable)googleSignInAccount.getPhotoUrl(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (String)googleSignInAccount.getServerAuthCode(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (long)googleSignInAccount.zzi);
        zzbgo.zza((Parcel)parcel2, (int)9, (String)googleSignInAccount.zzj, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)10, googleSignInAccount.zzk, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)11, (String)googleSignInAccount.getGivenName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)12, (String)googleSignInAccount.getFamilyName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return (527 + this.zzj.hashCode()) * 31 + this.zzd().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)((Object)object);
        return googleSignInAccount.zzj.equals(this.zzj) && googleSignInAccount.zzd().equals(this.zzd());
    }

    @Hide
    public final String zze() {
        JSONObject jSONObject = this.zzf();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private final JSONObject zzf() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getGivenName() != null) {
                jSONObject.put("givenName", (Object)this.getGivenName());
            }
            if (this.getFamilyName() != null) {
                jSONObject.put("familyName", (Object)this.getFamilyName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.zzi);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zzj);
            JSONArray jSONArray = new JSONArray();
            Scope[] scopeArray = this.zzk.toArray(new Scope[this.zzk.size()]);
            Arrays.sort(scopeArray, com.google.android.gms.auth.api.signin.zza.zza);
            Scope[] scopeArray2 = scopeArray;
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                Scope scope = scopeArray2[i];
                jSONArray.put((Object)scope.zza());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    static final /* synthetic */ int zza(Scope scope, Scope scope2) {
        return scope.zza().compareTo(scope2.zza());
    }
}

