/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzaa;
import com.google.android.gms.common.api.internal.zzab;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcx;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzz;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.internal.zzcwc;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzy
implements zzcf {
    private final Context mContext;
    private final zzbd zzfmo;
    private final Looper zzakm;
    private final zzbl zzfmp;
    private final zzbl zzfmq;
    private final Map<Api.zzc<?>, zzbl> zzfmr;
    private final Set<zzcx> zzfms = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzfmt;
    private Bundle zzfmu;
    private ConnectionResult zzfmv = null;
    private ConnectionResult zzfmw = null;
    private boolean zzfmx = false;
    private final Lock zzfmy;
    private int zzfmz = 0;

    public static zzy zza(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcwb, zzcwc> zza2, ArrayList<zzw> arrayList) {
        Object object;
        Api.zze zze3 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzaaw()) {
                zze3 = object;
            }
            if (object.zzaam()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzbq.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzaft();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzw>();
        ArrayList<zzw> arrayList2 = new ArrayList<zzw>();
        ArrayList<zzw> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList3.get(i);
            zzw zzw3 = zzw2;
            if (arrayMap5.containsKey(zzw3.zzffv)) {
                ((ArrayList)object).add(zzw3);
                continue;
            }
            if (arrayMap.containsKey(zzw3.zzffv)) {
                arrayList2.add(zzw3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzy(context, zzbd2, lock, looper, zze2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzr2, zza2, zze3, (ArrayList<zzw>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzy(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzr zzr2, Api.zza<? extends zzcwb, zzcwc> zza2, Api.zze zze3, ArrayList<zzw> arrayList, ArrayList<zzw> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzfmo = zzbd2;
        this.zzfmy = lock;
        this.zzakm = looper;
        this.zzfmt = zze3;
        this.zzfmp = new zzbl(context, this.zzfmo, lock, looper, zze2, map2, null, map4, null, arrayList2, new zzaa(this, null));
        this.zzfmq = new zzbl(context, this.zzfmo, lock, looper, zze2, map, zzr2, map3, zza2, arrayList, new zzab(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfmp);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfmq);
        }
        this.zzfmr = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzahb()) {
                t.zzu(new Status(4, null, this.zzahc()));
                return t;
            }
            return this.zzfmq.zzd(t);
        }
        return this.zzfmp.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzahb()) {
                t.zzu(new Status(4, null, this.zzahc()));
                return t;
            }
            return this.zzfmq.zze(t);
        }
        return this.zzfmp.zze(t);
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzfmr.get(api.zzaft()).equals(this.zzfmq)) {
            if (this.zzahb()) {
                return new ConnectionResult(4, this.zzahc());
            }
            return this.zzfmq.getConnectionResult(api);
        }
        return this.zzfmp.getConnectionResult(api);
    }

    @Override
    public final void connect() {
        this.zzfmz = 2;
        this.zzfmx = false;
        zzy zzy2 = this;
        this.zzfmw = null;
        zzy2.zzfmv = null;
        zzy2.zzfmp.connect();
        zzy2.zzfmq.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void disconnect() {
        this.zzfmw = null;
        this.zzfmv = null;
        this.zzfmz = 0;
        this.zzfmp.disconnect();
        this.zzfmq.disconnect();
        this.zzaha();
    }

    @Override
    public final boolean isConnected() {
        this.zzfmy.lock();
        try {
            boolean bl = this.zzfmp.isConnected() && (this.zzfmq.isConnected() || this.zzahb() || this.zzfmz == 1);
            return bl;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfmy.lock();
        try {
            boolean bl = this.zzfmz == 2;
            return bl;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    @Override
    public final boolean zza(zzcx zzcx2) {
        this.zzfmy.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzfmq.isConnected()) {
                this.zzfms.add(zzcx2);
                if (this.zzfmz == 0) {
                    this.zzfmz = 1;
                }
                this.zzfmw = null;
                this.zzfmq.connect();
                return true;
            }
        }
        finally {
            this.zzfmy.unlock();
        }
        return false;
    }

    @Override
    public final void zzagy() {
        this.zzfmp.zzagy();
        this.zzfmq.zzagy();
    }

    @Override
    public final void zzagf() {
        this.zzfmy.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzfmq.disconnect();
            this.zzfmw = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzakm).post((Runnable)new zzz(this));
            } else {
                this.zzaha();
            }
            return;
        }
        finally {
            this.zzfmy.unlock();
        }
    }

    private final void zzagz() {
        if (zzy.zzb(this.zzfmv)) {
            if (zzy.zzb(this.zzfmw) || this.zzahb()) {
                zzy zzy2 = this;
                switch (zzy2.zzfmz) {
                    case 2: {
                        zzy2.zzfmo.zzj(zzy2.zzfmu);
                    }
                    case 1: {
                        zzy2.zzaha();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzy2.zzfmz = 0;
                return;
            }
            if (this.zzfmw != null) {
                if (this.zzfmz == 1) {
                    this.zzaha();
                    return;
                }
                this.zza(this.zzfmw);
                this.zzfmp.disconnect();
                return;
            }
        } else {
            if (this.zzfmv != null && zzy.zzb(this.zzfmw)) {
                this.zzfmq.disconnect();
                this.zza(this.zzfmv);
                return;
            }
            if (this.zzfmv != null && this.zzfmw != null) {
                ConnectionResult connectionResult = this.zzfmv;
                if (this.zzfmq.zzfpz < this.zzfmp.zzfpz) {
                    connectionResult = this.zzfmw;
                }
                this.zza(connectionResult);
            }
        }
    }

    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzfmz) {
            case 2: {
                this.zzfmo.zzc(connectionResult);
            }
            case 1: {
                this.zzaha();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzfmz = 0;
    }

    private final void zzaha() {
        Iterator<zzcx> iterator = this.zzfms.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzaav();
        }
        this.zzfms.clear();
    }

    private final void zze(int n, boolean bl) {
        this.zzfmo.zzf(n, bl);
        this.zzfmw = null;
        this.zzfmv = null;
    }

    private final boolean zzahb() {
        return this.zzfmw != null && this.zzfmw.getErrorCode() == 4;
    }

    private final boolean zzf(zzm<? extends Result, ? extends Api.zzb> zzm2) {
        Api.zzc<? extends Api.zzb> zzc2 = zzm2.zzaft();
        zzbq.checkArgument((boolean)this.zzfmr.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzfmr.get(zzc2).equals(this.zzfmq);
    }

    @Nullable
    private final PendingIntent zzahc() {
        if (this.zzfmt == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzfmo), (Intent)this.zzfmt.getSignInIntent(), (int)0x8000000);
    }

    private final void zzi(Bundle bundle) {
        if (this.zzfmu == null) {
            this.zzfmu = bundle;
            return;
        }
        if (bundle != null) {
            this.zzfmu.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzfmq.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzfmp.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzy zzy2) {
        return zzy2.zzfmy;
    }

    static /* synthetic */ void zzb(zzy zzy2) {
        zzy2.zzagz();
    }

    static /* synthetic */ void zza(zzy zzy2, Bundle bundle) {
        zzy2.zzi(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzy zzy2, ConnectionResult connectionResult) {
        zzy2.zzfmv = connectionResult;
        return zzy2.zzfmv;
    }

    static /* synthetic */ boolean zzc(zzy zzy2) {
        return zzy2.zzfmx;
    }

    static /* synthetic */ ConnectionResult zzd(zzy zzy2) {
        return zzy2.zzfmw;
    }

    static /* synthetic */ boolean zza(zzy zzy2, boolean bl) {
        zzy2.zzfmx = bl;
        return zzy2.zzfmx;
    }

    static /* synthetic */ void zza(zzy zzy2, int n, boolean bl) {
        zzy2.zze(n, bl);
    }

    static /* synthetic */ zzbl zze(zzy zzy2) {
        return zzy2.zzfmq;
    }

    static /* synthetic */ ConnectionResult zzb(zzy zzy2, ConnectionResult connectionResult) {
        zzy2.zzfmw = connectionResult;
        return zzy2.zzfmw;
    }

    static /* synthetic */ zzbl zzf(zzy zzy2) {
        return zzy2.zzfmp;
    }
}

