/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzah;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbs;
import com.google.android.gms.common.api.internal.zzbt;
import com.google.android.gms.common.api.internal.zzbu;
import com.google.android.gms.common.api.internal.zzbv;
import com.google.android.gms.common.api.internal.zzbx;
import com.google.android.gms.common.api.internal.zzcn;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzcy;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzbz;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbr<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzx {
    private final Queue<zza> zzfqp = new LinkedList<zza>();
    private final Api.zze zzfnb;
    private final Api.zzb zzfqq;
    private final zzh<O> zzfjl;
    private final zzah zzfqr;
    private final Set<zzj> zzfqs = new HashSet<zzj>();
    private final Map<zzcn<?>, zzcu> zzfqt = new HashMap();
    private final int zzfqu;
    private final zzcy zzfqv;
    private boolean zzfpc;
    private ConnectionResult zzfqw = null;
    final /* synthetic */ zzbp zzfqo;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbr(zzbp zzbp2, GoogleApi googleApi) {
        this.zzfqo = zzbp2;
        this.zzfnb = googleApi.zza(zzbp.zza(zzbp2).getLooper(), this);
        this.zzfqq = this.zzfnb instanceof zzbz ? zzbz.zzalg() : this.zzfnb;
        this.zzfjl = googleApi.zzaga();
        this.zzfqr = new zzah();
        this.zzfqu = googleApi.getInstanceId();
        if (this.zzfnb.zzaam()) {
            this.zzfqv = googleApi.zza(zzbp.zzb(zzbp2), zzbp.zza(zzbp2));
            return;
        }
        this.zzfqv = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzbp.zza(this.zzfqo).getLooper()) {
            this.zzaik();
            return;
        }
        zzbp.zza(this.zzfqo).post((Runnable)new zzbs(this));
    }

    @WorkerThread
    private final void zzaik() {
        this.zzain();
        this.zzi(ConnectionResult.zzfhy);
        this.zzaip();
        for (zzcu zzcu2 : this.zzfqt.values()) {
            try {
                zzcu2.zzfkw.zzb(this.zzfqq, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzfnb.disconnect();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbr zzbr2 = this;
        while (zzbr2.zzfnb.isConnected() && !zzbr2.zzfqp.isEmpty()) {
            zza zza2 = zzbr2.zzfqp.remove();
            zzbr2.zzb(zza2);
        }
        this.zzaiq();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzbp.zza(this.zzfqo).getLooper()) {
            this.zzail();
            return;
        }
        zzbp.zza(this.zzfqo).post((Runnable)new zzbt(this));
    }

    @WorkerThread
    private final void zzail() {
        this.zzain();
        this.zzfpc = true;
        this.zzfqr.zzahk();
        zzbp.zza(this.zzfqo).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfqo), (int)9, this.zzfjl), zzbp.zzc(this.zzfqo));
        zzbp.zza(this.zzfqo).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfqo), (int)11, this.zzfjl), zzbp.zzd(this.zzfqo));
        zzbp.zza(this.zzfqo, -1);
    }

    @WorkerThread
    public final void zzh(@NonNull ConnectionResult connectionResult) {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        this.zzfnb.disconnect();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzbp.zza(this.zzfqo).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzbp.zza(this.zzfqo).post((Runnable)new zzbu(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        if (this.zzfqv != null) {
            this.zzfqv.zzaje();
        }
        this.zzain();
        zzbp.zza(this.zzfqo, -1);
        this.zzi(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zzw(zzbp.zzaii());
            return;
        }
        if (this.zzfqp.isEmpty()) {
            this.zzfqw = connectionResult;
            return;
        }
        Object object = zzbp.zzaij();
        synchronized (object) {
            if (zzbp.zze(this.zzfqo) != null && zzbp.zzf(this.zzfqo).contains(this.zzfjl)) {
                zzbp.zze(this.zzfqo).zzb(connectionResult, this.zzfqu);
                return;
            }
        }
        if (!this.zzfqo.zzc(connectionResult, this.zzfqu)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzfpc = true;
            }
            if (this.zzfpc) {
                zzbp.zza(this.zzfqo).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfqo), (int)9, this.zzfjl), zzbp.zzc(this.zzfqo));
                return;
            }
            object = this.zzfjl.zzagl();
            this.zzw(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zza zza2) {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        if (this.zzfnb.isConnected()) {
            this.zzb(zza2);
            this.zzaiq();
            return;
        }
        this.zzfqp.add(zza2);
        if (this.zzfqw != null && this.zzfqw.hasResolution()) {
            this.onConnectionFailed(this.zzfqw);
            return;
        }
        this.connect();
    }

    @WorkerThread
    public final void signOut() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        this.zzw(zzbp.zzfqe);
        this.zzfqr.zzahj();
        for (zzcn zzcn2 : this.zzfqt.keySet().toArray(new zzcn[this.zzfqt.size()])) {
            this.zza(new zzf(zzcn2, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
        }
        this.zzi(new ConnectionResult(4));
        this.zzfnb.zza(new zzbv(this));
    }

    public final Api.zze zzahd() {
        return this.zzfnb;
    }

    public final Map<zzcn<?>, zzcu> zzaim() {
        return this.zzfqt;
    }

    @WorkerThread
    public final void zzain() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        this.zzfqw = null;
    }

    @WorkerThread
    public final ConnectionResult zzaio() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        return this.zzfqw;
    }

    @WorkerThread
    private final void zzb(zza zza2) {
        zza2.zza(this.zzfqr, this.zzaam());
        try {
            zza2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzfnb.disconnect();
            return;
        }
    }

    @WorkerThread
    public final void zzw(Status status) {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        Iterator iterator = this.zzfqp.iterator();
        while (iterator.hasNext()) {
            ((zza)iterator.next()).zzs(status);
        }
        this.zzfqp.clear();
    }

    @WorkerThread
    public final void resume() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        if (this.zzfpc) {
            this.connect();
        }
    }

    @WorkerThread
    private final void zzaip() {
        if (this.zzfpc) {
            zzbp.zza(this.zzfqo).removeMessages(11, this.zzfjl);
            zzbp.zza(this.zzfqo).removeMessages(9, this.zzfjl);
            this.zzfpc = false;
        }
    }

    @WorkerThread
    public final void zzahx() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        if (this.zzfpc) {
            this.zzaip();
            Status status = zzbp.zzg(this.zzfqo).isGooglePlayServicesAvailable(zzbp.zzb(this.zzfqo)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zzw(status);
            this.zzfnb.disconnect();
        }
    }

    private final void zzaiq() {
        zzbp.zza(this.zzfqo).removeMessages(12, this.zzfjl);
        zzbp.zza(this.zzfqo).sendMessageDelayed(zzbp.zza(this.zzfqo).obtainMessage(12, this.zzfjl), zzbp.zzh(this.zzfqo));
    }

    @WorkerThread
    public final void zzair() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        if (this.zzfnb.isConnected() && this.zzfqt.size() == 0) {
            if (this.zzfqr.zzahi()) {
                this.zzaiq();
                return;
            }
            this.zzfnb.disconnect();
        }
    }

    @WorkerThread
    public final void connect() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        if (this.zzfnb.isConnected() || this.zzfnb.isConnecting()) {
            return;
        }
        if (this.zzfnb.zzafu() && zzbp.zzi(this.zzfqo) != 0) {
            zzbp.zza(this.zzfqo, zzbp.zzg(this.zzfqo).isGooglePlayServicesAvailable(zzbp.zzb(this.zzfqo)));
            if (zzbp.zzi(this.zzfqo) != 0) {
                ConnectionResult connectionResult = new ConnectionResult(zzbp.zzi(this.zzfqo), null);
                this.onConnectionFailed(connectionResult);
                return;
            }
        }
        zzbx zzbx2 = new zzbx(this.zzfqo, this.zzfnb, this.zzfjl);
        if (this.zzfnb.zzaam()) {
            this.zzfqv.zza(zzbx2);
        }
        this.zzfnb.zza(zzbx2);
    }

    @WorkerThread
    public final void zza(zzj zzj2) {
        zzbq.zza((Handler)zzbp.zza(this.zzfqo));
        this.zzfqs.add(zzj2);
    }

    @WorkerThread
    private final void zzi(ConnectionResult connectionResult) {
        Iterator<zzj> iterator = this.zzfqs.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(this.zzfjl, connectionResult);
        }
        this.zzfqs.clear();
    }

    final boolean isConnected() {
        return this.zzfnb.isConnected();
    }

    public final boolean zzaam() {
        return this.zzfnb.zzaam();
    }

    public final int getInstanceId() {
        return this.zzfqu;
    }

    final zzcwb zzais() {
        if (this.zzfqv == null) {
            return null;
        }
        return this.zzfqv.zzais();
    }

    static /* synthetic */ void zzc(zzbr zzbr2) {
        zzbr2.zzaik();
    }

    static /* synthetic */ void zzd(zzbr zzbr2) {
        zzbr2.zzail();
    }

    static /* synthetic */ Api.zze zze(zzbr zzbr2) {
        return zzbr2.zzfnb;
    }
}

