/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzak;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbr;
import com.google.android.gms.common.api.internal.zzbz;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcn;
import com.google.android.gms.common.api.internal.zzcp;
import com.google.android.gms.common.api.internal.zzct;
import com.google.android.gms.common.api.internal.zzcy;
import com.google.android.gms.common.api.internal.zzdb;
import com.google.android.gms.common.api.internal.zzdf;
import com.google.android.gms.common.api.internal.zzdp;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.Collections;

public class GoogleApi<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> zzfgf;
    private final O zzfju;
    private final zzh<O> zzfjv;
    private final Looper zzakm;
    private final int mId;
    private final GoogleApiClient zzfjw;
    private final zzdb zzfjx;
    protected final zzbp zzfjy;

    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        zzbq.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzfgf = api;
        this.zzfju = null;
        this.zzakm = looper;
        this.zzfjv = zzh.zzb(api);
        this.zzfjw = new zzbz(this);
        this.zzfjy = zzbp.zzch(this.mContext);
        this.mId = this.zzfjy.zzaih();
        this.zzfjx = new zzg();
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, Looper looper, zzdb zzdb2) {
        this(context, api, null, new zzd().zza(looper).zza(zzdb2).zzage());
    }

    @MainThread
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        zzbq.checkNotNull((Object)activity, (Object)"Null activity is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.zzfgf = api;
        this.zzfju = o;
        this.zzakm = zza2.zzfkb;
        this.zzfjv = zzh.zza(this.zzfgf, this.zzfju);
        this.zzfjw = new zzbz(this);
        this.zzfjy = zzbp.zzch(this.mContext);
        this.mId = this.zzfjy.zzaih();
        this.zzfjx = zza2.zzfka;
        zzak.zza(activity, this.zzfjy, this.zzfjv);
        this.zzfjy.zza(this);
    }

    public GoogleApi(@NonNull Context context, Api<O> api, O o, zza zza2) {
        zzbq.checkNotNull((Object)context, (Object)"Null context is not permitted.");
        zzbq.checkNotNull(api, (Object)"Api must not be null.");
        zzbq.checkNotNull((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.zzfgf = api;
        this.zzfju = o;
        this.zzakm = zza2.zzfkb;
        this.zzfjv = zzh.zza(this.zzfgf, this.zzfju);
        this.zzfjw = new zzbz(this);
        this.zzfjy = zzbp.zzch(this.mContext);
        this.mId = this.zzfjy.zzaih();
        this.zzfjx = zza2.zzfka;
        this.zzfjy.zza(this);
    }

    @Deprecated
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zzdb zzdb2) {
        this(activity, api, o, new zzd().zza(zzdb2).zza(activity.getMainLooper()).zzage());
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zzdb zzdb2) {
        this(context, api, o, new zzd().zza(zzdb2).zzage());
    }

    private final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzagx();
        this.zzfjy.zza(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzdf<A, TResult> zzdf2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzfjy.zza(this, n, zzdf2, taskCompletionSource, this.zzfjx);
        return taskCompletionSource.getTask();
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zza(zzdf<A, TResult> zzdf2) {
        return this.zza(false, (zzdp)((Object)zzdf2));
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zzb(zzdf<A, TResult> zzdf2) {
        return this.zza(true, (zzdp)((Object)zzdf2));
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzc(@NonNull T t) {
        return this.zza(2, t);
    }

    public final <A extends Api.zzb, T extends zzct<A, ?>, U extends zzdp<A, ?>> Task<Void> zza(@NonNull T t, U u) {
        zzbq.checkNotNull(t);
        zzbq.checkNotNull(u);
        zzbq.checkNotNull(t.zzajd(), (Object)"Listener has already been released.");
        zzbq.checkNotNull(u.zzajd(), (Object)"Listener has already been released.");
        zzbq.checkArgument((boolean)t.zzajd().equals(u.zzajd()), (Object)"Listener registration and unregistration methods must be constructed with the same ListenerHolder.");
        return this.zzfjy.zza(this, t, u);
    }

    public final Task<Boolean> zza(@NonNull zzcn<?> zzcn2) {
        zzbq.checkNotNull(zzcn2, (Object)"Listener key cannot be null.");
        return this.zzfjy.zza(this, zzcn2);
    }

    public final <L> zzcl<L> zza(@NonNull L l, String string2) {
        return zzcp.zzb(l, this.zzakm, string2);
    }

    @WorkerThread
    public Api.zze zza(Looper looper, zzbr<O> zzbr2) {
        zzr zzr2 = this.zzagd().zzgb(this.mContext.getPackageName()).zzgc(this.mContext.getClass().getName()).zzaks();
        return this.zzfgf.zzaft().zza(this.mContext, looper, zzr2, this.zzfju, zzbr2, zzbr2);
    }

    public final Api<O> zzafz() {
        return this.zzfgf;
    }

    public final O zzaga() {
        return this.zzfju;
    }

    public final zzh<O> zzagb() {
        return this.zzfjv;
    }

    public final int getInstanceId() {
        return this.mId;
    }

    public final GoogleApiClient zzagc() {
        return this.zzfjw;
    }

    public final Looper getLooper() {
        return this.zzakm;
    }

    public final Context getApplicationContext() {
        return this.mContext;
    }

    private final zzs zzagd() {
        GoogleSignInAccount googleSignInAccount;
        GoogleApi googleApi = this;
        googleApi = this;
        return new zzs().zze((Account)(googleApi.zzfju instanceof Api.ApiOptions.HasGoogleSignInAccountOptions ? ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzfju).getGoogleSignInAccount().getAccount() : (googleApi.zzfju instanceof Api.ApiOptions.HasAccountOptions ? ((Api.ApiOptions.HasAccountOptions)googleApi.zzfju).getAccount() : null))).zze(googleApi.zzfju instanceof Api.ApiOptions.HasGoogleSignInAccountOptions && (googleSignInAccount = ((Api.ApiOptions.HasGoogleSignInAccountOptions)googleApi.zzfju).getGoogleSignInAccount()) != null ? googleSignInAccount.getGrantedScopes() : Collections.emptySet());
    }

    public zzcy zza(Context context, Handler handler) {
        return new zzcy(context, handler, this.zzagd().zzaks());
    }

    public static final class zza {
        public static final zza zzfjz = new zzd().zzage();
        public final zzdb zzfka;
        public final Looper zzfkb;

        private zza(zzdb zzdb2, Account account, Looper looper) {
            this.zzfka = zzdb2;
            this.zzfkb = looper;
        }

        /* synthetic */ zza(zzdb zzdb2, Account account, Looper looper, zzc zzc2) {
            this(zzdb2, null, looper);
        }
    }
}

