/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.api.internal.zzdo;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.internal.zzaq;
import com.google.android.gms.common.internal.zzbq;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzs<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzfmi = new zzt();
    private final Object zzfmj = new Object();
    private zzu<R> zzfmk;
    private WeakReference<GoogleApiClient> zzfml;
    private final CountDownLatch zzaoi = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzfmm = new ArrayList();
    private ResultCallback<? super R> zzfmn;
    private final AtomicReference<zzdo> zzfmo = new AtomicReference();
    private R zzfku;
    private Status mStatus;
    private zzv zzfmp;
    private volatile boolean zzfmq;
    private boolean zzaj;
    private boolean zzfmr;
    private zzaq zzfms;
    private volatile zzdi<R> zzfmt;
    private boolean zzfmu = false;

    @Deprecated
    zzs() {
        this.zzfmk = new zzu(Looper.getMainLooper());
        this.zzfml = new WeakReference<Object>(null);
    }

    protected zzs(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzfmk = new zzu(looper);
        this.zzfml = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzs(Looper looper) {
        this.zzfmk = new zzu(looper);
        this.zzfml = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzaoi.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzbq.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzbq.zza((!this.zzfmq ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzbq.zza((this.zzfmt == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzaoi.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzw(Status.zzfkz);
        }
        zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzbq.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzbq.zza((!this.zzfmq ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzbq.zza((this.zzfmt == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zzaoi.await(l, timeUnit)) {
                this.zzw(Status.zzflb);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzw(Status.zzfkz);
        }
        zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzfmj;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfmn = null;
                return;
            }
            zzbq.zza((!this.zzfmq ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((this.zzfmt == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfmk.zza(resultCallback, (R)this.get());
            } else {
                this.zzfmn = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzfmj;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfmn = null;
                return;
            }
            zzbq.zza((!this.zzfmq ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((this.zzfmt == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfmk.zza(resultCallback, (R)this.get());
            } else {
                this.zzfmn = resultCallback;
                long l2 = timeUnit.toMillis(l);
                zzs zzs2 = this;
                zzu<R> zzu2 = this.zzfmk;
                zzu2.sendMessageDelayed(zzu2.obtainMessage(2, zzs2), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzbq.checkArgument((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzfmj;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzs(this.mStatus);
            } else {
                this.zzfmm.add(zza2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzfmj;
        synchronized (object) {
            if (this.zzaj || this.zzfmq) {
                return;
            }
            if (this.zzfms != null) {
                try {
                    this.zzfms.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            zzs.zzd(this.zzfku);
            this.zzaj = true;
            this.zzc(this.zzb(Status.zzflc));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzagw() {
        Object object = this.zzfmj;
        synchronized (object) {
            if ((GoogleApiClient)this.zzfml.get() == null || !this.zzfmu) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzfmj;
        synchronized (object) {
            return this.zzaj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzbq.zza((!this.zzfmq ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzfmj;
        synchronized (object) {
            zzbq.zza((this.zzfmt == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbq.zza((this.zzfmn == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzbq.zza((!this.zzaj ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzfmu = true;
            this.zzfmt = new zzdi(this.zzfml);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zzfmt).then(resultTransform);
            if (this.isReady()) {
                this.zzfmk.zza(this.zzfmt, this.get());
            } else {
                this.zzfmn = this.zzfmt;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R r) {
        Object object = this.zzfmj;
        synchronized (object) {
            if (!this.zzfmr && !this.zzaj) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                zzs.zzd(r);
                return;
            }
            zzbq.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzbq.zza((!this.zzfmq ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzw(Status status) {
        Object object = this.zzfmj;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.zzb(status));
                this.zzfmr = true;
            }
            return;
        }
    }

    @NonNull
    protected abstract R zzb(Status var1);

    public final void zza(zzdo zzdo2) {
        this.zzfmo.set(zzdo2);
    }

    @Override
    public final Integer zzagj() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzaq zzaq2) {
        Object object = this.zzfmj;
        synchronized (object) {
            this.zzfms = zzaq2;
            return;
        }
    }

    public final void zzagx() {
        this.zzfmu = this.zzfmu || zzfmi.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zzfmj;
        synchronized (object) {
            zzbq.zza((!this.zzfmq ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbq.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzfku;
            this.zzfku = null;
            this.zzfmn = null;
            this.zzfmq = true;
        }
        zzs zzs2 = this;
        zzdo zzdo2 = zzs2.zzfmo.getAndSet(null);
        if (zzdo2 != null) {
            zzdo2.zzc(zzs2);
        }
        return r;
    }

    private final void zzc(R r) {
        this.zzfku = r;
        this.zzfms = null;
        this.zzaoi.countDown();
        this.mStatus = this.zzfku.getStatus();
        if (this.zzaj) {
            this.zzfmn = null;
        } else if (this.zzfmn == null) {
            if (this.zzfku instanceof Releasable) {
                this.zzfmp = new zzv(this, null);
            }
        } else {
            this.zzfmk.removeMessages(2);
            this.zzfmk.zza(this.zzfmn, (R)this.get());
        }
        ArrayList<PendingResult.zza> arrayList = this.zzfmm;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.zza zza2 = arrayList.get(i);
            zza2.zzs(this.mStatus);
        }
        this.zzfmm.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ Result zza(zzs zzs2) {
        return zzs2.zzfku;
    }
}

