/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.auth.api.signin.internal.zzp;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.auth.api.signin.zze;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zzbej
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope zzeeu = new Scope("profile");
    public static final Scope zzeev = new Scope("email");
    public static final Scope zzeew = new Scope("openid");
    private static Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zze();
    private int versionCode;
    private final ArrayList<Scope> zzeex;
    private Account zzdzb;
    private boolean zzecm;
    private final boolean zzeey;
    private final boolean zzeez;
    private String zzecn;
    private String zzefa;
    private ArrayList<zzn> zzefb;
    private Map<Integer, zzn> zzefc;
    private static Comparator<Scope> zzefd = new zzd();

    @Nullable
    public static GoogleSignInOptions zzep(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzn>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzn> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzw(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzn> map) {
        this.versionCode = n;
        this.zzeex = arrayList;
        this.zzdzb = account;
        this.zzecm = bl;
        this.zzeey = bl2;
        this.zzeez = bl3;
        this.zzecn = string2;
        this.zzefa = string3;
        this.zzefb = new ArrayList<zzn>(map.values());
        this.zzefc = map;
    }

    public final ArrayList<Scope> zzaas() {
        return new ArrayList<Scope>(this.zzeex);
    }

    public Scope[] getScopeArray() {
        return this.zzeex.toArray(new Scope[this.zzeex.size()]);
    }

    public final Account getAccount() {
        return this.zzdzb;
    }

    public final boolean isIdTokenRequested() {
        return this.zzecm;
    }

    public final boolean zzaat() {
        return this.zzeey;
    }

    public final String getServerClientId() {
        return this.zzecn;
    }

    public final zzn zzba(int n) {
        return this.zzefc.get(2);
    }

    private static Map<Integer, zzn> zzw(@Nullable List<zzn> list) {
        HashMap<Integer, zzn> hashMap = new HashMap<Integer, zzn>();
        if (list == null) {
            return hashMap;
        }
        for (zzn zzn2 : list) {
            hashMap.put(zzn2.getType(), zzn2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        zzbem.zzc((Parcel)parcel2, (int)2, googleSignInOptions.zzaas(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.zzdzb, (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.zzecm);
        zzbem.zza((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.zzeey);
        zzbem.zza((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.zzeez);
        zzbem.zza((Parcel)parcel2, (int)7, (String)googleSignInOptions.zzecn, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (String)googleSignInOptions.zzefa, (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)9, googleSignInOptions.zzefb, (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzefb.size() > 0 || googleSignInOptions.zzefb.size() > 0) {
                return false;
            }
            if (this.zzeex.size() != googleSignInOptions.zzaas().size() || !this.zzeex.containsAll(googleSignInOptions.zzaas())) {
                return false;
            }
            return (this.zzdzb == null ? googleSignInOptions.zzdzb == null : this.zzdzb.equals((Object)googleSignInOptions.zzdzb)) && (TextUtils.isEmpty((CharSequence)this.zzecn) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzecn) : this.zzecn.equals(googleSignInOptions.zzecn)) && this.zzeez == googleSignInOptions.zzeez && this.zzecm == googleSignInOptions.zzecm && this.zzeey == googleSignInOptions.zzeey;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzeex;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.zzagk());
        }
        Collections.sort(arrayList);
        return new zzp().zzr(arrayList).zzr(this.zzdzb).zzr(this.zzecn).zzaq(this.zzeez).zzaq(this.zzecm).zzaq(this.zzeey).zzabb();
    }

    public final String zzaau() {
        return this.toJsonObject().toString();
    }

    private final JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzeex, zzefd);
            ArrayList<Scope> arrayList = this.zzeex;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.zzagk());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzdzb != null) {
                jSONObject.put("accountName", (Object)this.zzdzb.name);
            }
            jSONObject.put("idTokenRequested", this.zzecm);
            jSONObject.put("forceCodeForRefreshToken", this.zzeez);
            jSONObject.put("serverAuthRequested", this.zzeey);
            if (!TextUtils.isEmpty((CharSequence)this.zzecn)) {
                jSONObject.put("serverClientId", (Object)this.zzecn);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzefa)) {
                jSONObject.put("hostedDomain", (Object)this.zzefa);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map, zzd zzd2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string2, string3, map);
    }

    public static final class Builder {
        private Set<Scope> zzefe = new HashSet<Scope>();
        private boolean zzeey;
        private boolean zzeez;
        private boolean zzecm;
        private String zzecn;
        private Account zzdzb;
        private String zzefa;
        private Map<Integer, zzn> zzeff = new HashMap<Integer, zzn>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzbq.checkNotNull((Object)googleSignInOptions);
            this.zzefe = new HashSet<Scope>(googleSignInOptions.zzeex);
            this.zzeey = googleSignInOptions.zzeey;
            this.zzeez = googleSignInOptions.zzeez;
            this.zzecm = googleSignInOptions.zzecm;
            this.zzecn = googleSignInOptions.zzecn;
            this.zzdzb = googleSignInOptions.zzdzb;
            this.zzefa = googleSignInOptions.zzefa;
            this.zzeff = GoogleSignInOptions.zzw(googleSignInOptions.zzefb);
        }

        public final Builder requestId() {
            this.zzefe.add(zzeew);
            return this;
        }

        public final Builder requestEmail() {
            this.zzefe.add(zzeev);
            return this;
        }

        public final Builder requestProfile() {
            this.zzefe.add(zzeeu);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzefe.add(scope);
            this.zzefe.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string2) {
            this.zzecm = true;
            this.zzecn = this.zzeq(string2);
            return this;
        }

        public final Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public final Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzeey = true;
            this.zzecn = this.zzeq(string2);
            this.zzeez = bl;
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzdzb = new Account(zzbq.zzgi((String)string2), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string2) {
            this.zzefa = zzbq.zzgi((String)string2);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzeff.containsKey(googleSignInOptionsExtension.getExtensionType())) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            if (googleSignInOptionsExtension.getImpliedScopes() != null) {
                this.zzefe.addAll(googleSignInOptionsExtension.getImpliedScopes());
            }
            this.zzeff.put(googleSignInOptionsExtension.getExtensionType(), new zzn(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.zzecm && (this.zzdzb == null || !this.zzefe.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zzefe), this.zzdzb, this.zzecm, this.zzeey, this.zzeez, this.zzecn, this.zzefa, this.zzeff, null);
        }

        private final String zzeq(String string2) {
            zzbq.zzgi((String)string2);
            zzbq.checkArgument((this.zzecn == null || this.zzecn.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

