/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzad;
import com.google.android.gms.common.api.internal.zzbe;
import com.google.android.gms.common.api.internal.zzbf;
import com.google.android.gms.common.api.internal.zzbg;
import com.google.android.gms.common.api.internal.zzbh;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzbj;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzby;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzce;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcj;
import com.google.android.gms.common.api.internal.zzcn;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzda;
import com.google.android.gms.common.api.internal.zzdg;
import com.google.android.gms.common.api.internal.zzdj;
import com.google.android.gms.common.api.internal.zzdm;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzy;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbcr;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzbd
extends GoogleApiClient
implements zzce {
    private final Lock zzfke;
    private boolean zzfhp;
    private final com.google.android.gms.common.internal.zzad zzfmg;
    private zzcd zzfmh = null;
    private final int zzfhj;
    private final Context mContext;
    private final Looper zzakg;
    final Queue<zzm<?, ?>> zzfks = new LinkedList();
    private volatile boolean zzfmi;
    private long zzfmj = 120000L;
    private long zzfmk = 5000L;
    private final zzbi zzfml;
    private final GoogleApiAvailability zzfhl;
    private zzby zzfmm;
    final Map<Api.zzc<?>, Api.zze> zzfmn;
    Set<Scope> zzfmo = new HashSet<Scope>();
    private zzq zzfkj;
    private Map<Api<?>, Boolean> zzfkm;
    private Api.zza<? extends zzcps, zzcpt> zzfhm;
    private final zzcn zzfmp = new zzcn();
    private final ArrayList<zzw> zzfmq;
    private Integer zzfmr = null;
    Set<zzdg> zzfms = null;
    final zzdj zzfmt;
    private final zzae zzfmu = new zzbe(this);

    public zzbd(Context context, Lock lock, Looper looper, zzq zzq2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzcps, zzcpt> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzw> arrayList, boolean bl) {
        this.mContext = context;
        this.zzfke = lock;
        this.zzfhp = false;
        this.zzfmg = new com.google.android.gms.common.internal.zzad(looper, this.zzfmu);
        this.zzakg = looper;
        this.zzfml = new zzbi(this, looper);
        this.zzfhl = googleApiAvailability;
        this.zzfhj = n;
        if (this.zzfhj >= 0) {
            this.zzfmr = n2;
        }
        this.zzfkm = map;
        this.zzfmn = map2;
        this.zzfmq = arrayList;
        this.zzfmt = new zzdj(this.zzfmn);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzfmg.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzfmg.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzfkj = zzq2;
        this.zzfhm = zza2;
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        zzbp.zzb((t.zzafe() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzafj() != null ? t.zzafj().getName() : "the API";
        zzbp.zzb((boolean)this.zzfmn.containsKey(t.zzafe()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzfke.lock();
        try {
            if (this.zzfmh == null) {
                this.zzfks.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzfmh.zzd(t);
            return (T)string2;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        zzbp.zzb((t.zzafe() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzafj() != null ? t.zzafj().getName() : "the API";
        zzbp.zzb((boolean)this.zzfmn.containsKey(t.zzafe()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzfke.lock();
        try {
            if (this.zzfmh == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzfmi) {
                this.zzfks.add(t);
                while (!this.zzfks.isEmpty()) {
                    object = this.zzfks.remove();
                    this.zzfmt.zzb((zzs<? extends Result>)object);
                    ((zzm)object).zzt(Status.zzfhx);
                }
                object = t;
                return (T)object;
            }
            object = this.zzfmh.zze(t);
            return (T)object;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final <L> zzcj<L> zzp(@NonNull L l) {
        this.zzfke.lock();
        try {
            Looper looper = this.zzakg;
            L l2 = l;
            zzcj<L> zzcj2 = this.zzfmp.zza(l2, looper, "NO_TYPE");
            return zzcj2;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzfmn.get(zzc2);
        zzbp.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public final boolean zza(@NonNull Api<?> api) {
        return this.zzfmn.containsKey(api.zzafe());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzfmn.get(api.zzafe());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzfke.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zzfmi) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzfmn.containsKey(api.zzafe())) break block6;
                    connectionResult = this.zzfmh.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzfmi) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.zzfff;
                    this.zzfke.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzahk());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzfke.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzfke.lock();
        try {
            if (this.zzfhj >= 0) {
                zzbp.zza((this.zzfmr != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfmr == null) {
                this.zzfmr = zzbd.zza(this.zzfmn.values(), false);
            } else if (this.zzfmr == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zzfmr);
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzfke.lock();
        try {
            zzbp.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzbt(n);
            this.zzahg();
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        zzbp.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzfke.lock();
        try {
            if (this.zzfhj >= 0) {
                zzbp.zza((this.zzfmr != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfmr == null) {
                this.zzfmr = zzbd.zza(this.zzfmn.values(), false);
            } else if (this.zzfmr == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbt(this.zzfmr);
            this.zzfmg.zzakf();
            ConnectionResult connectionResult = this.zzfmh.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzbp.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzbp.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzfke.lock();
        try {
            if (this.zzfmr == null) {
                this.zzfmr = zzbd.zza(this.zzfmn.values(), false);
            } else if (this.zzfmr == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbt(this.zzfmr);
            this.zzfmg.zzakf();
            ConnectionResult connectionResult = this.zzfmh.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzfke.lock();
        try {
            this.zzfmt.release();
            if (this.zzfmh != null) {
                this.zzfmh.disconnect();
            }
            this.zzfmp.release();
            for (zzm zzm2 : this.zzfks) {
                ((zzs)zzm2).zza((zzdm)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfks.clear();
            if (this.zzfmh == null) {
                return;
            }
            this.zzahi();
            this.zzfmg.zzake();
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzbp.zza((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzbp.zza((this.zzfmr != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        zzda zzda2 = new zzda(this);
        if (this.zzfmn.containsKey(zzbcr.zzdwp)) {
            this.zza(this, zzda2, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzbf zzbf2 = new zzbf(this, atomicReference, zzda2);
            zzbg zzbg2 = new zzbg(this, zzda2);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzbcr.API).addConnectionCallbacks(zzbf2).addOnConnectionFailedListener(zzbg2).setHandler(this.zzfml).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzda2;
    }

    private final void zza(GoogleApiClient googleApiClient, zzda zzda2, boolean bl) {
        zzbcr.zzfwh.zzd(googleApiClient).setResultCallback(new zzbh(this, zzda2, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        zzcf zzcf2 = new zzcf((Activity)fragmentActivity);
        zzbd zzbd2 = this;
        if (zzbd2.zzfhj >= 0) {
            zzi.zza(zzcf2).zzbp(zzbd2.zzfhj);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzfmh != null && this.zzfmh.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfmh != null && this.zzfmh.isConnecting();
    }

    private final void zzbt(int n) {
        if (this.zzfmr == null) {
            this.zzfmr = n;
        } else if (this.zzfmr != n) {
            String string2 = zzbd.zzbu(n);
            String string3 = zzbd.zzbu(this.zzfmr);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzfmh != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzfmn.values()) {
            if (zze2.zzaac()) {
                bl = true;
            }
            if (!zze2.zzaal()) continue;
            bl2 = true;
        }
        switch (this.zzfmr) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzfhp) {
                    this.zzfmh = new zzad(this.mContext, this.zzfke, this.zzakg, this.zzfhl, this.zzfmn, this.zzfkj, this.zzfkm, this.zzfhm, this.zzfmq, this, true);
                    return;
                }
                this.zzfmh = zzy.zza(this.mContext, this, this.zzfke, this.zzakg, this.zzfhl, this.zzfmn, this.zzfkj, this.zzfkm, this.zzfhm, this.zzfmq);
                return;
            }
        }
        if (this.zzfhp && !bl2) {
            this.zzfmh = new zzad(this.mContext, this.zzfke, this.zzakg, this.zzfhl, this.zzfmn, this.zzfkj, this.zzfkm, this.zzfhm, this.zzfmq, this, false);
            return;
        }
        this.zzfmh = new zzbl(this.mContext, this, this.zzfke, this.zzakg, this.zzfhl, this.zzfmn, this.zzfkj, this.zzfkm, this.zzfhm, this.zzfmq, this);
    }

    private final void zzahg() {
        this.zzfmg.zzakf();
        this.zzfmh.connect();
    }

    private final void resume() {
        this.zzfke.lock();
        try {
            if (this.zzfmi) {
                this.zzahg();
            }
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    private final void zzahh() {
        this.zzfke.lock();
        try {
            if (this.zzahi()) {
                this.zzahg();
            }
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    final boolean zzahi() {
        if (!this.zzfmi) {
            return false;
        }
        this.zzfmi = false;
        this.zzfml.removeMessages(2);
        this.zzfml.removeMessages(1);
        if (this.zzfmm != null) {
            this.zzfmm.unregister();
            this.zzfmm = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfmg.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzfmg.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfmg.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfmg.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzfmg.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfmg.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final void zzj(Bundle bundle) {
        while (!this.zzfks.isEmpty()) {
            ((GoogleApiClient)this).zze(this.zzfks.remove());
        }
        this.zzfmg.zzk(bundle);
    }

    @Override
    public final void zzc(ConnectionResult connectionResult) {
        if (!zze.zze((Context)this.mContext, (int)connectionResult.getErrorCode())) {
            this.zzahi();
        }
        if (!this.zzfmi) {
            this.zzfmg.zzk(connectionResult);
            this.zzfmg.zzake();
        }
    }

    @Override
    public final void zzf(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzbd zzbd2 = this;
            if (!zzbd2.zzfmi) {
                zzbd2.zzfmi = true;
                if (zzbd2.zzfmm == null) {
                    zzbd2.zzfmm = GoogleApiAvailability.zza(zzbd2.mContext.getApplicationContext(), new zzbj(zzbd2));
                }
                zzbd2.zzfml.sendMessageDelayed(zzbd2.zzfml.obtainMessage(1), zzbd2.zzfmj);
                zzbd2.zzfml.sendMessageDelayed(zzbd2.zzfml.obtainMessage(2), zzbd2.zzfmk);
            }
        }
        this.zzfmt.zzaiq();
        this.zzfmg.zzce(n);
        this.zzfmg.zzake();
        if (n == 2) {
            this.zzahg();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zzakg;
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        return this.zzfmh != null && this.zzfmh.zza(zzcv2);
    }

    @Override
    public final void zzafp() {
        if (this.zzfmh != null) {
            this.zzfmh.zzafp();
        }
    }

    @Override
    public final void zza(zzdg zzdg2) {
        this.zzfke.lock();
        try {
            if (this.zzfms == null) {
                this.zzfms = new HashSet<zzdg>();
            }
            this.zzfms.add(zzdg2);
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final void zzb(zzdg zzdg2) {
        this.zzfke.lock();
        try {
            if (this.zzfms == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzfms.remove(zzdg2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzahj()) {
                this.zzfmh.zzagi();
            }
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    final boolean zzahj() {
        this.zzfke.lock();
        try {
            if (this.zzfms == null) {
                return false;
            }
            boolean bl = !this.zzfms.isEmpty();
            return bl;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    final String zzahk() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzfmi);
        printWriter.append(" mWorkQueue.size()=").print(this.zzfks.size());
        PrintWriter printWriter2 = printWriter;
        zzdj zzdj2 = this.zzfmt;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzdj2.zzfps.size());
        if (this.zzfmh != null) {
            this.zzfmh.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzaac()) {
                bl2 = true;
            }
            if (!zze2.zzaal()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzbu(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzbd zzbd2) {
        zzbd2.resume();
    }

    static /* synthetic */ void zzb(zzbd zzbd2) {
        zzbd2.zzahh();
    }

    static /* synthetic */ void zza(zzbd zzbd2, GoogleApiClient googleApiClient, zzda zzda2, boolean bl) {
        zzbd2.zza(googleApiClient, zzda2, true);
    }

    static /* synthetic */ Context zzc(zzbd zzbd2) {
        return zzbd2.mContext;
    }
}

