/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzdg;
import com.google.android.gms.common.api.internal.zzdm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.internal.zzap;
import com.google.android.gms.common.internal.zzbp;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzs<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzfjd = new zzt();
    private final Object zzfje = new Object();
    private zzu<R> zzfjf;
    private WeakReference<GoogleApiClient> zzfjg;
    private final CountDownLatch zzaoe = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzfjh = new ArrayList();
    private ResultCallback<? super R> zzfji;
    private final AtomicReference<zzdm> zzfjj = new AtomicReference();
    private R zzfhq;
    private Status mStatus;
    private zzv zzfjk;
    private volatile boolean zzfjl;
    private boolean zzaj;
    private boolean zzfjm;
    private zzap zzfjn;
    private volatile zzdg<R> zzfjo;
    private boolean zzfjp = false;

    @Deprecated
    zzs() {
        this.zzfjf = new zzu(Looper.getMainLooper());
        this.zzfjg = new WeakReference<Object>(null);
    }

    protected zzs(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzfjf = new zzu(looper);
        this.zzfjg = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzs(Looper looper) {
        this.zzfjf = new zzu(looper);
        this.zzfjg = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzaoe.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzbp.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzbp.zza((!this.zzfjl ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzbp.zza((this.zzfjo == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzaoe.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzu(Status.zzfhv);
        }
        zzbp.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzbp.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzbp.zza((!this.zzfjl ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzbp.zza((this.zzfjo == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zzaoe.await(l, timeUnit)) {
                this.zzu(Status.zzfhx);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzu(Status.zzfhv);
        }
        zzbp.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzfje;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfji = null;
                return;
            }
            zzbp.zza((!this.zzfjl ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbp.zza((this.zzfjo == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfjf.zza(resultCallback, (R)this.get());
            } else {
                this.zzfji = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzfje;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfji = null;
                return;
            }
            zzbp.zza((!this.zzfjl ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbp.zza((this.zzfjo == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfjf.zza(resultCallback, (R)this.get());
            } else {
                this.zzfji = resultCallback;
                long l2 = timeUnit.toMillis(l);
                zzs zzs2 = this;
                zzu<R> zzu2 = this.zzfjf;
                zzu2.sendMessageDelayed(zzu2.obtainMessage(2, zzs2), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzbp.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzfje;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzq(this.mStatus);
            } else {
                this.zzfjh.add(zza2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzfje;
        synchronized (object) {
            if (this.zzaj || this.zzfjl) {
                return;
            }
            if (this.zzfjn != null) {
                try {
                    this.zzfjn.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            zzs.zzd(this.zzfhq);
            this.zzaj = true;
            this.zzc(this.zzb(Status.zzfhy));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzagf() {
        Object object = this.zzfje;
        synchronized (object) {
            if ((GoogleApiClient)this.zzfjg.get() == null || !this.zzfjp) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzfje;
        synchronized (object) {
            return this.zzaj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzbp.zza((!this.zzfjl ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzfje;
        synchronized (object) {
            zzbp.zza((this.zzfjo == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbp.zza((this.zzfji == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzbp.zza((!this.zzaj ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzfjp = true;
            this.zzfjo = new zzdg(this.zzfjg);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zzfjo).then(resultTransform);
            if (this.isReady()) {
                this.zzfjf.zza(this.zzfjo, this.get());
            } else {
                this.zzfji = this.zzfjo;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R r) {
        Object object = this.zzfje;
        synchronized (object) {
            if (!this.zzfjm && !this.zzaj) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                zzs.zzd(r);
                return;
            }
            zzbp.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzbp.zza((!this.zzfjl ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzu(Status status) {
        Object object = this.zzfje;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.zzb(status));
                this.zzfjm = true;
            }
            return;
        }
    }

    @NonNull
    protected abstract R zzb(Status var1);

    public final void zza(zzdm zzdm2) {
        this.zzfjj.set(zzdm2);
    }

    @Override
    public final Integer zzafs() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzap zzap2) {
        Object object = this.zzfje;
        synchronized (object) {
            this.zzfjn = zzap2;
            return;
        }
    }

    public final void zzagg() {
        this.zzfjp = this.zzfjp || zzfjd.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zzfje;
        synchronized (object) {
            zzbp.zza((!this.zzfjl ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbp.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzfhq;
            this.zzfhq = null;
            this.zzfji = null;
            this.zzfjl = true;
        }
        zzs zzs2 = this;
        zzdm zzdm2 = zzs2.zzfjj.getAndSet(null);
        if (zzdm2 != null) {
            zzdm2.zzc(zzs2);
        }
        return r;
    }

    private final void zzc(R r) {
        this.zzfhq = r;
        this.zzfjn = null;
        this.zzaoe.countDown();
        this.mStatus = this.zzfhq.getStatus();
        if (this.zzaj) {
            this.zzfji = null;
        } else if (this.zzfji == null) {
            if (this.zzfhq instanceof Releasable) {
                this.zzfjk = new zzv(this, null);
            }
        } else {
            this.zzfjf.removeMessages(2);
            this.zzfjf.zza(this.zzfji, (R)this.get());
        }
        ArrayList<PendingResult.zza> arrayList = this.zzfjh;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.zza zza2 = arrayList.get(i);
            zza2.zzq(this.mStatus);
        }
        this.zzfjh.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ Result zza(zzs zzs2) {
        return zzs2.zzfhq;
    }
}

