/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzct;
import com.google.android.gms.common.api.internal.zzdh;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.internal.zzbp;
import java.lang.ref.WeakReference;

public final class zzdg<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzfpg = null;
    private zzdg<? extends Result> zzfph = null;
    private volatile ResultCallbacks<? super R> zzfpi = null;
    private PendingResult<R> zzfpj = null;
    private final Object zzfje = new Object();
    private Status zzfpk = null;
    private final WeakReference<GoogleApiClient> zzfjg;
    private final zzdi zzfpl;
    private boolean zzfpm = false;

    public zzdg(WeakReference<GoogleApiClient> weakReference) {
        zzbp.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzfjg = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfjg.get();
        this.zzfpl = new zzdi(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzfje;
        synchronized (object) {
            zzbp.zza((this.zzfpg == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbp.zza((this.zzfpi == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfpg = resultTransform;
            zzdg<R> zzdg2 = new zzdg<R>(this.zzfjg);
            this.zzfph = zzdg2;
            this.zzaio();
            return zzdg2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzfje;
        synchronized (object) {
            zzbp.zza((this.zzfpi == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzbp.zza((this.zzfpg == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfpi = resultCallbacks;
            this.zzaio();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zzfje;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzfpg != null) {
                    zzct.zzahn().submit(new zzdh(this, (Result)r));
                } else if (this.zzaiq()) {
                    this.zzfpi.onSuccess(r);
                }
            } else {
                this.zzd(r.getStatus());
                zzdg.zzd(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zzfje;
        synchronized (object) {
            this.zzfpj = pendingResult;
            this.zzaio();
            return;
        }
    }

    private final void zzaio() {
        if (this.zzfpg == null && this.zzfpi == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfjg.get();
        if (!this.zzfpm && this.zzfpg != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzfpm = true;
        }
        if (this.zzfpk != null) {
            this.zzw(this.zzfpk);
            return;
        }
        if (this.zzfpj != null) {
            this.zzfpj.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzd(Status status) {
        Object object = this.zzfje;
        synchronized (object) {
            this.zzfpk = status;
            this.zzw(this.zzfpk);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzw(Status status) {
        Object object = this.zzfje;
        synchronized (object) {
            if (this.zzfpg != null) {
                Status status2 = this.zzfpg.onFailure(status);
                zzbp.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzd(status2);
            } else if (this.zzaiq()) {
                this.zzfpi.onFailure(status);
            }
            return;
        }
    }

    final void zzaip() {
        this.zzfpi = null;
    }

    private final boolean zzaiq() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfjg.get();
        return this.zzfpi != null && googleApiClient != null;
    }

    private static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zzc(zzdg zzdg2) {
        return zzdg2.zzfpg;
    }

    static /* synthetic */ zzdi zzd(zzdg zzdg2) {
        return zzdg2.zzfpl;
    }

    static /* synthetic */ void zza(zzdg zzdg2, Result result) {
        zzdg.zzd(result);
    }

    static /* synthetic */ WeakReference zze(zzdg zzdg2) {
        return zzdg2.zzfjg;
    }

    static /* synthetic */ Object zzf(zzdg zzdg2) {
        return zzdg2.zzfje;
    }

    static /* synthetic */ zzdg zzg(zzdg zzdg2) {
        return zzdg2.zzfph;
    }

    static /* synthetic */ void zza(zzdg zzdg2, Status status) {
        zzdg2.zzd(status);
    }
}

