/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzao;
import com.google.android.gms.common.api.internal.zzar;
import com.google.android.gms.common.api.internal.zzbc;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbk;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbn;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzce;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbl
implements zzcd,
zzx {
    private final Lock zzfkd;
    private final Condition zzfmz;
    private final Context mContext;
    private final zze zzfkn;
    private final zzbn zzfna;
    final Map<Api.zzc<?>, Api.zze> zzfmm;
    final Map<Api.zzc<?>, ConnectionResult> zzfnb = new HashMap();
    private zzq zzfki;
    private Map<Api<?>, Boolean> zzfkl;
    private Api.zza<? extends zzcps, zzcpt> zzfhl;
    private volatile zzbk zzfnc;
    private ConnectionResult zzfnd = null;
    int zzfne;
    final zzbd zzfjt;
    final zzce zzfnf;

    public zzbl(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcps, zzcpt> zza2, ArrayList<zzw> arrayList, zzce zzce2) {
        this.mContext = context;
        this.zzfkd = lock;
        this.zzfkn = zze2;
        this.zzfmm = map;
        this.zzfki = zzq2;
        this.zzfkl = map2;
        this.zzfhl = zza2;
        this.zzfjt = zzbd2;
        this.zzfnf = zzce2;
        ArrayList<zzw> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList2.get(i);
            zzw2.zza(this);
        }
        this.zzfna = new zzbn(this, looper);
        this.zzfmz = lock.newCondition();
        this.zzfnc = new zzbc(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        t.zzagg();
        return this.zzfnc.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        t.zzagg();
        return this.zzfnc.zze(t);
    }

    @Override
    public final void connect() {
        this.zzfnc.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfmz.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzffe;
        }
        if (this.zzfnd != null) {
            return this.zzfnd;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfmz.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzffe;
        }
        if (this.zzfnd != null) {
            return this.zzfnd;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        if (this.zzfnc.disconnect()) {
            this.zzfnb.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzafe();
        if (this.zzfmm.containsKey(zzc2)) {
            if (this.zzfmm.get(zzc2).isConnected()) {
                return ConnectionResult.zzffe;
            }
            if (this.zzfnb.containsKey(zzc2)) {
                return this.zzfnb.get(zzc2);
            }
        }
        return null;
    }

    final void zzahl() {
        this.zzfkd.lock();
        try {
            this.zzfnc = new zzar(this, this.zzfki, this.zzfkl, this.zzfkn, this.zzfhl, this.zzfkd, this.mContext);
            this.zzfnc.begin();
            this.zzfmz.signalAll();
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    final void zzahm() {
        this.zzfkd.lock();
        try {
            this.zzfjt.zzahi();
            this.zzfnc = new zzao(this);
            this.zzfnc.begin();
            this.zzfmz.signalAll();
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    final void zzg(ConnectionResult connectionResult) {
        this.zzfkd.lock();
        try {
            this.zzfnd = connectionResult;
            this.zzfnc = new zzbc(this);
            this.zzfnc.begin();
            this.zzfmz.signalAll();
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzfnc instanceof zzao;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfnc instanceof zzar;
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        return false;
    }

    @Override
    public final void zzafp() {
    }

    @Override
    public final void zzagi() {
        if (this.isConnected()) {
            ((zzao)this.zzfnc).zzagy();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzfkd.lock();
        try {
            this.zzfnc.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzfkd.lock();
        try {
            this.zzfnc.onConnected(bundle);
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzfkd.lock();
        try {
            this.zzfnc.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzfkd.unlock();
        }
    }

    final void zza(zzbm zzbm2) {
        Message message = this.zzfna.obtainMessage(1, zzbm2);
        this.zzfna.sendMessage(message);
    }

    final void zza(RuntimeException runtimeException) {
        Message message = this.zzfna.obtainMessage(2, runtimeException);
        this.zzfna.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzfnc);
        for (Api<?> api : this.zzfkl.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzfmm.get(api.zzafe()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbl zzbl2) {
        return zzbl2.zzfkd;
    }

    static /* synthetic */ zzbk zzb(zzbl zzbl2) {
        return zzbl2.zzfnc;
    }
}

