/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.GoogleSignInOptionsExtension;
import com.google.android.gms.auth.api.signin.internal.zzn;
import com.google.android.gms.auth.api.signin.internal.zzo;
import com.google.android.gms.auth.api.signin.zzc;
import com.google.android.gms.auth.api.signin.zzd;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInOptions
extends zzbck
implements Api.ApiOptions.Optional,
ReflectedParcelable {
    public static final Scope zzecc = new Scope("profile");
    public static final Scope zzecd = new Scope("email");
    public static final Scope zzece = new Scope("openid");
    private static Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final GoogleSignInOptions DEFAULT_SIGN_IN = new Builder().requestId().requestProfile().build();
    public static final GoogleSignInOptions DEFAULT_GAMES_SIGN_IN = new Builder().requestScopes(SCOPE_GAMES, new Scope[0]).build();
    public static final Parcelable.Creator<GoogleSignInOptions> CREATOR = new zzd();
    private int versionCode;
    private final ArrayList<Scope> zzecf;
    private Account zzduy;
    private boolean zzeao;
    private final boolean zzecg;
    private final boolean zzech;
    private String zzeap;
    private String zzeci;
    private ArrayList<zzn> zzecj;
    private Map<Integer, zzn> zzeck;
    private static Comparator<Scope> zzecb = new zzc();

    @Nullable
    public static GoogleSignInOptions zzen(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("scopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        Account account = null;
        String string3 = jSONObject.optString("accountName", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            account = new Account(string3, "com.google");
        }
        return new GoogleSignInOptions(3, new ArrayList<Scope>(hashSet), account, jSONObject.getBoolean("idTokenRequested"), jSONObject.getBoolean("serverAuthRequested"), jSONObject.getBoolean("forceCodeForRefreshToken"), jSONObject.optString("serverClientId", null), jSONObject.optString("hostedDomain", null), new HashMap<Integer, zzn>());
    }

    GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, ArrayList<zzn> arrayList2) {
        this(n, arrayList, account, bl, bl2, bl3, string2, string3, GoogleSignInOptions.zzu(arrayList2));
    }

    private GoogleSignInOptions(int n, ArrayList<Scope> arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map<Integer, zzn> map) {
        this.versionCode = n;
        this.zzecf = arrayList;
        this.zzduy = account;
        this.zzeao = bl;
        this.zzecg = bl2;
        this.zzech = bl3;
        this.zzeap = string2;
        this.zzeci = string3;
        this.zzecj = new ArrayList<zzn>(map.values());
        this.zzeck = map;
    }

    public final ArrayList<Scope> zzaag() {
        return new ArrayList<Scope>(this.zzecf);
    }

    public Scope[] getScopeArray() {
        return this.zzecf.toArray(new Scope[this.zzecf.size()]);
    }

    public final Account getAccount() {
        return this.zzduy;
    }

    public final boolean isIdTokenRequested() {
        return this.zzeao;
    }

    public final boolean zzaah() {
        return this.zzecg;
    }

    public final String getServerClientId() {
        return this.zzeap;
    }

    private static Map<Integer, zzn> zzu(@Nullable List<zzn> list) {
        HashMap<Integer, zzn> hashMap = new HashMap<Integer, zzn>();
        if (list == null) {
            return hashMap;
        }
        for (zzn zzn2 : list) {
            hashMap.put(zzn2.getType(), zzn2);
        }
        return hashMap;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInOptions googleSignInOptions = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)googleSignInOptions.versionCode);
        zzbcn.zzc((Parcel)parcel2, (int)2, googleSignInOptions.zzaag(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Parcelable)googleSignInOptions.zzduy, (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (boolean)googleSignInOptions.zzeao);
        zzbcn.zza((Parcel)parcel2, (int)5, (boolean)googleSignInOptions.zzecg);
        zzbcn.zza((Parcel)parcel2, (int)6, (boolean)googleSignInOptions.zzech);
        zzbcn.zza((Parcel)parcel2, (int)7, (String)googleSignInOptions.zzeap, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (String)googleSignInOptions.zzeci, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)9, googleSignInOptions.zzecj, (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            GoogleSignInOptions googleSignInOptions = (GoogleSignInOptions)object;
            if (this.zzecj.size() > 0 || googleSignInOptions.zzecj.size() > 0) {
                return false;
            }
            if (this.zzecf.size() != googleSignInOptions.zzaag().size() || !this.zzecf.containsAll(googleSignInOptions.zzaag())) {
                return false;
            }
            return (this.zzduy == null ? googleSignInOptions.zzduy == null : this.zzduy.equals((Object)googleSignInOptions.zzduy)) && (TextUtils.isEmpty((CharSequence)this.zzeap) ? TextUtils.isEmpty((CharSequence)googleSignInOptions.zzeap) : this.zzeap.equals(googleSignInOptions.zzeap)) && this.zzech == googleSignInOptions.zzech && this.zzeao == googleSignInOptions.zzeao && this.zzecg == googleSignInOptions.zzecg;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Scope> arrayList2 = this.zzecf;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            Scope scope = arrayList2.get(i);
            Scope scope2 = scope;
            arrayList.add(scope2.zzaft());
        }
        Collections.sort(arrayList);
        return new zzo().zzo(arrayList).zzo(this.zzduy).zzo(this.zzeap).zzaq(this.zzech).zzaq(this.zzeao).zzaq(this.zzecg).zzaao();
    }

    public final String zzaai() {
        return this.toJsonObject().toString();
    }

    private final JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzecf, zzecb);
            ArrayList<Scope> arrayList = this.zzecf;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Scope scope = arrayList.get(i);
                Scope scope2 = scope;
                jSONArray.put((Object)scope2.zzaft());
            }
            jSONObject.put("scopes", (Object)jSONArray);
            if (this.zzduy != null) {
                jSONObject.put("accountName", (Object)this.zzduy.name);
            }
            jSONObject.put("idTokenRequested", this.zzeao);
            jSONObject.put("forceCodeForRefreshToken", this.zzech);
            jSONObject.put("serverAuthRequested", this.zzecg);
            if (!TextUtils.isEmpty((CharSequence)this.zzeap)) {
                jSONObject.put("serverClientId", (Object)this.zzeap);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzeci)) {
                jSONObject.put("hostedDomain", (Object)this.zzeci);
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    /* synthetic */ GoogleSignInOptions(int n, ArrayList arrayList, Account account, boolean bl, boolean bl2, boolean bl3, String string2, String string3, Map map, zzc zzc2) {
        this(3, (ArrayList<Scope>)arrayList, account, bl, bl2, bl3, string2, string3, map);
    }

    public static final class Builder {
        private Set<Scope> zzecl = new HashSet<Scope>();
        private boolean zzecg;
        private boolean zzech;
        private boolean zzeao;
        private String zzeap;
        private Account zzduy;
        private String zzeci;
        private Map<Integer, zzn> zzecm = new HashMap<Integer, zzn>();

        public Builder() {
        }

        public Builder(@NonNull GoogleSignInOptions googleSignInOptions) {
            zzbp.zzu((Object)googleSignInOptions);
            this.zzecl = new HashSet<Scope>(googleSignInOptions.zzecf);
            this.zzecg = googleSignInOptions.zzecg;
            this.zzech = googleSignInOptions.zzech;
            this.zzeao = googleSignInOptions.zzeao;
            this.zzeap = googleSignInOptions.zzeap;
            this.zzduy = googleSignInOptions.zzduy;
            this.zzeci = googleSignInOptions.zzeci;
            this.zzecm = GoogleSignInOptions.zzu(googleSignInOptions.zzecj);
        }

        public final Builder requestId() {
            this.zzecl.add(zzece);
            return this;
        }

        public final Builder requestEmail() {
            this.zzecl.add(zzecd);
            return this;
        }

        public final Builder requestProfile() {
            this.zzecl.add(zzecc);
            return this;
        }

        public final Builder requestScopes(Scope scope, Scope ... scopeArray) {
            this.zzecl.add(scope);
            this.zzecl.addAll(Arrays.asList(scopeArray));
            return this;
        }

        public final Builder requestIdToken(String string2) {
            this.zzeao = true;
            this.zzeap = this.zzeo(string2);
            return this;
        }

        public final Builder requestServerAuthCode(String string2) {
            return this.requestServerAuthCode(string2, false);
        }

        public final Builder requestServerAuthCode(String string2, boolean bl) {
            this.zzecg = true;
            this.zzeap = this.zzeo(string2);
            this.zzech = bl;
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzduy = new Account(zzbp.zzgg((String)string2), "com.google");
            return this;
        }

        public final Builder setHostedDomain(String string2) {
            this.zzeci = zzbp.zzgg((String)string2);
            return this;
        }

        public final Builder addExtension(GoogleSignInOptionsExtension googleSignInOptionsExtension) {
            if (this.zzecm.containsKey(1)) {
                throw new IllegalStateException("Only one extension per type may be added");
            }
            this.zzecm.put(1, new zzn(googleSignInOptionsExtension));
            return this;
        }

        public final GoogleSignInOptions build() {
            if (this.zzeao && (this.zzduy == null || !this.zzecl.isEmpty())) {
                this.requestId();
            }
            return new GoogleSignInOptions(3, new ArrayList<Scope>(this.zzecl), this.zzduy, this.zzeao, this.zzecg, this.zzech, this.zzeap, this.zzeci, this.zzecm, null);
        }

        private final String zzeo(String string2) {
            zzbp.zzgg((String)string2);
            zzbp.zzb((this.zzeap == null || this.zzeap.equals(string2) ? 1 : 0) != 0, (Object)"two different server client ids provided");
            return string2;
        }
    }
}

