/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.internal.zzy;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzak;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbr;
import com.google.android.gms.common.api.internal.zzbx;
import com.google.android.gms.common.api.internal.zzcw;
import com.google.android.gms.common.api.internal.zzcz;
import com.google.android.gms.common.api.internal.zzdd;
import com.google.android.gms.common.api.internal.zzg;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.zzd;
import com.google.android.gms.common.api.zze;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class GoogleApi<O extends Api.ApiOptions> {
    private final Context mContext;
    private final Api<O> zzfda;
    private final O zzfgl;
    private final zzh<O> zzfgm;
    private final Looper zzakl;
    private final int mId;
    private final GoogleApiClient zzfgn;
    private final zzcz zzfgo;
    protected final zzbp zzfgp;

    protected GoogleApi(@NonNull Context context, Api<O> api, Looper looper) {
        com.google.android.gms.common.internal.zzbp.zzb((Object)context, (Object)"Null context is not permitted.");
        com.google.android.gms.common.internal.zzbp.zzb(api, (Object)"Api must not be null.");
        com.google.android.gms.common.internal.zzbp.zzb((Object)looper, (Object)"Looper must not be null.");
        this.mContext = context.getApplicationContext();
        this.zzfda = api;
        this.zzfgl = null;
        this.zzakl = looper;
        this.zzfgm = zzh.zzb(api);
        this.zzfgn = new zzbx(this);
        this.zzfgp = zzbp.zzcb(this.mContext);
        this.mId = this.zzfgp.zzahp();
        this.zzfgo = new zzg();
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, Looper looper, zzcz zzcz2) {
        this(context, api, null, new zze().zza(looper).zza(zzcz2).zzafm());
    }

    @MainThread
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zza zza2) {
        com.google.android.gms.common.internal.zzbp.zzb((Object)activity, (Object)"Null activity is not permitted.");
        com.google.android.gms.common.internal.zzbp.zzb(api, (Object)"Api must not be null.");
        com.google.android.gms.common.internal.zzbp.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = activity.getApplicationContext();
        this.zzfda = api;
        this.zzfgl = o;
        this.zzakl = zza2.zzfgs;
        this.zzfgm = zzh.zza(this.zzfda, this.zzfgl);
        this.zzfgn = new zzbx(this);
        this.zzfgp = zzbp.zzcb(this.mContext);
        this.mId = this.zzfgp.zzahp();
        this.zzfgo = zza2.zzfgr;
        zzak.zza(activity, this.zzfgp, this.zzfgm);
        this.zzfgp.zzb(this);
    }

    public GoogleApi(@NonNull Context context, Api<O> api, O o, zza zza2) {
        com.google.android.gms.common.internal.zzbp.zzb((Object)context, (Object)"Null context is not permitted.");
        com.google.android.gms.common.internal.zzbp.zzb(api, (Object)"Api must not be null.");
        com.google.android.gms.common.internal.zzbp.zzb((Object)zza2, (Object)"Settings must not be null; use Settings.DEFAULT_SETTINGS instead.");
        this.mContext = context.getApplicationContext();
        this.zzfda = api;
        this.zzfgl = o;
        this.zzakl = zza2.zzfgs;
        this.zzfgm = zzh.zza(this.zzfda, this.zzfgl);
        this.zzfgn = new zzbx(this);
        this.zzfgp = zzbp.zzcb(this.mContext);
        this.mId = this.zzfgp.zzahp();
        this.zzfgo = zza2.zzfgr;
        this.zzfgp.zzb(this);
    }

    @Deprecated
    public GoogleApi(@NonNull Activity activity, Api<O> api, O o, zzcz zzcz2) {
        this(activity, api, o, new zze().zza(zzcz2).zza(activity.getMainLooper()).zzafm());
    }

    @Deprecated
    public GoogleApi(@NonNull Context context, Api<O> api, O o, zzcz zzcz2) {
        this(context, api, o, new zze().zza(zzcz2).zzafm());
    }

    private final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(int n, @NonNull T t) {
        t.zzagf();
        this.zzfgp.zza(this, n, t);
        return t;
    }

    private final <TResult, A extends Api.zzb> Task<TResult> zza(int n, @NonNull zzdd<A, TResult> zzdd2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.zzfgp.zza(this, n, zzdd2, taskCompletionSource, this.zzfgo);
        return taskCompletionSource.getTask();
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zza(@NonNull T t) {
        return this.zza(0, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zza(zzdd<A, TResult> zzdd2) {
        return this.zza(0, zzdd2);
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzb(@NonNull T t) {
        return this.zza(1, t);
    }

    public final <TResult, A extends Api.zzb> Task<TResult> zzb(zzdd<A, TResult> zzdd2) {
        return this.zza(1, zzdd2);
    }

    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zzc(@NonNull T t) {
        return this.zza(2, t);
    }

    @WorkerThread
    public Api.zze zza(Looper looper, zzbr<O> zzbr2) {
        zzq zzq2 = this.zzafl().zzfy(this.mContext.getPackageName()).zzfz(this.mContext.getClass().getName()).zzajz();
        return this.zzfda.zzafc().zza(this.mContext, looper, zzq2, this.zzfgl, zzbr2, zzbr2);
    }

    public final Api<O> zzafi() {
        return this.zzfda;
    }

    public final zzh<O> zzafj() {
        return this.zzfgm;
    }

    public final int getInstanceId() {
        return this.mId;
    }

    public final GoogleApiClient zzafk() {
        return this.zzfgn;
    }

    public final Looper getLooper() {
        return this.zzakl;
    }

    public final Context getApplicationContext() {
        return this.mContext;
    }

    private final zzr zzafl() {
        GoogleApi googleApi = this;
        return new zzr().zze(googleApi.zzfgl instanceof Api.ApiOptions.HasAccountOptions ? ((Api.ApiOptions.HasAccountOptions)googleApi.zzfgl).getAccount() : null);
    }

    public zzcw zza(Context context, Handler handler) {
        zzr zzr2 = this.zzafl();
        GoogleSignInOptions googleSignInOptions = zzy.zzbm(this.mContext).zzaas();
        if (googleSignInOptions != null) {
            zzr2.zze(googleSignInOptions.zzaae());
        }
        return new zzcw(context, handler, zzr2.zzajz());
    }

    public static final class zza {
        public static final zza zzfgq = new zze().zzafm();
        public final zzcz zzfgr;
        public final Looper zzfgs;

        private zza(zzcz zzcz2, Account account, Looper looper) {
            this.zzfgr = zzcz2;
            this.zzfgs = looper;
        }

        /* synthetic */ zza(zzcz zzcz2, Account account, Looper looper, zzd zzd2) {
            this(zzcz2, null, looper);
        }
    }
}

