/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbbi;
import com.google.android.gms.internal.zzbbl;
import com.google.android.gms.internal.zzbbm;
import com.google.android.gms.internal.zzbbn;
import com.google.android.gms.internal.zzbcp;
import com.google.android.gms.internal.zzbcx;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzctk;
import com.google.android.gms.internal.zzctl;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzbbk
implements zzbdp {
    private final Context mContext;
    private final zzbcp zzaCl;
    private final Looper zzrM;
    private final zzbcx zzaCm;
    private final zzbcx zzaCn;
    private final Map<Api.zzc<?>, zzbcx> zzaCo;
    private final Set<zzbei> zzaCp = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzaCq;
    private Bundle zzaCr;
    private ConnectionResult zzaCs = null;
    private ConnectionResult zzaCt = null;
    private boolean zzaCu = false;
    private final Lock zzaCv;
    private int zzaCw = 0;

    public static zzbbk zza(Context context, zzbcp zzbcp2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzctk, zzctl> zza2, ArrayList<zzbbi> arrayList) {
        Object object;
        Api.zze zze3 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzmG()) {
                zze3 = object;
            }
            if (object.zzmv()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzbo.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzpd();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzbbi>();
        ArrayList<zzbbi> arrayList2 = new ArrayList<zzbbi>();
        ArrayList<zzbbi> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzbbi zzbbi2 = arrayList3.get(i);
            zzbbi zzbbi3 = zzbbi2;
            if (arrayMap5.containsKey(zzbbi3.zzayW)) {
                ((ArrayList)object).add(zzbbi3);
                continue;
            }
            if (arrayMap.containsKey(zzbbi3.zzayW)) {
                arrayList2.add(zzbbi3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzbbk(context, zzbcp2, lock, looper, zze2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzq2, zza2, zze3, (ArrayList<zzbbi>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzbbk(Context context, zzbcp zzbcp2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzq zzq2, Api.zza<? extends zzctk, zzctl> zza2, Api.zze zze3, ArrayList<zzbbi> arrayList, ArrayList<zzbbi> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzaCl = zzbcp2;
        this.zzaCv = lock;
        this.zzrM = looper;
        this.zzaCq = zze3;
        this.zzaCm = new zzbcx(context, this.zzaCl, lock, looper, zze2, map2, null, map4, null, arrayList2, new zzbbm(this, null));
        this.zzaCn = new zzbcx(context, this.zzaCl, lock, looper, zze2, map, zzq2, map3, zza2, arrayList, new zzbbn(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzaCm);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzaCn);
        }
        this.zzaCo = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzbay<R, A>> T zzd(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzpH()) {
                t.zzr(new Status(4, null, this.zzpI()));
                return t;
            }
            return this.zzaCn.zzd(t);
        }
        return this.zzaCm.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzbay<? extends Result, A>> T zze(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzpH()) {
                t.zzr(new Status(4, null, this.zzpI()));
                return t;
            }
            return this.zzaCn.zze(t);
        }
        return this.zzaCm.zze(t);
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzaCo.get(api.zzpd()).equals(this.zzaCn)) {
            if (this.zzpH()) {
                return new ConnectionResult(4, this.zzpI());
            }
            return this.zzaCn.getConnectionResult(api);
        }
        return this.zzaCm.getConnectionResult(api);
    }

    @Override
    public final void connect() {
        this.zzaCw = 2;
        this.zzaCu = false;
        zzbbk zzbbk2 = this;
        this.zzaCt = null;
        zzbbk2.zzaCs = null;
        zzbbk2.zzaCm.connect();
        zzbbk2.zzaCn.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void disconnect() {
        this.zzaCt = null;
        this.zzaCs = null;
        this.zzaCw = 0;
        this.zzaCm.disconnect();
        this.zzaCn.disconnect();
        this.zzpG();
    }

    @Override
    public final boolean isConnected() {
        this.zzaCv.lock();
        try {
            boolean bl = this.zzaCm.isConnected() && (this.zzaCn.isConnected() || this.zzpH() || this.zzaCw == 1);
            return bl;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzaCv.lock();
        try {
            boolean bl = this.zzaCw == 2;
            return bl;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final boolean zza(zzbei zzbei2) {
        this.zzaCv.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzaCn.isConnected()) {
                this.zzaCp.add(zzbei2);
                if (this.zzaCw == 0) {
                    this.zzaCw = 1;
                }
                this.zzaCt = null;
                this.zzaCn.connect();
                return true;
            }
        }
        finally {
            this.zzaCv.unlock();
        }
        return false;
    }

    @Override
    public final void zzpE() {
        this.zzaCm.zzpE();
        this.zzaCn.zzpE();
    }

    @Override
    public final void zzpl() {
        this.zzaCv.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzaCn.disconnect();
            this.zzaCt = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzrM).post((Runnable)new zzbbl(this));
            } else {
                this.zzpG();
            }
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    private final void zzpF() {
        if (zzbbk.zzb(this.zzaCs)) {
            if (zzbbk.zzb(this.zzaCt) || this.zzpH()) {
                zzbbk zzbbk2 = this;
                switch (zzbbk2.zzaCw) {
                    case 2: {
                        zzbbk2.zzaCl.zzm(zzbbk2.zzaCr);
                    }
                    case 1: {
                        zzbbk2.zzpG();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzbbk2.zzaCw = 0;
                return;
            }
            if (this.zzaCt != null) {
                if (this.zzaCw == 1) {
                    this.zzpG();
                    return;
                }
                this.zza(this.zzaCt);
                this.zzaCm.disconnect();
                return;
            }
        } else {
            if (this.zzaCs != null && zzbbk.zzb(this.zzaCt)) {
                this.zzaCn.disconnect();
                this.zza(this.zzaCs);
                return;
            }
            if (this.zzaCs != null && this.zzaCt != null) {
                ConnectionResult connectionResult = this.zzaCs;
                if (this.zzaCn.zzaDX < this.zzaCm.zzaDX) {
                    connectionResult = this.zzaCt;
                }
                this.zza(connectionResult);
            }
        }
    }

    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzaCw) {
            case 2: {
                this.zzaCl.zzc(connectionResult);
            }
            case 1: {
                this.zzpG();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzaCw = 0;
    }

    private final void zzpG() {
        Iterator<zzbei> iterator = this.zzaCp.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzmF();
        }
        this.zzaCp.clear();
    }

    private final void zzd(int n, boolean bl) {
        this.zzaCl.zze(n, bl);
        this.zzaCt = null;
        this.zzaCs = null;
    }

    private final boolean zzpH() {
        return this.zzaCt != null && this.zzaCt.getErrorCode() == 4;
    }

    private final boolean zzf(zzbay<? extends Result, ? extends Api.zzb> zzbay2) {
        Api.zzc<? extends Api.zzb> zzc2 = zzbay2.zzpd();
        zzbo.zzb((boolean)this.zzaCo.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzaCo.get(zzc2).equals(this.zzaCn);
    }

    @Nullable
    private final PendingIntent zzpI() {
        if (this.zzaCq == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzaCl), (Intent)this.zzaCq.zzmH(), (int)0x8000000);
    }

    private final void zzl(Bundle bundle) {
        if (this.zzaCr == null) {
            this.zzaCr = bundle;
            return;
        }
        if (bundle != null) {
            this.zzaCr.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzaCn.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzaCm.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzbbk zzbbk2) {
        return zzbbk2.zzaCv;
    }

    static /* synthetic */ void zzb(zzbbk zzbbk2) {
        zzbbk2.zzpF();
    }

    static /* synthetic */ void zza(zzbbk zzbbk2, Bundle bundle) {
        zzbbk2.zzl(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzbbk zzbbk2, ConnectionResult connectionResult) {
        zzbbk2.zzaCs = connectionResult;
        return zzbbk2.zzaCs;
    }

    static /* synthetic */ boolean zzc(zzbbk zzbbk2) {
        return zzbbk2.zzaCu;
    }

    static /* synthetic */ ConnectionResult zzd(zzbbk zzbbk2) {
        return zzbbk2.zzaCt;
    }

    static /* synthetic */ boolean zza(zzbbk zzbbk2, boolean bl) {
        zzbbk2.zzaCu = bl;
        return zzbbk2.zzaCu;
    }

    static /* synthetic */ void zza(zzbbk zzbbk2, int n, boolean bl) {
        zzbbk2.zzd(n, bl);
    }

    static /* synthetic */ zzbcx zze(zzbbk zzbbk2) {
        return zzbbk2.zzaCn;
    }

    static /* synthetic */ ConnectionResult zzb(zzbbk zzbbk2, ConnectionResult connectionResult) {
        zzbbk2.zzaCt = connectionResult;
        return zzbbk2.zzaCt;
    }

    static /* synthetic */ zzbcx zzf(zzbbk zzbbk2) {
        return zzbbk2.zzaCm;
    }
}

