/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzbx;
import com.google.android.gms.internal.zzbal;
import com.google.android.gms.internal.zzbaq;
import com.google.android.gms.internal.zzbas;
import com.google.android.gms.internal.zzbau;
import com.google.android.gms.internal.zzbbi;
import com.google.android.gms.internal.zzbbs;
import com.google.android.gms.internal.zzbda;
import com.google.android.gms.internal.zzbdd;
import com.google.android.gms.internal.zzbde;
import com.google.android.gms.internal.zzbdf;
import com.google.android.gms.internal.zzbdg;
import com.google.android.gms.internal.zzbdx;
import com.google.android.gms.internal.zzbee;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzctj;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbdc<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzbbi {
    private final Queue<zzbal> zzaEn = new LinkedList<zzbal>();
    private final Api.zze zzaCy;
    private final Api.zzb zzaEo;
    private final zzbas<O> zzaAK;
    private final zzbbs zzaEp;
    private final Set<zzbau> zzaEq = new HashSet<zzbau>();
    private final Map<zzbdx<?>, zzbee> zzaEr = new HashMap();
    private final int zzaEs;
    private final zzbei zzaEt;
    private boolean zzaDA;
    private ConnectionResult zzaEu = null;
    private /* synthetic */ zzbda zzaEm;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbdc(zzbda zzbda2, GoogleApi googleApi) {
        this.zzaEm = zzbda2;
        this.zzaCy = googleApi.zza(zzbda.zza(zzbda2).getLooper(), this);
        if (this.zzaCy instanceof zzbx) {
            zzbx zzbx2 = (zzbx)this.zzaCy;
            this.zzaEo = null;
        } else {
            this.zzaEo = this.zzaCy;
        }
        this.zzaAK = googleApi.zzph();
        this.zzaEp = new zzbbs();
        this.zzaEs = googleApi.getInstanceId();
        if (this.zzaCy.zzmv()) {
            this.zzaEt = googleApi.zza(zzbda.zzb(zzbda2), zzbda.zza(zzbda2));
            return;
        }
        this.zzaEt = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzbda.zza(this.zzaEm).getLooper()) {
            this.zzqq();
            return;
        }
        zzbda.zza(this.zzaEm).post((Runnable)new zzbdd(this));
    }

    @WorkerThread
    private final void zzqq() {
        this.zzqt();
        this.zzi(ConnectionResult.zzazX);
        this.zzqv();
        for (zzbee zzbee2 : this.zzaEr.values()) {
            try {
                zzbee2.zzaBu.zzb(this.zzaEo, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzaCy.disconnect();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbdc zzbdc2 = this;
        while (zzbdc2.zzaCy.isConnected() && !zzbdc2.zzaEn.isEmpty()) {
            zzbal zzbal2 = zzbdc2.zzaEn.remove();
            zzbdc2.zzb(zzbal2);
        }
        this.zzqw();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzbda.zza(this.zzaEm).getLooper()) {
            this.zzqr();
            return;
        }
        zzbda.zza(this.zzaEm).post((Runnable)new zzbde(this));
    }

    @WorkerThread
    private final void zzqr() {
        this.zzqt();
        this.zzaDA = true;
        this.zzaEp.zzpQ();
        zzbda.zza(this.zzaEm).sendMessageDelayed(Message.obtain((Handler)zzbda.zza(this.zzaEm), (int)9, this.zzaAK), zzbda.zzc(this.zzaEm));
        zzbda.zza(this.zzaEm).sendMessageDelayed(Message.obtain((Handler)zzbda.zza(this.zzaEm), (int)11, this.zzaAK), zzbda.zzd(this.zzaEm));
        zzbda.zza(this.zzaEm, -1);
    }

    @WorkerThread
    public final void zzh(@NonNull ConnectionResult connectionResult) {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        this.zzaCy.disconnect();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzbda.zza(this.zzaEm).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzbda.zza(this.zzaEm).post((Runnable)new zzbdf(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        if (this.zzaEt != null) {
            this.zzaEt.zzqI();
        }
        this.zzqt();
        zzbda.zza(this.zzaEm, -1);
        this.zzi(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zzt(zzbda.zzqo());
            return;
        }
        if (this.zzaEn.isEmpty()) {
            this.zzaEu = connectionResult;
            return;
        }
        Object object = zzbda.zzqp();
        synchronized (object) {
            if (zzbda.zze(this.zzaEm) != null && zzbda.zzf(this.zzaEm).contains(this.zzaAK)) {
                zzbda.zze(this.zzaEm).zzb(connectionResult, this.zzaEs);
                return;
            }
        }
        if (!this.zzaEm.zzc(connectionResult, this.zzaEs)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzaDA = true;
            }
            if (this.zzaDA) {
                zzbda.zza(this.zzaEm).sendMessageDelayed(Message.obtain((Handler)zzbda.zza(this.zzaEm), (int)9, this.zzaAK), zzbda.zzc(this.zzaEm));
                return;
            }
            object = String.valueOf(this.zzaAK.zzpr());
            this.zzt(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zzbal zzbal2) {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        if (this.zzaCy.isConnected()) {
            this.zzb(zzbal2);
            this.zzqw();
            return;
        }
        this.zzaEn.add(zzbal2);
        if (this.zzaEu != null && this.zzaEu.hasResolution()) {
            this.onConnectionFailed(this.zzaEu);
            return;
        }
        this.connect();
    }

    @WorkerThread
    public final void signOut() {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        this.zzt(zzbda.zzaEc);
        this.zzaEp.zzpP();
        for (zzbdx<?> zzbdx2 : this.zzaEr.keySet()) {
            this.zza(new zzbaq(zzbdx2, (TaskCompletionSource<Void>)new TaskCompletionSource()));
        }
        this.zzi(new ConnectionResult(4));
        this.zzaCy.disconnect();
    }

    public final Api.zze zzpJ() {
        return this.zzaCy;
    }

    public final Map<zzbdx<?>, zzbee> zzqs() {
        return this.zzaEr;
    }

    @WorkerThread
    public final void zzqt() {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        this.zzaEu = null;
    }

    @WorkerThread
    public final ConnectionResult zzqu() {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        return this.zzaEu;
    }

    @WorkerThread
    private final void zzb(zzbal zzbal2) {
        zzbal2.zza(this.zzaEp, this.zzmv());
        try {
            zzbal2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzaCy.disconnect();
            return;
        }
    }

    @WorkerThread
    public final void zzt(Status status) {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        Iterator iterator = this.zzaEn.iterator();
        while (iterator.hasNext()) {
            ((zzbal)iterator.next()).zzp(status);
        }
        this.zzaEn.clear();
    }

    @WorkerThread
    public final void resume() {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        if (this.zzaDA) {
            this.connect();
        }
    }

    @WorkerThread
    private final void zzqv() {
        if (this.zzaDA) {
            zzbda.zza(this.zzaEm).removeMessages(11, this.zzaAK);
            zzbda.zza(this.zzaEm).removeMessages(9, this.zzaAK);
            this.zzaDA = false;
        }
    }

    @WorkerThread
    public final void zzqd() {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        if (this.zzaDA) {
            this.zzqv();
            Status status = zzbda.zzg(this.zzaEm).isGooglePlayServicesAvailable(zzbda.zzb(this.zzaEm)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zzt(status);
            this.zzaCy.disconnect();
        }
    }

    private final void zzqw() {
        zzbda.zza(this.zzaEm).removeMessages(12, this.zzaAK);
        zzbda.zza(this.zzaEm).sendMessageDelayed(zzbda.zza(this.zzaEm).obtainMessage(12, this.zzaAK), zzbda.zzh(this.zzaEm));
    }

    @WorkerThread
    public final void zzqx() {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        if (this.zzaCy.isConnected() && this.zzaEr.size() == 0) {
            if (this.zzaEp.zzpO()) {
                this.zzqw();
                return;
            }
            this.zzaCy.disconnect();
        }
    }

    @WorkerThread
    public final void connect() {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        if (this.zzaCy.isConnected() || this.zzaCy.isConnecting()) {
            return;
        }
        if (this.zzaCy.zzpe() && zzbda.zzi(this.zzaEm) != 0) {
            zzbda.zza(this.zzaEm, zzbda.zzg(this.zzaEm).isGooglePlayServicesAvailable(zzbda.zzb(this.zzaEm)));
            if (zzbda.zzi(this.zzaEm) != 0) {
                ConnectionResult connectionResult = new ConnectionResult(zzbda.zzi(this.zzaEm), null);
                this.onConnectionFailed(connectionResult);
                return;
            }
        }
        zzbdg zzbdg2 = new zzbdg(this.zzaEm, this.zzaCy, this.zzaAK);
        if (this.zzaCy.zzmv()) {
            this.zzaEt.zza(zzbdg2);
        }
        this.zzaCy.zza(zzbdg2);
    }

    @WorkerThread
    public final void zza(zzbau zzbau2) {
        zzbo.zza((Handler)zzbda.zza(this.zzaEm));
        this.zzaEq.add(zzbau2);
    }

    @WorkerThread
    private final void zzi(ConnectionResult connectionResult) {
        Iterator<zzbau> iterator = this.zzaEq.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(this.zzaAK, connectionResult);
        }
        this.zzaEq.clear();
    }

    final boolean isConnected() {
        return this.zzaCy.isConnected();
    }

    public final boolean zzmv() {
        return this.zzaCy.zzmv();
    }

    public final int getInstanceId() {
        return this.zzaEs;
    }

    final zzctj zzqy() {
        if (this.zzaEt == null) {
            return null;
        }
        return this.zzaEt.zzqy();
    }

    static /* synthetic */ void zzc(zzbdc zzbdc2) {
        zzbdc2.zzqq();
    }

    static /* synthetic */ void zzd(zzbdc zzbdc2) {
        zzbdc2.zzqr();
    }
}

