/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbh;
import com.google.android.gms.internal.zzbbi;
import com.google.android.gms.internal.zzbbz;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.internal.zzbco;
import com.google.android.gms.internal.zzbcv;
import com.google.android.gms.internal.zzbcx;
import com.google.android.gms.internal.zzbcy;
import com.google.android.gms.internal.zzbdo;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzbeh;
import com.google.android.gms.internal.zzctj;
import com.google.android.gms.internal.zzctk;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbcw
implements zzbbi,
zzbdo {
    private final Lock zzaCv;
    private final Condition zzaDS;
    private final Context mContext;
    private final zze zzaCF;
    private final zzbcy zzaDT;
    final Map<Api.zzc<?>, Api.zze> zzaDF;
    final Map<Api.zzc<?>, ConnectionResult> zzaDU = new HashMap();
    private zzq zzaCA;
    private Map<Api<?>, Boolean> zzaCD;
    private Api.zza<? extends zzctj, zzctk> zzaBe;
    private volatile zzbcv zzaDV;
    private ConnectionResult zzaDW = null;
    int zzaDX;
    final zzbco zzaCl;
    final zzbdp zzaDY;

    public zzbcw(Context context, zzbco zzbco2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzctj, zzctk> zza2, ArrayList<zzbbh> arrayList, zzbdp zzbdp2) {
        this.mContext = context;
        this.zzaCv = lock;
        this.zzaCF = zze2;
        this.zzaDF = map;
        this.zzaCA = zzq2;
        this.zzaCD = map2;
        this.zzaBe = zza2;
        this.zzaCl = zzbco2;
        this.zzaDY = zzbdp2;
        ArrayList<zzbbh> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzbbh zzbbh2 = arrayList2.get(i);
            zzbbh2.zza(this);
        }
        this.zzaDT = new zzbcy(this, looper);
        this.zzaDS = lock.newCondition();
        this.zzaDV = new zzbcn(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzbax<R, A>> T zzd(@NonNull T t) {
        t.zzpC();
        return this.zzaDV.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzbax<? extends Result, A>> T zze(@NonNull T t) {
        t.zzpC();
        return this.zzaDV.zze(t);
    }

    @Override
    public final void connect() {
        this.zzaDV.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzaDS.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzazX;
        }
        if (this.zzaDW != null) {
            return this.zzaDW;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzaDS.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzazX;
        }
        if (this.zzaDW != null) {
            return this.zzaDW;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        if (this.zzaDV.disconnect()) {
            this.zzaDU.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzpd();
        if (this.zzaDF.containsKey(zzc2)) {
            if (this.zzaDF.get(zzc2).isConnected()) {
                return ConnectionResult.zzazX;
            }
            if (this.zzaDU.containsKey(zzc2)) {
                return this.zzaDU.get(zzc2);
            }
        }
        return null;
    }

    final void zzqh() {
        this.zzaCv.lock();
        try {
            this.zzaDV = new zzbcc(this, this.zzaCA, this.zzaCD, this.zzaCF, this.zzaBe, this.zzaCv, this.mContext);
            this.zzaDV.begin();
            this.zzaDS.signalAll();
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    final void zzqi() {
        this.zzaCv.lock();
        try {
            this.zzaCl.zzqe();
            this.zzaDV = new zzbbz(this);
            this.zzaDV.begin();
            this.zzaDS.signalAll();
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    final void zzg(ConnectionResult connectionResult) {
        this.zzaCv.lock();
        try {
            this.zzaDW = connectionResult;
            this.zzaDV = new zzbcn(this);
            this.zzaDV.begin();
            this.zzaDS.signalAll();
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzaDV instanceof zzbbz;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzaDV instanceof zzbcc;
    }

    @Override
    public final boolean zza(zzbeh zzbeh2) {
        return false;
    }

    @Override
    public final void zzpl() {
    }

    @Override
    public final void zzpE() {
        if (this.isConnected()) {
            ((zzbbz)this.zzaDV).zzpU();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzaCv.lock();
        try {
            this.zzaDV.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzaCv.lock();
        try {
            this.zzaDV.onConnected(bundle);
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzaCv.lock();
        try {
            this.zzaDV.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    final void zza(zzbcx zzbcx2) {
        Message message = this.zzaDT.obtainMessage(1, zzbcx2);
        this.zzaDT.sendMessage(message);
    }

    final void zza(RuntimeException runtimeException) {
        Message message = this.zzaDT.obtainMessage(2, runtimeException);
        this.zzaDT.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzaDV);
        for (Api<?> api : this.zzaCD.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzaDF.get(api.zzpd()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbcw zzbcw2) {
        return zzbcw2.zzaCv;
    }

    static /* synthetic */ zzbcv zzb(zzbcw zzbcw2) {
        return zzbcw2.zzaDV;
    }
}

