/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbbh;
import com.google.android.gms.internal.zzbbk;
import com.google.android.gms.internal.zzbbl;
import com.google.android.gms.internal.zzbbm;
import com.google.android.gms.internal.zzbco;
import com.google.android.gms.internal.zzbcw;
import com.google.android.gms.internal.zzbdo;
import com.google.android.gms.internal.zzbeh;
import com.google.android.gms.internal.zzctj;
import com.google.android.gms.internal.zzctk;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzbbj
implements zzbdo {
    private final Context mContext;
    private final zzbco zzaCl;
    private final Looper zzrO;
    private final zzbcw zzaCm;
    private final zzbcw zzaCn;
    private final Map<Api.zzc<?>, zzbcw> zzaCo;
    private final Set<zzbeh> zzaCp = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzaCq;
    private Bundle zzaCr;
    private ConnectionResult zzaCs = null;
    private ConnectionResult zzaCt = null;
    private boolean zzaCu = false;
    private final Lock zzaCv;
    private int zzaCw = 0;

    public static zzbbj zza(Context context, zzbco zzbco2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzctj, zzctk> zza2, ArrayList<zzbbh> arrayList) {
        Object object;
        Api.zze zze3 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzmG()) {
                zze3 = object;
            }
            if (object.zzmv()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzbo.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzpd();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzbbh>();
        ArrayList<zzbbh> arrayList2 = new ArrayList<zzbbh>();
        ArrayList<zzbbh> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzbbh zzbbh2 = arrayList3.get(i);
            zzbbh zzbbh3 = zzbbh2;
            if (arrayMap5.containsKey(zzbbh3.zzayW)) {
                ((ArrayList)object).add(zzbbh3);
                continue;
            }
            if (arrayMap.containsKey(zzbbh3.zzayW)) {
                arrayList2.add(zzbbh3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzbbj(context, zzbco2, lock, looper, zze2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzq2, zza2, zze3, (ArrayList<zzbbh>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzbbj(Context context, zzbco zzbco2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzq zzq2, Api.zza<? extends zzctj, zzctk> zza2, Api.zze zze3, ArrayList<zzbbh> arrayList, ArrayList<zzbbh> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzaCl = zzbco2;
        this.zzaCv = lock;
        this.zzrO = looper;
        this.zzaCq = zze3;
        this.zzaCm = new zzbcw(context, this.zzaCl, lock, looper, zze2, map2, null, map4, null, arrayList2, new zzbbl(this, null));
        this.zzaCn = new zzbcw(context, this.zzaCl, lock, looper, zze2, map, zzq2, map3, zza2, arrayList, new zzbbm(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzaCm);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzaCn);
        }
        this.zzaCo = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzbax<R, A>> T zzd(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzpH()) {
                t.zzr(new Status(4, null, this.zzpI()));
                return t;
            }
            return this.zzaCn.zzd(t);
        }
        return this.zzaCm.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzbax<? extends Result, A>> T zze(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzpH()) {
                t.zzr(new Status(4, null, this.zzpI()));
                return t;
            }
            return this.zzaCn.zze(t);
        }
        return this.zzaCm.zze(t);
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzaCo.get(api.zzpd()).equals(this.zzaCn)) {
            if (this.zzpH()) {
                return new ConnectionResult(4, this.zzpI());
            }
            return this.zzaCn.getConnectionResult(api);
        }
        return this.zzaCm.getConnectionResult(api);
    }

    @Override
    public final void connect() {
        this.zzaCw = 2;
        this.zzaCu = false;
        zzbbj zzbbj2 = this;
        this.zzaCt = null;
        zzbbj2.zzaCs = null;
        zzbbj2.zzaCm.connect();
        zzbbj2.zzaCn.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void disconnect() {
        this.zzaCt = null;
        this.zzaCs = null;
        this.zzaCw = 0;
        this.zzaCm.disconnect();
        this.zzaCn.disconnect();
        this.zzpG();
    }

    @Override
    public final boolean isConnected() {
        this.zzaCv.lock();
        try {
            boolean bl = this.zzaCm.isConnected() && (this.zzaCn.isConnected() || this.zzpH() || this.zzaCw == 1);
            return bl;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzaCv.lock();
        try {
            boolean bl = this.zzaCw == 2;
            return bl;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    @Override
    public final boolean zza(zzbeh zzbeh2) {
        this.zzaCv.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzaCn.isConnected()) {
                this.zzaCp.add(zzbeh2);
                if (this.zzaCw == 0) {
                    this.zzaCw = 1;
                }
                this.zzaCt = null;
                this.zzaCn.connect();
                return true;
            }
        }
        finally {
            this.zzaCv.unlock();
        }
        return false;
    }

    @Override
    public final void zzpE() {
        this.zzaCm.zzpE();
        this.zzaCn.zzpE();
    }

    @Override
    public final void zzpl() {
        this.zzaCv.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzaCn.disconnect();
            this.zzaCt = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzrO).post((Runnable)new zzbbk(this));
            } else {
                this.zzpG();
            }
            return;
        }
        finally {
            this.zzaCv.unlock();
        }
    }

    private final void zzpF() {
        if (zzbbj.zzb(this.zzaCs)) {
            if (zzbbj.zzb(this.zzaCt) || this.zzpH()) {
                zzbbj zzbbj2 = this;
                switch (zzbbj2.zzaCw) {
                    case 2: {
                        zzbbj2.zzaCl.zzm(zzbbj2.zzaCr);
                    }
                    case 1: {
                        zzbbj2.zzpG();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzbbj2.zzaCw = 0;
                return;
            }
            if (this.zzaCt != null) {
                if (this.zzaCw == 1) {
                    this.zzpG();
                    return;
                }
                this.zza(this.zzaCt);
                this.zzaCm.disconnect();
                return;
            }
        } else {
            if (this.zzaCs != null && zzbbj.zzb(this.zzaCt)) {
                this.zzaCn.disconnect();
                this.zza(this.zzaCs);
                return;
            }
            if (this.zzaCs != null && this.zzaCt != null) {
                ConnectionResult connectionResult = this.zzaCs;
                if (this.zzaCn.zzaDX < this.zzaCm.zzaDX) {
                    connectionResult = this.zzaCt;
                }
                this.zza(connectionResult);
            }
        }
    }

    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzaCw) {
            case 2: {
                this.zzaCl.zzc(connectionResult);
            }
            case 1: {
                this.zzpG();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzaCw = 0;
    }

    private final void zzpG() {
        Iterator<zzbeh> iterator = this.zzaCp.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzmF();
        }
        this.zzaCp.clear();
    }

    private final void zzd(int n, boolean bl) {
        this.zzaCl.zze(n, bl);
        this.zzaCt = null;
        this.zzaCs = null;
    }

    private final boolean zzpH() {
        return this.zzaCt != null && this.zzaCt.getErrorCode() == 4;
    }

    private final boolean zzf(zzbax<? extends Result, ? extends Api.zzb> zzbax2) {
        Api.zzc<? extends Api.zzb> zzc2 = zzbax2.zzpd();
        zzbo.zzb((boolean)this.zzaCo.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzaCo.get(zzc2).equals(this.zzaCn);
    }

    @Nullable
    private final PendingIntent zzpI() {
        if (this.zzaCq == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzaCl), (Intent)this.zzaCq.zzmH(), (int)0x8000000);
    }

    private final void zzl(Bundle bundle) {
        if (this.zzaCr == null) {
            this.zzaCr = bundle;
            return;
        }
        if (bundle != null) {
            this.zzaCr.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzaCn.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzaCm.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzbbj zzbbj2) {
        return zzbbj2.zzaCv;
    }

    static /* synthetic */ void zzb(zzbbj zzbbj2) {
        zzbbj2.zzpF();
    }

    static /* synthetic */ void zza(zzbbj zzbbj2, Bundle bundle) {
        zzbbj2.zzl(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzbbj zzbbj2, ConnectionResult connectionResult) {
        zzbbj2.zzaCs = connectionResult;
        return zzbbj2.zzaCs;
    }

    static /* synthetic */ boolean zzc(zzbbj zzbbj2) {
        return zzbbj2.zzaCu;
    }

    static /* synthetic */ ConnectionResult zzd(zzbbj zzbbj2) {
        return zzbbj2.zzaCt;
    }

    static /* synthetic */ boolean zza(zzbbj zzbbj2, boolean bl) {
        zzbbj2.zzaCu = bl;
        return zzbbj2.zzaCu;
    }

    static /* synthetic */ void zza(zzbbj zzbbj2, int n, boolean bl) {
        zzbbj2.zzd(n, bl);
    }

    static /* synthetic */ zzbcw zze(zzbbj zzbbj2) {
        return zzbbj2.zzaCn;
    }

    static /* synthetic */ ConnectionResult zzb(zzbbj zzbbj2, ConnectionResult connectionResult) {
        zzbbj2.zzaCt = connectionResult;
        return zzbbj2.zzaCt;
    }

    static /* synthetic */ zzbcw zzf(zzbbj zzbbj2) {
        return zzbbj2.zzaCm;
    }
}

