/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzbbd;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzbem;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status status) {
        zzbo.zzb((Object)status, (Object)"Result must not be null");
        zzbem zzbem2 = new zzbem(Looper.getMainLooper());
        zzbem2.setResult(status);
        return zzbem2;
    }

    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzbo.zzb((Object)status, (Object)"Result must not be null");
        zzbem zzbem2 = new zzbem(googleApiClient);
        zzbem2.setResult(status);
        return zzbem2;
    }

    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzbo.zzb(r, (Object)"Result must not be null");
        zzbo.zzb((!r.getStatus().isSuccess() ? 1 : 0) != 0, (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.setResult(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R r) {
        zzbo.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.setResult(r);
        return new zzbeb(zzc2);
    }

    public static <R extends Result> OptionalPendingResult<R> zzb(R r, GoogleApiClient googleApiClient) {
        zzbo.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(googleApiClient);
        zzc2.setResult(r);
        return new zzbeb(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzbem zzbem2 = new zzbem(Looper.getMainLooper());
        zzbem2.cancel();
        return zzbem2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R r) {
        zzbo.zzb(r, (Object)"Result must not be null");
        zzbo.zzb((r.getStatus().getStatusCode() == 16 ? 1 : 0) != 0, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(r);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    static final class zza<R extends Result>
    extends zzbbd<R> {
        private final R zzaBi;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zzaBi = r;
        }

        @Override
        protected final R zzb(Status status) {
            if (status.getStatusCode() != this.zzaBi.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zzaBi;
        }
    }

    static final class zzb<R extends Result>
    extends zzbbd<R> {
        private final R zzaBj;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.zzaBj = r;
        }

        @Override
        protected final R zzb(Status status) {
            return this.zzaBj;
        }
    }

    static final class zzc<R extends Result>
    extends zzbbd<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected final R zzb(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

