/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.zzbgu;
import com.google.android.gms.internal.zzbgw;

public final class zzbgs
extends Drawable
implements Drawable.Callback {
    private int zzaGq = 0;
    private long zzahb;
    private int mFrom;
    private int zzaGr;
    private int zzaGs = 255;
    private int zzaGt;
    private int zzaGu = 0;
    private boolean zzaGl = true;
    private boolean zzaGv;
    private zzbgw zzaGw;
    private Drawable zzaGx;
    private Drawable zzaGy;
    private boolean zzaGz;
    private boolean zzaGA;
    private boolean zzaGB;
    private int zzaGC;

    public zzbgs(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zzbgu.zzqV();
        }
        this.zzaGx = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzaGw.zzaGF |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zzbgu.zzqV();
        }
        this.zzaGy = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzaGw.zzaGF |= drawable3.getChangingConfigurations();
    }

    zzbgs(zzbgw zzbgw2) {
        this.zzaGw = new zzbgw(zzbgw2);
    }

    public final void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public final void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public final void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public final int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzaGw.mChangingConfigurations | this.zzaGw.zzaGF;
    }

    public final void setAlpha(int n) {
        if (this.zzaGu == this.zzaGs) {
            this.zzaGu = n;
        }
        this.zzaGs = n;
        this.invalidateSelf();
    }

    public final void setColorFilter(ColorFilter colorFilter) {
        this.zzaGx.setColorFilter(colorFilter);
        this.zzaGy.setColorFilter(colorFilter);
    }

    public final int getIntrinsicWidth() {
        return Math.max(this.zzaGx.getIntrinsicWidth(), this.zzaGy.getIntrinsicWidth());
    }

    public final int getIntrinsicHeight() {
        return Math.max(this.zzaGx.getIntrinsicHeight(), this.zzaGy.getIntrinsicHeight());
    }

    protected final void onBoundsChange(Rect rect) {
        this.zzaGx.setBounds(rect);
        this.zzaGy.setBounds(rect);
    }

    public final Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzaGw.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzaGw;
        }
        return null;
    }

    public final int getOpacity() {
        if (!this.zzaGB) {
            this.zzaGC = Drawable.resolveOpacity((int)this.zzaGx.getOpacity(), (int)this.zzaGy.getOpacity());
            this.zzaGB = true;
        }
        return this.zzaGC;
    }

    private final boolean canConstantState() {
        if (!this.zzaGz) {
            this.zzaGA = this.zzaGx.getConstantState() != null && this.zzaGy.getConstantState() != null;
            this.zzaGz = true;
        }
        return this.zzaGA;
    }

    public final Drawable mutate() {
        if (!this.zzaGv && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzaGx.mutate();
            this.zzaGy.mutate();
            this.zzaGv = true;
        }
        return this;
    }

    public final Drawable zzqU() {
        return this.zzaGy;
    }

    public final void startTransition(int n) {
        this.mFrom = 0;
        this.zzaGr = this.zzaGs;
        this.zzaGu = 0;
        this.zzaGt = 250;
        this.zzaGq = 1;
        this.invalidateSelf();
    }

    public final void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzaGq) {
            case 1: {
                this.zzahb = SystemClock.uptimeMillis();
                bl = false;
                this.zzaGq = 2;
                break;
            }
            case 2: {
                float f;
                if (this.zzahb < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.zzahb) / (float)this.zzaGt;
                bl = f >= 1.0f;
                if (bl) {
                    this.zzaGq = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.zzaGu = (int)(0.0f + (float)this.zzaGr * f2);
            }
        }
        int n = this.zzaGu;
        boolean bl2 = this.zzaGl;
        Drawable drawable2 = this.zzaGx;
        Drawable drawable3 = this.zzaGy;
        if (bl) {
            if (!bl2 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzaGs) {
                drawable3.setAlpha(this.zzaGs);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl2) {
            drawable2.setAlpha(this.zzaGs - n);
        }
        drawable2.draw(canvas);
        if (bl2) {
            drawable2.setAlpha(this.zzaGs);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzaGs);
        }
        this.invalidateSelf();
    }
}

