/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzca;
import com.google.android.gms.internal.zzbby;
import com.google.android.gms.internal.zzbcd;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.internal.zzbch;
import com.google.android.gms.internal.zzbcv;
import com.google.android.gms.internal.zzbdf;
import com.google.android.gms.internal.zzben;
import com.google.android.gms.internal.zzbeq;
import com.google.android.gms.internal.zzber;
import com.google.android.gms.internal.zzbes;
import com.google.android.gms.internal.zzbet;
import com.google.android.gms.internal.zzbfk;
import com.google.android.gms.internal.zzbfr;
import com.google.android.gms.internal.zzbfv;
import com.google.android.gms.internal.zzcuw;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbep<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzbcv {
    private final Queue<zzbby> zzaEp = new LinkedList<zzbby>();
    private final Api.zze zzaCA;
    private final Api.zzb zzaEq;
    private final zzbcf<O> zzaAM;
    private final zzbdf zzaEr;
    private final Set<zzbch> zzaEs = new HashSet<zzbch>();
    private final Map<zzbfk<?>, zzbfr> zzaEt = new HashMap();
    private final int zzaEu;
    private final zzbfv zzaEv;
    private boolean zzaDC;
    private ConnectionResult zzaEw = null;
    private /* synthetic */ zzben zzaEo;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbep(zzben zzben2, GoogleApi googleApi) {
        this.zzaEo = zzben2;
        this.zzaCA = googleApi.zza(zzben.zza(zzben2).getLooper(), this);
        if (this.zzaCA instanceof zzca) {
            zzca zzca2 = (zzca)this.zzaCA;
            this.zzaEq = null;
        } else {
            this.zzaEq = this.zzaCA;
        }
        this.zzaAM = googleApi.zzpf();
        this.zzaEr = new zzbdf();
        this.zzaEu = googleApi.getInstanceId();
        if (this.zzaCA.zzmt()) {
            this.zzaEv = googleApi.zza(zzben.zzb(zzben2), zzben.zza(zzben2));
            return;
        }
        this.zzaEv = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzben.zza(this.zzaEo).getLooper()) {
            this.zzqo();
            return;
        }
        zzben.zza(this.zzaEo).post((Runnable)new zzbeq(this));
    }

    @WorkerThread
    private final void zzqo() {
        this.zzqr();
        this.zzi(ConnectionResult.zzazZ);
        this.zzqt();
        for (zzbfr zzbfr2 : this.zzaEt.values()) {
            try {
                zzbfr2.zzaBw.zzb(this.zzaEq, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzaCA.disconnect();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbep zzbep2 = this;
        while (zzbep2.zzaCA.isConnected() && !zzbep2.zzaEp.isEmpty()) {
            zzbby zzbby2 = zzbep2.zzaEp.remove();
            zzbep2.zzb(zzbby2);
        }
        this.zzqu();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzben.zza(this.zzaEo).getLooper()) {
            this.zzqp();
            return;
        }
        zzben.zza(this.zzaEo).post((Runnable)new zzber(this));
    }

    @WorkerThread
    private final void zzqp() {
        this.zzqr();
        this.zzaDC = true;
        this.zzaEr.zzpO();
        zzben.zza(this.zzaEo).sendMessageDelayed(Message.obtain((Handler)zzben.zza(this.zzaEo), (int)9, this.zzaAM), zzben.zzc(this.zzaEo));
        zzben.zza(this.zzaEo).sendMessageDelayed(Message.obtain((Handler)zzben.zza(this.zzaEo), (int)11, this.zzaAM), zzben.zzd(this.zzaEo));
        zzben.zza(this.zzaEo, -1);
    }

    @WorkerThread
    public final void zzh(@NonNull ConnectionResult connectionResult) {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        this.zzaCA.disconnect();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzben.zza(this.zzaEo).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzben.zza(this.zzaEo).post((Runnable)new zzbes(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        if (this.zzaEv != null) {
            this.zzaEv.zzqG();
        }
        this.zzqr();
        zzben.zza(this.zzaEo, -1);
        this.zzi(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zzt(zzben.zzqm());
            return;
        }
        if (this.zzaEp.isEmpty()) {
            this.zzaEw = connectionResult;
            return;
        }
        Object object = zzben.zzqn();
        synchronized (object) {
            if (zzben.zze(this.zzaEo) != null && zzben.zzf(this.zzaEo).contains(this.zzaAM)) {
                zzben.zze(this.zzaEo).zzb(connectionResult, this.zzaEu);
                return;
            }
        }
        if (!this.zzaEo.zzc(connectionResult, this.zzaEu)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzaDC = true;
            }
            if (this.zzaDC) {
                zzben.zza(this.zzaEo).sendMessageDelayed(Message.obtain((Handler)zzben.zza(this.zzaEo), (int)9, this.zzaAM), zzben.zzc(this.zzaEo));
                return;
            }
            object = String.valueOf(this.zzaAM.zzpp());
            this.zzt(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zzbby zzbby2) {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        if (this.zzaCA.isConnected()) {
            this.zzb(zzbby2);
            this.zzqu();
            return;
        }
        this.zzaEp.add(zzbby2);
        if (this.zzaEw != null && this.zzaEw.hasResolution()) {
            this.onConnectionFailed(this.zzaEw);
            return;
        }
        this.connect();
    }

    @WorkerThread
    public final void signOut() {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        this.zzt(zzben.zzaEe);
        this.zzaEr.zzpN();
        for (zzbfk<?> zzbfk2 : this.zzaEt.keySet()) {
            this.zza(new zzbcd(zzbfk2, (TaskCompletionSource<Void>)new TaskCompletionSource()));
        }
        this.zzi(new ConnectionResult(4));
        this.zzaCA.disconnect();
    }

    public final Api.zze zzpH() {
        return this.zzaCA;
    }

    public final Map<zzbfk<?>, zzbfr> zzqq() {
        return this.zzaEt;
    }

    @WorkerThread
    public final void zzqr() {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        this.zzaEw = null;
    }

    @WorkerThread
    public final ConnectionResult zzqs() {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        return this.zzaEw;
    }

    @WorkerThread
    private final void zzb(zzbby zzbby2) {
        zzbby2.zza(this.zzaEr, this.zzmt());
        try {
            zzbby2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzaCA.disconnect();
            return;
        }
    }

    @WorkerThread
    public final void zzt(Status status) {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        Iterator iterator = this.zzaEp.iterator();
        while (iterator.hasNext()) {
            ((zzbby)iterator.next()).zzp(status);
        }
        this.zzaEp.clear();
    }

    @WorkerThread
    public final void resume() {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        if (this.zzaDC) {
            this.connect();
        }
    }

    @WorkerThread
    private final void zzqt() {
        if (this.zzaDC) {
            zzben.zza(this.zzaEo).removeMessages(11, this.zzaAM);
            zzben.zza(this.zzaEo).removeMessages(9, this.zzaAM);
            this.zzaDC = false;
        }
    }

    @WorkerThread
    public final void zzqb() {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        if (this.zzaDC) {
            this.zzqt();
            Status status = zzben.zzg(this.zzaEo).isGooglePlayServicesAvailable(zzben.zzb(this.zzaEo)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zzt(status);
            this.zzaCA.disconnect();
        }
    }

    private final void zzqu() {
        zzben.zza(this.zzaEo).removeMessages(12, this.zzaAM);
        zzben.zza(this.zzaEo).sendMessageDelayed(zzben.zza(this.zzaEo).obtainMessage(12, this.zzaAM), zzben.zzh(this.zzaEo));
    }

    @WorkerThread
    public final void zzqv() {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        if (this.zzaCA.isConnected() && this.zzaEt.size() == 0) {
            if (this.zzaEr.zzpM()) {
                this.zzqu();
                return;
            }
            this.zzaCA.disconnect();
        }
    }

    @WorkerThread
    public final void connect() {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        if (this.zzaCA.isConnected() || this.zzaCA.isConnecting()) {
            return;
        }
        if (this.zzaCA.zzpc() && zzben.zzi(this.zzaEo) != 0) {
            zzben.zza(this.zzaEo, zzben.zzg(this.zzaEo).isGooglePlayServicesAvailable(zzben.zzb(this.zzaEo)));
            if (zzben.zzi(this.zzaEo) != 0) {
                ConnectionResult connectionResult = new ConnectionResult(zzben.zzi(this.zzaEo), null);
                this.onConnectionFailed(connectionResult);
                return;
            }
        }
        zzbet zzbet2 = new zzbet(this.zzaEo, this.zzaCA, this.zzaAM);
        if (this.zzaCA.zzmt()) {
            this.zzaEv.zza(zzbet2);
        }
        this.zzaCA.zza(zzbet2);
    }

    @WorkerThread
    public final void zza(zzbch zzbch2) {
        zzbr.zza((Handler)zzben.zza(this.zzaEo));
        this.zzaEs.add(zzbch2);
    }

    @WorkerThread
    private final void zzi(ConnectionResult connectionResult) {
        Iterator<zzbch> iterator = this.zzaEs.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(this.zzaAM, connectionResult);
        }
        this.zzaEs.clear();
    }

    final boolean isConnected() {
        return this.zzaCA.isConnected();
    }

    public final boolean zzmt() {
        return this.zzaCA.zzmt();
    }

    public final int getInstanceId() {
        return this.zzaEu;
    }

    final zzcuw zzqw() {
        if (this.zzaEv == null) {
            return null;
        }
        return this.zzaEv.zzqw();
    }

    static /* synthetic */ void zzc(zzbep zzbep2) {
        zzbep2.zzqo();
    }

    static /* synthetic */ void zzd(zzbep zzbep2) {
        zzbep2.zzqp();
    }
}

