/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcu;
import com.google.android.gms.internal.zzbda;
import com.google.android.gms.internal.zzbdd;
import com.google.android.gms.internal.zzbde;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzben;
import com.google.android.gms.internal.zzbfb;
import com.google.android.gms.internal.zzbfu;
import com.google.android.gms.internal.zzbih;
import com.google.android.gms.internal.zzcuw;
import com.google.android.gms.internal.zzcux;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbdb
implements zzbfb {
    private final Map<Api.zzc<?>, zzbda<?>> zzaCD = new HashMap();
    private final Map<Api.zzc<?>, zzbda<?>> zzaCE = new HashMap();
    private final Map<Api<?>, Boolean> zzaCF;
    private final zzben zzaAP;
    private final zzbeb zzaCG;
    private final Lock zzaCx;
    private final Looper zzrP;
    private final zze zzaCH;
    private final Condition zzaCI;
    private final zzq zzaCC;
    private final boolean zzaCJ;
    private final boolean zzaCK;
    private final Queue<zzbck<?, ?>> zzaCL = new LinkedList();
    private boolean zzaCM;
    private Map<zzbcf<?>, ConnectionResult> zzaCN;
    private Map<zzbcf<?>, ConnectionResult> zzaCO;
    private zzbde zzaCP;
    private ConnectionResult zzaCQ;

    public zzbdb(Context context, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcuw, zzcux> zza2, ArrayList<zzbcu> arrayList, zzbeb zzbeb2, boolean bl) {
        this.zzaCx = lock;
        this.zzrP = looper;
        this.zzaCI = lock.newCondition();
        this.zzaCH = zze2;
        this.zzaCG = zzbeb2;
        this.zzaCF = map2;
        this.zzaCC = zzq2;
        this.zzaCJ = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.zzpb(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzbcu> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzbcu zzbcu2 = arrayList2.get(i);
            zzbcu zzbcu3 = zzbcu2;
            hashMap2.put(zzbcu3.zzayY, zzbcu3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze3 = entry.getValue();
            if (zze3.zzpc()) {
                bl4 = true;
                if (!this.zzaCF.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzbcu zzbcu4 = (zzbcu)hashMap2.get(api);
            zzbda zzbda2 = new zzbda(context, api, looper, zze3, zzbcu4, zzq2, zza2);
            this.zzaCD.put(entry.getKey(), zzbda2);
            if (!zze3.zzmt()) continue;
            this.zzaCE.put(entry.getKey(), zzbda2);
        }
        this.zzaCK = bl4 && !bl3 && !bl2;
        this.zzaAP = zzben.zzqi();
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzbck<R, A>> T zzd(@NonNull T t) {
        if (this.zzaCJ && this.zzg(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzaCL.add(t);
            return t;
        }
        this.zzaCG.zzaDN.zzb(t);
        return this.zzaCD.get(t.zzpb()).zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzbck<? extends Result, A>> T zze(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzpb();
        if (this.zzaCJ && this.zzg(t)) {
            return t;
        }
        this.zzaCG.zzaDN.zzb(t);
        return this.zzaCD.get(zzc2).zzb(t);
    }

    private final <T extends zzbck<? extends Result, ? extends Api.zzb>> boolean zzg(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzpb();
        ConnectionResult connectionResult = this.zzb(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzr(new Status(4, null, this.zzaAP.zza(this.zzaCD.get(zzc2).zzpf(), System.identityHashCode(this.zzaCG))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zzaCx.lock();
        try {
            if (this.zzaCM) {
                return;
            }
            this.zzaCM = true;
            this.zzaCN = null;
            this.zzaCO = null;
            this.zzaCP = null;
            this.zzaCQ = null;
            this.zzaAP.zzpq();
            this.zzaAP.zza(this.zzaCD.values()).addOnCompleteListener((Executor)new zzbih(this.zzrP), (OnCompleteListener)new zzbdd(this, null));
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzaCI.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzazZ;
        }
        if (this.zzaCQ != null) {
            return this.zzaCQ;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzaCI.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzazZ;
        }
        if (this.zzaCQ != null) {
            return this.zzaCQ;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zzaCx.lock();
        try {
            this.zzaCM = false;
            this.zzaCN = null;
            this.zzaCO = null;
            if (this.zzaCP != null) {
                this.zzaCP.cancel();
                this.zzaCP = null;
            }
            this.zzaCQ = null;
            while (!this.zzaCL.isEmpty()) {
                zzbck<?, ?> zzbck2 = this.zzaCL.remove();
                zzbck2.zza(null);
                zzbck2.cancel();
            }
            this.zzaCI.signalAll();
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zzb(api.zzpb());
    }

    @Nullable
    private final ConnectionResult zzb(@NonNull Api.zzc<?> zzc2) {
        this.zzaCx.lock();
        try {
            zzbda<?> zzbda2 = this.zzaCD.get(zzc2);
            if (this.zzaCN != null && zzbda2 != null) {
                ConnectionResult connectionResult = this.zzaCN.get(zzbda2.zzpf());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zzaCx.lock();
        try {
            boolean bl = this.zzaCN != null && this.zzaCQ == null;
            return bl;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzaCx.lock();
        try {
            boolean bl = this.zzaCN == null && this.zzaCM;
            return bl;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    private final boolean zzpI() {
        this.zzaCx.lock();
        try {
            if (!this.zzaCM || !this.zzaCJ) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzaCE.keySet()) {
                ConnectionResult connectionResult = this.zzb(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final boolean zza(zzbfu zzbfu2) {
        this.zzaCx.lock();
        try {
            if (this.zzaCM && !this.zzpI()) {
                this.zzaAP.zzpq();
                this.zzaCP = new zzbde(this, zzbfu2);
                this.zzaAP.zza(this.zzaCE.values()).addOnCompleteListener((Executor)new zzbih(this.zzrP), (OnCompleteListener)this.zzaCP);
                return true;
            }
            return false;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final void zzpj() {
        this.zzaCx.lock();
        try {
            this.zzaAP.zzpj();
            if (this.zzaCP != null) {
                this.zzaCP.cancel();
                this.zzaCP = null;
            }
            if (this.zzaCO == null) {
                this.zzaCO = new ArrayMap(this.zzaCE.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzbda<?> zzbda2 : this.zzaCE.values()) {
                this.zzaCO.put(zzbda2.zzpf(), connectionResult);
            }
            if (this.zzaCN != null) {
                this.zzaCN.putAll(this.zzaCO);
            }
            return;
        }
        finally {
            this.zzaCx.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzpC() {
    }

    private final void zzpJ() {
        if (this.zzaCC == null) {
            this.zzaCG.zzaDI = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzaCC.zzrl());
        Map<Api<?>, zzr> map = this.zzaCC.zzrn();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zzamg);
        }
        this.zzaCG.zzaDI = hashSet;
    }

    private final void zzpK() {
        while (!this.zzaCL.isEmpty()) {
            this.zze(this.zzaCL.remove());
        }
        this.zzaCG.zzm(null);
    }

    private final boolean zza(zzbda<?> zzbda2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzaCF.get(zzbda2.zzpe()) != false && zzbda2.zzpH().zzpc() && this.zzaCH.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private final ConnectionResult zzpL() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzbda<?> zzbda2 : this.zzaCD.values()) {
            int n3;
            Api api = zzbda2.zzpe();
            zzbcf zzbcf2 = zzbda2.zzpf();
            ConnectionResult connectionResult3 = this.zzaCN.get(zzbcf2);
            if (connectionResult3.isSuccess() || this.zzaCF.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzaCH.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzaCJ) {
                n3 = api.zzoZ().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzoZ().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzbdb zzbdb2) {
        return zzbdb2.zzaCx;
    }

    static /* synthetic */ boolean zzb(zzbdb zzbdb2) {
        return zzbdb2.zzaCM;
    }

    static /* synthetic */ Map zza(zzbdb zzbdb2, Map map) {
        zzbdb2.zzaCN = map;
        return zzbdb2.zzaCN;
    }

    static /* synthetic */ Map zzc(zzbdb zzbdb2) {
        return zzbdb2.zzaCD;
    }

    static /* synthetic */ Map zzd(zzbdb zzbdb2) {
        return zzbdb2.zzaCN;
    }

    static /* synthetic */ boolean zze(zzbdb zzbdb2) {
        return zzbdb2.zzaCK;
    }

    static /* synthetic */ boolean zza(zzbdb zzbdb2, zzbda zzbda2, ConnectionResult connectionResult) {
        return zzbdb2.zza(zzbda2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzbdb zzbdb2, ConnectionResult connectionResult) {
        zzbdb2.zzaCQ = connectionResult;
        return zzbdb2.zzaCQ;
    }

    static /* synthetic */ ConnectionResult zzf(zzbdb zzbdb2) {
        return zzbdb2.zzpL();
    }

    static /* synthetic */ Map zzg(zzbdb zzbdb2) {
        return zzbdb2.zzaCO;
    }

    static /* synthetic */ ConnectionResult zzh(zzbdb zzbdb2) {
        return zzbdb2.zzaCQ;
    }

    static /* synthetic */ void zzi(zzbdb zzbdb2) {
        zzbdb2.zzpJ();
    }

    static /* synthetic */ void zzj(zzbdb zzbdb2) {
        zzbdb2.zzpK();
    }

    static /* synthetic */ boolean zza(zzbdb zzbdb2, boolean bl) {
        zzbdb2.zzaCM = false;
        return false;
    }

    static /* synthetic */ zzbeb zzk(zzbdb zzbdb2) {
        return zzbdb2.zzaCG;
    }

    static /* synthetic */ Condition zzl(zzbdb zzbdb2) {
        return zzbdb2.zzaCI;
    }

    static /* synthetic */ Map zzb(zzbdb zzbdb2, Map map) {
        zzbdb2.zzaCO = map;
        return zzbdb2.zzaCO;
    }

    static /* synthetic */ Map zzm(zzbdb zzbdb2) {
        return zzbdb2.zzaCE;
    }
}

