/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzap;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzbcr;
import com.google.android.gms.internal.zzbcs;
import com.google.android.gms.internal.zzbct;
import com.google.android.gms.internal.zzbge;
import com.google.android.gms.internal.zzbgj;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzbcq<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzaBX = new zzbcr();
    private final Object zzaBY = new Object();
    private zzbcs<R> zzaBZ;
    private WeakReference<GoogleApiClient> zzaCa;
    private final CountDownLatch zztM = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzaCb = new ArrayList();
    private ResultCallback<? super R> zzaCc;
    private final AtomicReference<zzbgj> zzaCd = new AtomicReference();
    private R zzaBl;
    private Status mStatus;
    private zzbct zzaCe;
    private volatile boolean zzaCf;
    private boolean zzJ;
    private boolean zzaCg;
    private zzap zzaCh;
    private volatile zzbge<R> zzaCi;
    private boolean zzaCj = false;

    @Deprecated
    zzbcq() {
        this.zzaBZ = new zzbcs(Looper.getMainLooper());
        this.zzaCa = new WeakReference<Object>(null);
    }

    protected zzbcq(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzaBZ = new zzbcs(looper);
        this.zzaCa = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzbcq(Looper looper) {
        this.zzaBZ = new zzbcs(looper);
        this.zzaCa = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zztM.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzbr.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzbr.zza((!this.zzaCf ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzbr.zza((this.zzaCi == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zztM.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzs(Status.zzaBp);
        }
        zzbr.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzbr.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzbr.zza((!this.zzaCf ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzbr.zza((this.zzaCi == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zztM.await(l, timeUnit)) {
                this.zzs(Status.zzaBr);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzs(Status.zzaBp);
        }
        zzbr.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzaBY;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzaCc = null;
                return;
            }
            zzbr.zza((!this.zzaCf ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbr.zza((this.zzaCi == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzaBZ.zza(resultCallback, (R)this.get());
            } else {
                this.zzaCc = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzaBY;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzaCc = null;
                return;
            }
            zzbr.zza((!this.zzaCf ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbr.zza((this.zzaCi == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzaBZ.zza(resultCallback, (R)this.get());
            } else {
                this.zzaCc = resultCallback;
                long l2 = timeUnit.toMillis(l);
                zzbcq zzbcq2 = this;
                zzbcs<R> zzbcs2 = this.zzaBZ;
                zzbcs2.sendMessageDelayed(zzbcs2.obtainMessage(2, zzbcq2), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzbr.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzaBY;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzo(this.mStatus);
            } else {
                this.zzaCb.add(zza2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzaBY;
        synchronized (object) {
            if (this.zzJ || this.zzaCf) {
                return;
            }
            if (this.zzaCh != null) {
                try {
                    this.zzaCh.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            zzbcq.zzc(this.zzaBl);
            this.zzJ = true;
            this.zzb(this.zzb(Status.zzaBs));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzpz() {
        Object object = this.zzaBY;
        synchronized (object) {
            if ((GoogleApiClient)this.zzaCa.get() == null || !this.zzaCj) {
                this.cancel();
            }
            return this.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzaBY;
        synchronized (object) {
            return this.zzJ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzbr.zza((!this.zzaCf ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzaBY;
        synchronized (object) {
            zzbr.zza((this.zzaCi == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbr.zza((this.zzaCc == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzbr.zza((!this.zzJ ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzaCj = true;
            this.zzaCi = new zzbge(this.zzaCa);
            TransformedResult<? extends S> transformedResult = this.zzaCi.then(resultTransform);
            if (this.isReady()) {
                this.zzaBZ.zza(this.zzaCi, this.get());
            } else {
                this.zzaCc = this.zzaCi;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R r) {
        Object object = this.zzaBY;
        synchronized (object) {
            if (!this.zzaCg && !this.zzJ) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                zzbcq.zzc(r);
                return;
            }
            zzbr.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzbr.zza((!this.zzaCf ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzb(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzs(Status status) {
        Object object = this.zzaBY;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.zzb(status));
                this.zzaCg = true;
            }
            return;
        }
    }

    @NonNull
    protected abstract R zzb(Status var1);

    public final void zza(zzbgj zzbgj2) {
        this.zzaCd.set(zzbgj2);
    }

    @Override
    public final Integer zzpm() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzap zzap2) {
        Object object = this.zzaBY;
        synchronized (object) {
            this.zzaCh = zzap2;
            return;
        }
    }

    public final void zzpA() {
        this.zzaCj = this.zzaCj || zzaBX.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zzaBY;
        synchronized (object) {
            zzbr.zza((!this.zzaCf ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbr.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzaBl;
            this.zzaBl = null;
            this.zzaCc = null;
            this.zzaCf = true;
        }
        zzbcq zzbcq2 = this;
        zzbgj zzbgj2 = zzbcq2.zzaCd.getAndSet(null);
        if (zzbgj2 != null) {
            zzbgj2.zzc(zzbcq2);
        }
        return r;
    }

    private final void zzb(R r) {
        this.zzaBl = r;
        this.zzaCh = null;
        this.zztM.countDown();
        this.mStatus = this.zzaBl.getStatus();
        if (this.zzJ) {
            this.zzaCc = null;
        } else if (this.zzaCc == null) {
            if (this.zzaBl instanceof Releasable) {
                this.zzaCe = new zzbct(this, null);
            }
        } else {
            this.zzaBZ.removeMessages(2);
            this.zzaBZ.zza(this.zzaCc, (R)this.get());
        }
        ArrayList<PendingResult.zza> arrayList = this.zzaCb;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.zza zza2 = arrayList.get(i);
            zza2.zzo(this.mStatus);
        }
        this.zzaCb.clear();
    }

    public static void zzc(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ Result zza(zzbcq zzbcq2) {
        return zzbcq2.zzaBl;
    }
}

