/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.internal.zzbco;
import com.google.android.gms.internal.zzbfe;
import com.google.android.gms.internal.zzbff;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzbcm
extends zzbfe
implements DialogInterface.OnCancelListener {
    protected volatile boolean mStarted;
    protected final AtomicReference<zzbcn> zzaBP = new AtomicReference<Object>(null);
    private final Handler zzaBQ = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability zzaBf;

    protected zzbcm(zzbff zzbff2) {
        this(zzbff2, GoogleApiAvailability.getInstance());
    }

    private zzbcm(zzbff zzbff2, GoogleApiAvailability googleApiAvailability) {
        super(zzbff2);
        this.zzaBf = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), zzbcm.zza(this.zzaBP.get()));
        this.zzpv();
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            zzbcn zzbcn2;
            Bundle bundle2 = bundle;
            if (bundle2.getBoolean("resolving_error", false)) {
                ConnectionResult connectionResult = new ConnectionResult(bundle2.getInt("failed_status"), (PendingIntent)bundle2.getParcelable("failed_resolution"));
                int n = bundle2.getInt("failed_client_id", -1);
                zzbcn2 = new zzbcn(connectionResult, n);
            } else {
                zzbcn2 = null;
            }
            this.zzaBP.set(zzbcn2);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Bundle bundle2 = bundle;
        zzbcn zzbcn2 = this.zzaBP.get();
        if (zzbcn2 != null) {
            bundle2.putBoolean("resolving_error", true);
            bundle2.putInt("failed_client_id", zzbcn2.zzpw());
            bundle2.putInt("failed_status", zzbcn2.zzpx().getErrorCode());
            bundle2.putParcelable("failed_resolution", (Parcelable)zzbcn2.zzpx().getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        zzbcn zzbcn2 = this.zzaBP.get();
        switch (n) {
            case 2: {
                int n3 = this.zzaBf.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (zzbcn2 == null) {
                    return;
                }
                if (zzbcn2.zzpx().getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                zzbcn2 = new zzbcn(new ConnectionResult(n4, null), zzbcm.zza(zzbcn2));
                this.zzaBP.set(zzbcn2);
            }
        }
        if (bl) {
            this.zzpv();
            return;
        }
        if (zzbcn2 != null) {
            this.zza(zzbcn2.zzpx(), zzbcn2.zzpw());
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzpq();

    protected final void zzpv() {
        this.zzaBP.set(null);
        this.zzpq();
    }

    public final void zzb(ConnectionResult connectionResult, int n) {
        zzbcn zzbcn2 = new zzbcn(connectionResult, n);
        if (this.zzaBP.compareAndSet(null, zzbcn2)) {
            this.zzaBQ.post((Runnable)new zzbco(this, zzbcn2));
        }
    }

    private static int zza(@Nullable zzbcn zzbcn2) {
        if (zzbcn2 == null) {
            return -1;
        }
        return zzbcn2.zzpw();
    }
}

