/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzbcg;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcu;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzbfd;
import com.google.android.gms.internal.zzbfi;
import com.google.android.gms.internal.zzbfu;
import com.google.android.gms.internal.zzbge;
import com.google.android.gms.internal.zzcus;
import com.google.android.gms.internal.zzcuw;
import com.google.android.gms.internal.zzcux;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> zzaAU = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Set<GoogleApiClient> set = zzaAU;
        synchronized (set) {
            int n = 0;
            String string3 = String.valueOf(string2).concat("  ");
            for (GoogleApiClient googleApiClient : zzaAU) {
                printWriter.append(string2).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string3, fileDescriptor, printWriter, stringArray);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<GoogleApiClient> zzpi() {
        Set<GoogleApiClient> set = zzaAU;
        synchronized (set) {
            return zzaAU;
        }
    }

    public <A extends Api.zzb, R extends Result, T extends zzbck<R, A>> T zzd(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zzbck<? extends Result, A>> T zze(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzbfi<L> zzp(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public boolean zza(zzbfu zzbfu2) {
        throw new UnsupportedOperationException();
    }

    public void zzpj() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int n) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public void zza(zzbge zzbge2) {
        throw new UnsupportedOperationException();
    }

    public void zzb(zzbge zzbge2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account zzajd;
        private final Set<Scope> zzaAV = new HashSet<Scope>();
        private final Set<Scope> zzaAW = new HashSet<Scope>();
        private int zzaAX;
        private View zzaAY;
        private String zzakg;
        private String zzaAZ;
        private final Map<Api<?>, zzr> zzaBa = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzaBb = new ArrayMap();
        private zzbfd zzaBc;
        private int zzaBd = -1;
        private OnConnectionFailedListener zzaBe;
        private Looper zzrP;
        private GoogleApiAvailability zzaBf = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzcuw, zzcux> zzaBg = zzcus.zzajU;
        private final ArrayList<ConnectionCallbacks> zzaBh = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzaBi = new ArrayList();
        private boolean zzaBj = false;

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.zzrP = context.getMainLooper();
            this.zzakg = context.getPackageName();
            this.zzaAZ = context.getClass().getName();
        }

        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectionCallbacks, @NonNull OnConnectionFailedListener onConnectionFailedListener) {
            this(context);
            zzbr.zzb((Object)connectionCallbacks, (Object)"Must provide a connected listener");
            this.zzaBh.add(connectionCallbacks);
            zzbr.zzb((Object)onConnectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzaBi.add(onConnectionFailedListener);
        }

        public final Builder setHandler(@NonNull Handler handler) {
            zzbr.zzb((Object)handler, (Object)"Handler must not be null");
            this.zzrP = handler.getLooper();
            return this;
        }

        public final Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            zzbr.zzb((Object)connectionCallbacks, (Object)"Listener must not be null");
            this.zzaBh.add(connectionCallbacks);
            return this;
        }

        public final Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            zzbr.zzb((Object)onConnectionFailedListener, (Object)"Listener must not be null");
            this.zzaBi.add(onConnectionFailedListener);
            return this;
        }

        public final Builder setViewForPopups(@NonNull View view) {
            zzbr.zzb((Object)view, (Object)"View must not be null");
            this.zzaAY = view;
            return this;
        }

        public final Builder addScope(@NonNull Scope scope) {
            zzbr.zzb((Object)scope, (Object)"Scope must not be null");
            this.zzaAV.add(scope);
            return this;
        }

        public final Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzbr.zzb(api, (Object)"Api must not be null");
            this.zzaBb.put(api, null);
            List<Scope> list = api.zzoZ().zzn(null);
            this.zzaAW.addAll(list);
            this.zzaAV.addAll(list);
            return this;
        }

        public final Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopeArray) {
            zzbr.zzb(api, (Object)"Api must not be null");
            this.zzaBb.put(api, null);
            this.zza(api, null, scopeArray);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o) {
            zzbr.zzb(api, (Object)"Api must not be null");
            zzbr.zzb(o, (Object)"Null options are not permitted for this Api");
            this.zzaBb.put(api, o);
            List<Scope> list = api.zzoZ().zzn(o);
            this.zzaAW.addAll(list);
            this.zzaAV.addAll(list);
            return this;
        }

        public final <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O o, Scope ... scopeArray) {
            zzbr.zzb(api, (Object)"Api must not be null");
            zzbr.zzb(o, (Object)"Null options are not permitted for this Api");
            this.zzaBb.put(api, o);
            this.zza(api, o, scopeArray);
            return this;
        }

        public final Builder setAccountName(String string2) {
            this.zzajd = string2 == null ? null : new Account(string2, "com.google");
            return this;
        }

        public final Builder zze(Account account) {
            this.zzajd = account;
            return this;
        }

        public final Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public final Builder setGravityForPopups(int n) {
            this.zzaAX = n;
            return this;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int n, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
            zzbfd zzbfd2 = new zzbfd((Activity)fragmentActivity);
            Builder builder = this;
            zzbr.zzb((n >= 0 ? 1 : 0) != 0, (Object)"clientId must be non-negative");
            builder.zzaBd = n;
            builder.zzaBe = onConnectionFailedListener2;
            builder.zzaBc = zzbfd2;
            return builder;
        }

        public final Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener onConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, onConnectionFailedListener);
        }

        public final zzq zzpl() {
            zzcux zzcux2 = zzcux.zzbCQ;
            if (this.zzaBb.containsKey(zzcus.API)) {
                zzcux2 = (zzcux)this.zzaBb.get(zzcus.API);
            }
            return new zzq(this.zzajd, this.zzaAV, this.zzaBa, this.zzaAX, this.zzaAY, this.zzakg, this.zzaAZ, zzcux2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final GoogleApiClient build() {
            zzbr.zzb((!this.zzaBb.isEmpty() ? 1 : 0) != 0, (Object)"must call addApi() to add at least one API");
            Builder builder = this;
            Object object = builder.zzpl();
            Api<?> api = null;
            boolean bl = false;
            Map<Api<?>, zzr> map = ((zzq)object).zzrn();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<zzbcu> arrayList = new ArrayList<zzbcu>();
            for (Api<?> api2 : builder.zzaBb.keySet()) {
                Api.ApiOptions apiOptions = builder.zzaBb.get(api2);
                boolean bl2 = map.get(api2) != null;
                arrayMap.put(api2, bl2);
                zzbcu zzbcu2 = new zzbcu(api2, bl2);
                arrayList.add(zzbcu2);
                Object object2 = api2.zzpa();
                Api.zza<?, ?> zza2 = object2;
                zzbcu zzbcu3 = zzbcu2;
                zzbcu zzbcu4 = zzbcu2;
                zzq zzq2 = object;
                Looper looper = builder.zzrP;
                Context context = builder.mContext;
                Api.ApiOptions apiOptions2 = apiOptions;
                Object obj = ((Api.zza)object2).zza(context, looper, zzq2, apiOptions2, zzbcu4, zzbcu3);
                arrayMap2.put(api2.zzpb(), obj);
                if (zza2.getPriority() == 1) {
                    boolean bl3 = bl = apiOptions != null;
                }
                if (!obj.zzmE()) continue;
                if (api != null) {
                    object2 = String.valueOf(api2.getName());
                    String string2 = String.valueOf(api.getName());
                    throw new IllegalStateException(new StringBuilder(21 + String.valueOf(object2).length() + String.valueOf(string2).length()).append((String)object2).append(" cannot be used with ").append(string2).toString());
                }
                api = api2;
            }
            if (api != null) {
                if (bl) {
                    String string3 = String.valueOf(api.getName());
                    throw new IllegalStateException(new StringBuilder(82 + String.valueOf(string3).length()).append("With using ").append(string3).append(", GamesOptions can only be specified within GoogleSignInOptions.Builder").toString());
                }
                zzbr.zza((builder.zzajd == null ? 1 : 0) != 0, (String)"Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", (Object[])new Object[]{api.getName()});
                zzbr.zza((boolean)builder.zzaAV.equals(builder.zzaAW), (String)"Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", (Object[])new Object[]{api.getName()});
            }
            int n = zzbeb.zza(arrayMap2.values(), true);
            zzbeb zzbeb2 = new zzbeb(builder.mContext, new ReentrantLock(), builder.zzrP, (zzq)object, builder.zzaBf, builder.zzaBg, (Map<Api<?>, Boolean>)arrayMap, (List<ConnectionCallbacks>)builder.zzaBh, (List<OnConnectionFailedListener>)builder.zzaBi, (Map<Api.zzc<?>, Api.zze>)arrayMap2, builder.zzaBd, n, arrayList, false);
            Set set = zzaAU;
            synchronized (set) {
                zzaAU.add(zzbeb2);
            }
            if (this.zzaBd >= 0) {
                object = zzbeb2;
                builder = this;
                zzbcg.zza(builder.zzaBc).zza(builder.zzaBd, (GoogleApiClient)object, builder.zzaBe);
            }
            return zzbeb2;
        }

        private final <O extends Api.ApiOptions> void zza(Api<O> api, O o, Scope ... scopeArray) {
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzoZ().zzn(o));
            Scope[] scopeArray2 = scopeArray;
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                Scope scope = scopeArray2[i];
                hashSet.add(scope);
            }
            this.zzaBa.put(api, new zzr(hashSet));
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

