/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.BinderThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzaau;
import com.google.android.gms.internal.zzaav;
import com.google.android.gms.internal.zzaaw;
import com.google.android.gms.internal.zzbai;
import com.google.android.gms.internal.zzbaj;
import com.google.android.gms.internal.zzbam;
import com.google.android.gms.internal.zzbaw;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzaar
implements zzaau {
    private final zzaav zzaBk;
    private final Lock zzaAG;
    private final Context mContext;
    private final com.google.android.gms.common.zze zzaAQ;
    private ConnectionResult zzaAZ;
    private int zzaBn;
    private int zzaBo = 0;
    private int zzaBp;
    private final Bundle zzaBq = new Bundle();
    private final Set<Api.zzc> zzaBr = new HashSet<Api.zzc>();
    private zzbai zzaBs;
    private boolean zzaBt;
    private boolean zzaBu;
    private boolean zzaBv;
    private zzr zzaBw;
    private boolean zzaBx;
    private boolean zzaBy;
    private final zzg zzaAL;
    private final Map<Api<?>, Boolean> zzaAO;
    private final Api.zza<? extends zzbai, zzbaj> zzazo;
    private ArrayList<Future<?>> zzaBz = new ArrayList();

    public zzaar(zzaav zzaav2, zzg zzg2, Map<Api<?>, Boolean> map, com.google.android.gms.common.zze zze2, Api.zza<? extends zzbai, zzbaj> zza2, Lock lock, Context context) {
        this.zzaBk = zzaav2;
        this.zzaAL = zzg2;
        this.zzaAO = map;
        this.zzaAQ = zze2;
        this.zzazo = zza2;
        this.zzaAG = lock;
        this.mContext = context;
    }

    @Override
    public void begin() {
        this.zzaBk.zzaCf.clear();
        this.zzaBu = false;
        this.zzaAZ = null;
        this.zzaBo = 0;
        this.zzaBt = true;
        this.zzaBv = false;
        this.zzaBx = false;
        boolean bl = false;
        HashMap<Api.zze, zza> hashMap = new HashMap<Api.zze, zza>();
        for (Api<?> api : this.zzaAO.keySet()) {
            Api.zze zze2 = this.zzaBk.zzaBQ.get(api.zzvg());
            bl |= api.zzve().getPriority() == 1;
            boolean bl2 = this.zzaAO.get(api);
            if (zze2.zzrd()) {
                this.zzaBu = true;
                if (bl2) {
                    this.zzaBr.add(api.zzvg());
                } else {
                    this.zzaBt = false;
                }
            }
            hashMap.put(zze2, new zza(this, api, bl2));
        }
        if (bl) {
            this.zzaBu = false;
        }
        if (this.zzaBu) {
            this.zzaAL.zzc(this.zzaBk.zzaAw.getSessionId());
            zze zze3 = new zze();
            this.zzaBs = this.zzazo.zza(this.mContext, this.zzaBk.zzaAw.getLooper(), this.zzaAL, this.zzaAL.zzxR(), zze3, zze3);
        }
        this.zzaBp = this.zzaBk.zzaBQ.size();
        this.zzaBz.add(zzaaw.zzwv().submit(new zzb(hashMap)));
    }

    private boolean zzwf() {
        --this.zzaBp;
        if (this.zzaBp > 0) {
            return false;
        }
        if (this.zzaBp < 0) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zzaBk.zzaAw.zzwr());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        if (this.zzaAZ != null) {
            this.zzaBk.zzaCi = this.zzaBn;
            this.zzf(this.zzaAZ);
            return false;
        }
        return true;
    }

    private void zza(zzbaw zzbaw2) {
        if (!this.zzcB(0)) {
            return;
        }
        ConnectionResult connectionResult = zzbaw2.zzyh();
        if (connectionResult.isSuccess()) {
            zzaf zzaf2 = zzbaw2.zzPW();
            ConnectionResult connectionResult2 = zzaf2.zzyh();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zzf(connectionResult2);
                return;
            }
            this.zzaBv = true;
            this.zzaBw = zzaf2.zzyg();
            this.zzaBx = zzaf2.zzyi();
            this.zzaBy = zzaf2.zzyj();
            this.zzwg();
        } else if (this.zze(connectionResult)) {
            this.zzwj();
            this.zzwg();
        } else {
            this.zzf(connectionResult);
        }
    }

    private void zzwg() {
        if (this.zzaBp != 0) {
            return;
        }
        if (!this.zzaBu || this.zzaBv) {
            this.zzwh();
        }
    }

    private void zzwh() {
        ArrayList<Api.zze> arrayList = new ArrayList<Api.zze>();
        this.zzaBo = 1;
        this.zzaBp = this.zzaBk.zzaBQ.size();
        for (Api.zzc<?> zzc2 : this.zzaBk.zzaBQ.keySet()) {
            if (this.zzaBk.zzaCf.containsKey(zzc2)) {
                if (!this.zzwf()) continue;
                this.zzwi();
                continue;
            }
            arrayList.add(this.zzaBk.zzaBQ.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zzaBz.add(zzaaw.zzwv().submit(new zzc(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle bundle) {
        if (!this.zzcB(1)) {
            return;
        }
        if (bundle != null) {
            this.zzaBq.putAll(bundle);
        }
        if (this.zzwf()) {
            this.zzwi();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (!this.zzcB(1)) {
            return;
        }
        this.zzb(connectionResult, api, bl);
        if (this.zzwf()) {
            this.zzwi();
        }
    }

    private void zzwi() {
        this.zzaBk.zzwt();
        zzaaw.zzwv().execute(new Runnable(){

            @Override
            public void run() {
                zzaar.this.zzaAQ.zzaF(zzaar.this.mContext);
            }
        });
        if (this.zzaBs != null) {
            if (this.zzaBx) {
                this.zzaBs.zza(this.zzaBw, this.zzaBy);
            }
            this.zzat(false);
        }
        for (Api.zzc<?> zzc2 : this.zzaBk.zzaCf.keySet()) {
            Api.zze zze2 = this.zzaBk.zzaBQ.get(zzc2);
            zze2.disconnect();
        }
        Bundle bundle = this.zzaBq.isEmpty() ? null : this.zzaBq;
        this.zzaBk.zzaCj.zzo(bundle);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzaad.zza<R, A>> T zza(T t) {
        this.zzaBk.zzaAw.zzaAU.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zzaad.zza<? extends Result, A>> T zzb(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
    }

    @Override
    public boolean disconnect() {
        this.zzwk();
        this.zzat(true);
        this.zzaBk.zzh(null);
        return true;
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.zzf(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        int n = api.zzve().getPriority();
        if (this.zza(n, bl, connectionResult)) {
            this.zzaAZ = connectionResult;
            this.zzaBn = n;
        }
        this.zzaBk.zzaCf.put(api.zzvg(), connectionResult);
    }

    private boolean zza(int n, boolean bl, ConnectionResult connectionResult) {
        if (bl && !this.zzd(connectionResult)) {
            return false;
        }
        return this.zzaAZ == null || n < this.zzaBn;
    }

    private boolean zzd(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.zzaAQ.zzcw(connectionResult.getErrorCode()) != null;
    }

    private void zzwj() {
        this.zzaBu = false;
        this.zzaBk.zzaAw.zzaBR = Collections.emptySet();
        for (Api.zzc zzc2 : this.zzaBr) {
            if (this.zzaBk.zzaCf.containsKey(zzc2)) continue;
            this.zzaBk.zzaCf.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zze(ConnectionResult connectionResult) {
        return this.zzaBt && !connectionResult.hasResolution();
    }

    private void zzf(ConnectionResult connectionResult) {
        this.zzwk();
        this.zzat(!connectionResult.hasResolution());
        this.zzaBk.zzh(connectionResult);
        this.zzaBk.zzaCj.zzc(connectionResult);
    }

    private void zzat(boolean bl) {
        if (this.zzaBs != null) {
            if (this.zzaBs.isConnected() && bl) {
                this.zzaBs.zzPL();
            }
            this.zzaBs.disconnect();
            this.zzaBw = null;
        }
    }

    private void zzwk() {
        for (Future<?> future : this.zzaBz) {
            future.cancel(true);
        }
        this.zzaBz.clear();
    }

    private Set<Scope> zzwl() {
        if (this.zzaAL == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzaAL.zzxL());
        Map<Api<?>, zzg.zza> map = this.zzaAL.zzxN();
        for (Api<?> api : map.keySet()) {
            if (this.zzaBk.zzaCf.containsKey(api.zzvg())) continue;
            hashSet.addAll(map.get(api).zzakq);
        }
        return hashSet;
    }

    private boolean zzcB(int n) {
        if (this.zzaBo != n) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zzaBk.zzaAw.zzwr());
            String string2 = String.valueOf(this);
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.zzaBp;
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = String.valueOf(this.zzcC(this.zzaBo));
            String string4 = String.valueOf(this.zzcC(n));
            Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzcC(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zzd
    extends zzbam {
        private final WeakReference<zzaar> zzaBB;

        zzd(zzaar zzaar2) {
            this.zzaBB = new WeakReference<zzaar>(zzaar2);
        }

        @Override
        @BinderThread
        public void zzb(final zzbaw zzbaw2) {
            final zzaar zzaar2 = (zzaar)this.zzaBB.get();
            if (zzaar2 == null) {
                return;
            }
            zzaar2.zzaBk.zza(new zzaav.zza(this, zzaar2){

                @Override
                public void zzwe() {
                    zzaar2.zza(zzbaw2);
                }
            });
        }
    }

    private static class zza
    implements zzf.zzf {
        private final WeakReference<zzaar> zzaBB;
        private final Api<?> zzaxf;
        private final boolean zzaAu;

        public zza(zzaar zzaar2, Api<?> api, boolean bl) {
            this.zzaBB = new WeakReference<zzaar>(zzaar2);
            this.zzaxf = api;
            this.zzaAu = bl;
        }

        public void zzg(@NonNull ConnectionResult connectionResult) {
            zzaar zzaar2 = (zzaar)this.zzaBB.get();
            if (zzaar2 == null) {
                return;
            }
            zzac.zza((Looper.myLooper() == ((zzaar)zzaar2).zzaBk.zzaAw.getLooper() ? 1 : 0) != 0, (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzaar2.zzaAG.lock();
            try {
                if (!zzaar2.zzcB(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzaar2.zzb(connectionResult, this.zzaxf, this.zzaAu);
                }
                if (zzaar2.zzwf()) {
                    zzaar2.zzwg();
                }
            }
            finally {
                zzaar2.zzaAG.unlock();
            }
        }
    }

    private class zze
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zze() {
        }

        @Override
        public void onConnected(Bundle bundle) {
            zzaar.this.zzaBs.zza(new zzd(zzaar.this));
        }

        @Override
        public void onConnectionSuspended(int n) {
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzaar.this.zzaAG.lock();
            try {
                if (zzaar.this.zze(connectionResult)) {
                    zzaar.this.zzwj();
                    zzaar.this.zzwg();
                } else {
                    zzaar.this.zzf(connectionResult);
                }
            }
            finally {
                zzaar.this.zzaAG.unlock();
            }
        }
    }

    private class zzc
    extends zzf {
        private final ArrayList<Api.zze> zzaBG;

        public zzc(ArrayList<Api.zze> arrayList) {
            this.zzaBG = arrayList;
        }

        @Override
        @WorkerThread
        public void zzwe() {
            ((zzaar)zzaar.this).zzaBk.zzaAw.zzaBR = zzaar.this.zzwl();
            for (Api.zze zze2 : this.zzaBG) {
                zze2.zza(zzaar.this.zzaBw, ((zzaar)zzaar.this).zzaBk.zzaAw.zzaBR);
            }
        }
    }

    private class zzb
    extends zzf {
        private final Map<Api.zze, zza> zzaBC;

        public zzb(Map<Api.zze, zza> map) {
            this.zzaBC = map;
        }

        @Override
        @WorkerThread
        public void zzwe() {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            for (Api.zze object : this.zzaBC.keySet()) {
                if (object.zzvh()) {
                    bl2 = true;
                    if (this.zzaBC.get(object).zzaAu) continue;
                    bl = true;
                    break;
                }
                bl3 = false;
            }
            int n2 = n = bl2 ? zzaar.this.zzaAQ.isGooglePlayServicesAvailable(zzaar.this.mContext) : 0;
            if (n != 0 && (bl || bl3)) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzaar.this.zzaBk.zza(new zzaav.zza(zzaar.this){

                    @Override
                    public void zzwe() {
                        zzaar.this.zzf(connectionResult);
                    }
                });
                return;
            }
            if (zzaar.this.zzaBu) {
                zzaar.this.zzaBs.connect();
            }
            for (Api.zze zze2 : this.zzaBC.keySet()) {
                final zzf.zzf zzf2 = this.zzaBC.get(zze2);
                if (zze2.zzvh() && n != 0) {
                    zzaar.this.zzaBk.zza(new zzaav.zza(this, zzaar.this){

                        @Override
                        public void zzwe() {
                            zzf2.zzg(new ConnectionResult(16, null));
                        }
                    });
                    continue;
                }
                zze2.zza(zzf2);
            }
        }
    }

    private abstract class zzf
    implements Runnable {
        private zzf() {
        }

        @Override
        @WorkerThread
        public void run() {
            zzaar.this.zzaAG.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zzwe();
            }
            catch (RuntimeException runtimeException) {
                zzaar.this.zzaBk.zza(runtimeException);
            }
            finally {
                zzaar.this.zzaAG.unlock();
            }
        }

        @WorkerThread
        protected abstract void zzwe();
    }
}

