/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.internal.zzabx;
import com.google.android.gms.internal.zzaby;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzaaf<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzaAg = new ThreadLocal<Boolean>(){

        protected Boolean zzvJ() {
            return false;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.zzvJ();
        }
    };
    private final Object zzaAh = new Object();
    protected final zza<R> zzaAi;
    protected final WeakReference<GoogleApiClient> zzaAj;
    private final CountDownLatch zztj = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzaAk = new ArrayList();
    private ResultCallback<? super R> zzaAl;
    private final AtomicReference<zzaby.zzb> zzaAm = new AtomicReference();
    private R zzazt;
    private Status zzair;
    private zzb zzaAn;
    private volatile boolean zzaAo;
    private boolean zzK;
    private boolean zzaAp;
    private zzs zzaAq;
    private volatile zzabx<R> zzaAr;
    private boolean zzaAs = false;

    @Deprecated
    zzaaf() {
        this.zzaAi = new zza(Looper.getMainLooper());
        this.zzaAj = new WeakReference<Object>(null);
    }

    protected zzaaf(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzaAi = new zza(looper);
        this.zzaAj = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzaaf(Looper looper) {
        this.zzaAi = new zza(looper);
        this.zzaAj = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zztj.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzac.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzac.zza((!this.zzaAo ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzac.zza((this.zzaAr == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zztj.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzC(Status.zzazy);
        }
        zzac.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzac.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzac.zza((!this.zzaAo ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzac.zza((this.zzaAr == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl = this.zztj.await(l, timeUnit);
            if (!bl) {
                this.zzC(Status.zzazA);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzC(Status.zzazy);
        }
        zzac.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzaAh;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzaAl = null;
                return;
            }
            zzac.zza((!this.zzaAo ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzac.zza((this.zzaAr == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzaAi.zza(resultCallback, (R)this.get());
            } else {
                this.zzaAl = resultCallback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzaAh;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzaAl = null;
                return;
            }
            zzac.zza((!this.zzaAo ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzac.zza((this.zzaAr == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzaAi.zza(resultCallback, (R)this.get());
            } else {
                this.zzaAl = resultCallback;
                this.zzaAi.zza(this, timeUnit.toMillis(l));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzac.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzaAh;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzy(this.zzair);
            } else {
                this.zzaAk.add(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzaAh;
        synchronized (object) {
            if (this.zzK || this.zzaAo) {
                return;
            }
            if (this.zzaAq != null) {
                try {
                    this.zzaAq.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            zzaaf.zzd(this.zzazt);
            this.zzK = true;
            this.zzc(this.zzc(Status.zzazB));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzvF() {
        Object object = this.zzaAh;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.zzaAj.get();
            if (googleApiClient == null || !this.zzaAs) {
                this.cancel();
            }
            return this.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzaAh;
        synchronized (object) {
            return this.zzK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzac.zza((!this.zzaAo ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzaAh;
        synchronized (object) {
            zzac.zza((this.zzaAr == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzac.zza((this.zzaAl == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzac.zza((!this.zzK ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzaAs = true;
            this.zzaAr = new zzabx(this.zzaAj);
            TransformedResult<? extends S> transformedResult = this.zzaAr.then(resultTransform);
            if (this.isReady()) {
                this.zzaAi.zza(this.zzaAr, this.get());
            } else {
                this.zzaAl = this.zzaAr;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(R r) {
        Object object = this.zzaAh;
        synchronized (object) {
            if (!this.zzaAp && !this.zzK) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                zzaaf.zzd(r);
                return;
            }
            zzac.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzac.zza((!this.zzaAo ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzC(Status status) {
        Object object = this.zzaAh;
        synchronized (object) {
            if (!this.isReady()) {
                this.zzb(this.zzc(status));
                this.zzaAp = true;
            }
        }
    }

    @NonNull
    protected abstract R zzc(Status var1);

    private void zzvG() {
        zzaby.zzb zzb2 = this.zzaAm.getAndSet(null);
        if (zzb2 != null) {
            zzb2.zzc(this);
        }
    }

    public void zza(zzaby.zzb zzb2) {
        this.zzaAm.set(zzb2);
    }

    public void zzvH() {
        this.setResultCallback(null);
    }

    @Override
    public Integer zzvr() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzs zzs2) {
        Object object = this.zzaAh;
        synchronized (object) {
            this.zzaAq = zzs2;
        }
    }

    public void zzvI() {
        this.zzaAs = this.zzaAs || zzaAg.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.zzaAh;
        synchronized (object) {
            zzac.zza((!this.zzaAo ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzac.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzazt;
            this.zzazt = null;
            this.zzaAl = null;
            this.zzaAo = true;
        }
        this.zzvG();
        return r;
    }

    private void zzc(R r) {
        this.zzazt = r;
        this.zzaAq = null;
        this.zztj.countDown();
        this.zzair = this.zzazt.getStatus();
        if (this.zzK) {
            this.zzaAl = null;
        } else if (this.zzaAl == null) {
            if (this.zzazt instanceof Releasable) {
                this.zzaAn = new zzb();
            }
        } else {
            this.zzaAi.zzvK();
            this.zzaAi.zza(this.zzaAl, (R)this.get());
        }
        for (PendingResult.zza zza2 : this.zzaAk) {
            zza2.zzy(this.zzair);
        }
        this.zzaAk.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zzb {
        private zzb() {
        }

        protected void finalize() throws Throwable {
            zzaaf.zzd(zzaaf.this.zzazt);
            super.finalize();
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zzaaf<R> zzaaf2, long l) {
            this.sendMessageDelayed(this.obtainMessage(2, zzaaf2), l);
        }

        public void zzvK() {
            this.removeMessages(2);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zzaaf zzaaf2 = (zzaaf)message.obj;
                    zzaaf2.zzC(Status.zzazA);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        protected void zzb(ResultCallback<? super R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zzaaf.zzd(r);
                throw runtimeException;
            }
        }
    }
}

