/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.support.v4.util.LruCache;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.images.zza;
import com.google.android.gms.internal.zzacd;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object zzaEf = new Object();
    private static HashSet<Uri> zzaEg = new HashSet();
    private static ImageManager zzaEh;
    private static ImageManager zzaEi;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService zzaEj;
    private final zza zzaEk;
    private final zzacd zzaEl;
    private final Map<com.google.android.gms.common.images.zza, ImageReceiver> zzaEm;
    private final Map<Uri, ImageReceiver> zzaEn;
    private final Map<Uri, Long> zzaEo;

    public static ImageManager create(Context context) {
        return ImageManager.zzg(context, false);
    }

    public static ImageManager zzg(Context context, boolean bl) {
        if (bl) {
            if (zzaEi == null) {
                zzaEi = new ImageManager(context, true);
            }
            return zzaEi;
        }
        if (zzaEh == null) {
            zzaEh = new ImageManager(context, false);
        }
        return zzaEh;
    }

    private ImageManager(Context context, boolean bl) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzaEj = Executors.newFixedThreadPool(4);
        if (bl) {
            this.zzaEk = new zza(this.mContext);
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new zzd(this.zzaEk));
        } else {
            this.zzaEk = null;
        }
        this.zzaEl = new zzacd();
        this.zzaEm = new HashMap<com.google.android.gms.common.images.zza, ImageReceiver>();
        this.zzaEn = new HashMap<Uri, ImageReceiver>();
        this.zzaEo = new HashMap<Uri, Long>();
    }

    public void loadImage(ImageView imageView, Uri uri) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, int n) {
        zza.zzb zzb2 = new zza.zzb(imageView, n);
        this.zza(zzb2);
    }

    public void loadImage(ImageView imageView, Uri uri, int n) {
        zza.zzb zzb2 = new zza.zzb(imageView, uri);
        zzb2.zzcO(n);
        this.zza(zzb2);
    }

    public void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri) {
        zza.zzc zzc2 = new zza.zzc(onImageLoadedListener, uri);
        this.zza(zzc2);
    }

    public void loadImage(OnImageLoadedListener onImageLoadedListener, Uri uri, int n) {
        zza.zzc zzc2 = new zza.zzc(onImageLoadedListener, uri);
        zzc2.zzcO(n);
        this.zza(zzc2);
    }

    public void zza(com.google.android.gms.common.images.zza zza2) {
        com.google.android.gms.common.internal.zzc.zzdj((String)"ImageManager.loadImage() must be called in the main thread");
        zzc zzc2 = new zzc(zza2);
        zzc2.run();
    }

    private Bitmap zza(zza.zza zza2) {
        if (this.zzaEk == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.zzaEk.get(zza2);
        return bitmap;
    }

    private static final class zza
    extends LruCache<zza.zza, Bitmap> {
        public zza(Context context) {
            super(zza.zzaR(context));
        }

        protected void zza(boolean bl, zza.zza zza2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl, (Object)zza2, (Object)bitmap, (Object)bitmap2);
        }

        private static int zzaR(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n = bl ? activityManager.getLargeMemoryClass() : activityManager.getMemoryClass();
            int n2 = 0x100000 * n;
            return (int)(0.33f * (float)n2);
        }

        protected int zza(zza.zza zza2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        protected /* synthetic */ int sizeOf(Object object, Object object2) {
            return this.zza((zza.zza)object, (Bitmap)object2);
        }

        protected /* synthetic */ void entryRemoved(boolean bl, Object object, Object object2, Object object3) {
            this.zza(bl, (zza.zza)object, (Bitmap)object2, (Bitmap)object3);
        }
    }

    private static final class zzd
    implements ComponentCallbacks2 {
        private final zza zzaEk;

        public zzd(zza zza2) {
            this.zzaEk = zza2;
        }

        public void onConfigurationChanged(Configuration configuration) {
        }

        public void onLowMemory() {
            this.zzaEk.evictAll();
        }

        public void onTrimMemory(int n) {
            if (n >= 60) {
                this.zzaEk.evictAll();
            } else if (n >= 20) {
                this.zzaEk.trimToSize(this.zzaEk.size() / 2);
            }
        }
    }

    private final class zze
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch zztj;
        private boolean zzaEt;

        public zze(Uri uri, Bitmap bitmap, boolean bl, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.zzaEt = bl;
            this.zztj = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl;
            com.google.android.gms.common.internal.zzc.zzdj((String)"OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl2 = bl = this.mBitmap != null;
            if (ImageManager.this.zzaEk != null) {
                if (this.zzaEt) {
                    ImageManager.this.zzaEk.evictAll();
                    System.gc();
                    this.zzaEt = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl) {
                    ImageManager.this.zzaEk.put(new zza.zza(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzaEn.remove(this.mUri))) != null) {
                this.zza(imageReceiver, bl);
            }
            this.zztj.countDown();
            Object object = zzaEf;
            synchronized (object) {
                zzaEg.remove(this.mUri);
            }
        }

        private void zza(ImageReceiver imageReceiver, boolean bl) {
            ArrayList arrayList = imageReceiver.zzaEp;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.common.images.zza zza2 = (com.google.android.gms.common.images.zza)arrayList.get(i);
                if (bl) {
                    zza2.zza(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    ImageManager.this.zzaEo.put(this.mUri, SystemClock.elapsedRealtime());
                    zza2.zza(ImageManager.this.mContext, ImageManager.this.zzaEl, false);
                }
                if (zza2 instanceof zza.zzc) continue;
                ImageManager.this.zzaEm.remove(zza2);
            }
        }
    }

    private final class zzb
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor zzaEr;

        public zzb(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.zzaEr = parcelFileDescriptor;
        }

        @Override
        public void run() {
            com.google.android.gms.common.internal.zzc.zzdk((String)"LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl = false;
            Bitmap bitmap = null;
            if (this.zzaEr != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.zzaEr.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    String string2 = String.valueOf(this.mUri);
                    Log.e((String)"ImageManager", (String)new StringBuilder(34 + String.valueOf(string2).length()).append("OOM while loading bitmap for uri: ").append(string2).toString(), (Throwable)outOfMemoryError);
                    bl = true;
                }
                try {
                    this.zzaEr.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new zze(this.mUri, bitmap, bl, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                String string3 = String.valueOf(this.mUri);
                Log.w((String)"ImageManager", (String)new StringBuilder(32 + String.valueOf(string3).length()).append("Latch interrupted while posting ").append(string3).toString());
            }
        }
    }

    @KeepName
    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.zza> zzaEp;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.zzaEp = new ArrayList();
        }

        public void zzb(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzc.zzdj((String)"ImageReceiver.addImageRequest() must be called in the main thread");
            this.zzaEp.add(zza2);
        }

        public void zzc(com.google.android.gms.common.images.zza zza2) {
            com.google.android.gms.common.internal.zzc.zzdj((String)"ImageReceiver.removeImageRequest() must be called in the main thread");
            this.zzaEp.remove(zza2);
        }

        public void zzxr() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int n, Bundle bundle) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)bundle.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.zzaEj.execute(new zzb(this.mUri, parcelFileDescriptor));
        }
    }

    private final class zzc
    implements Runnable {
        private final com.google.android.gms.common.images.zza zzaEs;

        public zzc(com.google.android.gms.common.images.zza zza2) {
            this.zzaEs = zza2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            com.google.android.gms.common.internal.zzc.zzdj((String)"LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzaEm.get(this.zzaEs));
            if (imageReceiver != null) {
                ImageManager.this.zzaEm.remove(this.zzaEs);
                imageReceiver.zzc(this.zzaEs);
            }
            zza.zza zza2 = this.zzaEs.zzaEu;
            if (zza2.uri == null) {
                this.zzaEs.zza(ImageManager.this.mContext, ImageManager.this.zzaEl, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.zza(zza2);
            if (bitmap != null) {
                this.zzaEs.zza(ImageManager.this.mContext, bitmap, true);
                return;
            }
            Long l = (Long)ImageManager.this.zzaEo.get(zza2.uri);
            if (l != null) {
                if (SystemClock.elapsedRealtime() - l < 3600000L) {
                    this.zzaEs.zza(ImageManager.this.mContext, ImageManager.this.zzaEl, true);
                    return;
                }
                ImageManager.this.zzaEo.remove(zza2.uri);
            }
            this.zzaEs.zza(ImageManager.this.mContext, ImageManager.this.zzaEl);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.zzaEn.get(zza2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(zza2.uri);
                ImageManager.this.zzaEn.put(zza2.uri, imageReceiver);
            }
            imageReceiver.zzb(this.zzaEs);
            if (!(this.zzaEs instanceof zza.zzc)) {
                ImageManager.this.zzaEm.put(this.zzaEs, imageReceiver);
            }
            Object object = zzaEf;
            synchronized (object) {
                boolean bl = zzaEg.contains(zza2.uri);
                if (!bl) {
                    zzaEg.add(zza2.uri);
                    imageReceiver.zzxr();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

