/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzc;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@KeepName
public final class DataHolder
extends com.google.android.gms.common.internal.safeparcel.zza
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zze();
    final int zzaiI;
    private final String[] zzaDP;
    Bundle zzaDQ;
    private final CursorWindow[] zzaDR;
    private final int zzavD;
    private final Bundle zzaDS;
    int[] zzaDT;
    int zzaDU;
    boolean mClosed = false;
    private boolean zzaDV = true;
    private static final zza zzaDW = new zza(new String[0], null){

        @Override
        public zza zza(HashMap<String, Object> hashMap) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }

        @Override
        public zza zza(ContentValues contentValues) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }
    };

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.zzaiI = n;
        this.zzaDP = stringArray;
        this.zzaDR = cursorWindowArray;
        this.zzavD = n2;
        this.zzaDS = bundle;
    }

    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.zzaiI = 1;
        this.zzaDP = (String[])zzac.zzw((Object)stringArray);
        this.zzaDR = (CursorWindow[])zzac.zzw((Object)cursorWindowArray);
        this.zzavD = n;
        this.zzaDS = bundle;
        this.zzxk();
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.zzaDP, DataHolder.zza(zza2, -1), n, bundle);
    }

    public void zzxk() {
        int n;
        this.zzaDQ = new Bundle();
        for (n = 0; n < this.zzaDP.length; ++n) {
            this.zzaDQ.putInt(this.zzaDP[n], n);
        }
        this.zzaDT = new int[this.zzaDR.length];
        n = 0;
        for (int i = 0; i < this.zzaDR.length; ++i) {
            this.zzaDT[i] = n;
            int n2 = this.zzaDR[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzaDR[i].getNumRows() - n3;
        }
        this.zzaDU = n;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    String[] zzxl() {
        return this.zzaDP;
    }

    CursorWindow[] zzxm() {
        return this.zzaDR;
    }

    public int getStatusCode() {
        return this.zzavD;
    }

    public Bundle zzxf() {
        return this.zzaDS;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zzaDP.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= zza2.zzaDX.size() ? zza2.zzaDX : zza2.zzaDX.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zzaDP.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzaDP.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.zzaDP.length && bl2; ++n3) {
                    String string2 = zza2.zzaDP[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzaDP.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void zzi(String string2, int n) {
        if (this.zzaDQ == null || !this.zzaDQ.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zzaDU) {
            throw new CursorIndexOutOfBoundsException(n, this.zzaDU);
        }
    }

    public boolean zzdf(String string2) {
        return this.zzaDQ.containsKey(string2);
    }

    public long zzb(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaDR[n2].getLong(n, this.zzaDQ.getInt(string2));
    }

    public int zzc(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaDR[n2].getInt(n, this.zzaDQ.getInt(string2));
    }

    public String zzd(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaDR[n2].getString(n, this.zzaDQ.getInt(string2));
    }

    public boolean zze(String string2, int n, int n2) {
        this.zzi(string2, n);
        Long l = this.zzaDR[n2].getLong(n, this.zzaDQ.getInt(string2));
        return l == 1L;
    }

    public float zzf(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaDR[n2].getFloat(n, this.zzaDQ.getInt(string2));
    }

    public byte[] zzg(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaDR[n2].getBlob(n, this.zzaDQ.getInt(string2));
    }

    public Uri zzh(String string2, int n, int n2) {
        String string3 = this.zzd(string2, n, n2);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzi(string2, n);
        this.zzaDR[n2].copyStringToBuffer(n, this.zzaDQ.getInt(string2), charArrayBuffer);
    }

    public boolean zzi(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaDR[n2].isNull(n, this.zzaDQ.getInt(string2));
    }

    public int getCount() {
        return this.zzaDU;
    }

    public int zzcI(int n) {
        int n2;
        zzac.zzaw((n >= 0 && n < this.zzaDU ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zzaDT.length; ++n2) {
            if (n >= this.zzaDT[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzaDT.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzaDR.length; ++i) {
                    this.zzaDR[i].close();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.zzaDV && this.zzaDR.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = String.valueOf(this.toString());
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
        }
        finally {
            super.finalize();
        }
    }

    public static zza zzc(String[] stringArray) {
        return new zza(stringArray, null);
    }

    public static DataHolder zzcJ(int n) {
        return DataHolder.zza(n, null);
    }

    public static DataHolder zza(int n, Bundle bundle) {
        return new DataHolder(zzaDW, n, bundle);
    }

    public static class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zzaDP;
        private final ArrayList<HashMap<String, Object>> zzaDX;
        private final String zzaDY;
        private final HashMap<Object, Integer> zzaDZ;
        private boolean zzaEa;
        private String zzaEb;

        private zza(String[] stringArray, String string2) {
            this.zzaDP = (String[])zzac.zzw((Object)stringArray);
            this.zzaDX = new ArrayList();
            this.zzaDY = string2;
            this.zzaDZ = new HashMap();
            this.zzaEa = false;
            this.zzaEb = null;
        }

        public zza zza(HashMap<String, Object> hashMap) {
            zzc.zzt(hashMap);
            int n = this.zzb(hashMap);
            if (n == -1) {
                this.zzaDX.add(hashMap);
            } else {
                this.zzaDX.remove(n);
                this.zzaDX.add(n, hashMap);
            }
            this.zzaEa = false;
            return this;
        }

        private int zzb(HashMap<String, Object> hashMap) {
            if (this.zzaDY == null) {
                return -1;
            }
            Object object = hashMap.get(this.zzaDY);
            if (object == null) {
                return -1;
            }
            Integer n = this.zzaDZ.get(object);
            if (n == null) {
                this.zzaDZ.put(object, this.zzaDX.size());
                return -1;
            }
            return n;
        }

        public zza zza(ContentValues contentValues) {
            zzc.zzt((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            Set set = contentValues.valueSet();
            for (Map.Entry entry : set) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zza(hashMap);
        }

        public DataHolder zzcK(int n) {
            return new DataHolder(this, n, null);
        }
    }
}

