/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.zza;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInAccount
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zza();
    public static zze zzajZ = zzi.zzzc();
    final int versionCode;
    private String zzGV;
    private String zzajB;
    private String zzaka;
    private String zzakb;
    private Uri zzakc;
    private String zzakd;
    private long zzake;
    private String zzakf;
    List<Scope> zzaiN;
    private String zzajl;
    private String zzajm;
    private static Comparator<Scope> zzakg = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzvt().compareTo(scope2.zzvt());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInAccount zzcv(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        Uri uri = null;
        String string3 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            uri = Uri.parse((String)string3);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        return GoogleSignInAccount.zza(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), jSONObject.optString("givenName", null), jSONObject.optString("familyName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet).zzcw(jSONObject.optString("serverAuthCode", null));
    }

    public static GoogleSignInAccount zza(@Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable Uri uri, @Nullable Long l, @NonNull String string8, @NonNull Set<Scope> set) {
        if (l == null) {
            l = zzajZ.currentTimeMillis() / 1000L;
        }
        return new GoogleSignInAccount(3, string2, string3, string4, string5, uri, null, l, zzac.zzdr((String)string8), new ArrayList<Scope>((Collection)zzac.zzw(set)), string6, string7);
    }

    GoogleSignInAccount(int n, String string2, String string3, String string4, String string5, Uri uri, String string6, long l, String string7, List<Scope> list, String string8, String string9) {
        this.versionCode = n;
        this.zzGV = string2;
        this.zzajB = string3;
        this.zzaka = string4;
        this.zzakb = string5;
        this.zzakc = uri;
        this.zzakd = string6;
        this.zzake = l;
        this.zzakf = string7;
        this.zzaiN = list;
        this.zzajl = string8;
        this.zzajm = string9;
    }

    @Nullable
    public String getId() {
        return this.zzGV;
    }

    @Nullable
    public String getIdToken() {
        return this.zzajB;
    }

    @Nullable
    public String getEmail() {
        return this.zzaka;
    }

    @Nullable
    public Account getAccount() {
        return this.zzaka == null ? null : new Account(this.zzaka, "com.google");
    }

    @Nullable
    public String getDisplayName() {
        return this.zzakb;
    }

    @Nullable
    public String getGivenName() {
        return this.zzajl;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzajm;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zzakc;
    }

    public GoogleSignInAccount zzcw(String string2) {
        this.zzakd = string2;
        return this;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zzakd;
    }

    public long zzre() {
        return this.zzake;
    }

    public boolean zza() {
        return zzajZ.currentTimeMillis() / 1000L >= this.zzake - 300L;
    }

    @NonNull
    public String zzrf() {
        return this.zzakf;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zzaiN);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public int hashCode() {
        return this.zzrg().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)((Object)object);
        return googleSignInAccount.zzrg().equals(this.zzrg());
    }

    public String zzrg() {
        return this.zzri().toString();
    }

    public String zzrh() {
        JSONObject jSONObject = this.zzri();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private JSONObject zzri() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getGivenName() != null) {
                jSONObject.put("givenName", (Object)this.getGivenName());
            }
            if (this.getFamilyName() != null) {
                jSONObject.put("familyName", (Object)this.getFamilyName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.zzake);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zzrf());
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzaiN, zzakg);
            for (Scope scope : this.zzaiN) {
                jSONArray.put((Object)scope.zzvt());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

