/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzc;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@KeepName
public final class DataHolder
extends com.google.android.gms.common.internal.safeparcel.zza
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zze();
    final int mVersionCode;
    private final String[] zzaCq;
    Bundle zzaCr;
    private final CursorWindow[] zzaCs;
    private final int zzauz;
    private final Bundle zzaCt;
    int[] zzaCu;
    int zzaCv;
    boolean mClosed = false;
    private boolean zzaCw = true;
    private static final zza zzaCx = new zza(new String[0], null){

        @Override
        public zza zzb(HashMap<String, Object> hashMap) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }

        @Override
        public zza zza(ContentValues contentValues) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }
    };

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.mVersionCode = n;
        this.zzaCq = stringArray;
        this.zzaCs = cursorWindowArray;
        this.zzauz = n2;
        this.zzaCt = bundle;
    }

    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.mVersionCode = 1;
        this.zzaCq = (String[])zzac.zzw((Object)stringArray);
        this.zzaCs = (CursorWindow[])zzac.zzw((Object)cursorWindowArray);
        this.zzauz = n;
        this.zzaCt = bundle;
        this.zzwD();
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.zzaCq, DataHolder.zza(zza2, -1), n, bundle);
    }

    public void zzwD() {
        int n;
        this.zzaCr = new Bundle();
        for (n = 0; n < this.zzaCq.length; ++n) {
            this.zzaCr.putInt(this.zzaCq[n], n);
        }
        this.zzaCu = new int[this.zzaCs.length];
        n = 0;
        for (int i = 0; i < this.zzaCs.length; ++i) {
            this.zzaCu[i] = n;
            int n2 = this.zzaCs[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzaCs[i].getNumRows() - n3;
        }
        this.zzaCv = n;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    String[] zzwE() {
        return this.zzaCq;
    }

    CursorWindow[] zzwF() {
        return this.zzaCs;
    }

    public int getStatusCode() {
        return this.zzauz;
    }

    public Bundle zzwy() {
        return this.zzaCt;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zzaCq.length == 0) {
            return new CursorWindow[0];
        }
        List list = n < 0 || n >= zza2.zzaCy.size() ? zza2.zzaCy : zza2.zzaCy.subList(0, n);
        int n2 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zzaCq.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzaCq.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                }
                Map map = (Map)list.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.zzaCq.length && bl2; ++n3) {
                    String string2 = zza2.zzaCq[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzaCq.length);
                    arrayList.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void zzi(String string2, int n) {
        if (this.zzaCr == null || !this.zzaCr.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zzaCv) {
            throw new CursorIndexOutOfBoundsException(n, this.zzaCv);
        }
    }

    public boolean zzdj(String string2) {
        return this.zzaCr.containsKey(string2);
    }

    public long zzb(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaCs[n2].getLong(n, this.zzaCr.getInt(string2));
    }

    public int zzc(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaCs[n2].getInt(n, this.zzaCr.getInt(string2));
    }

    public String zzd(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaCs[n2].getString(n, this.zzaCr.getInt(string2));
    }

    public boolean zze(String string2, int n, int n2) {
        this.zzi(string2, n);
        Long l = this.zzaCs[n2].getLong(n, this.zzaCr.getInt(string2));
        return l == 1L;
    }

    public float zzf(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaCs[n2].getFloat(n, this.zzaCr.getInt(string2));
    }

    public byte[] zzg(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaCs[n2].getBlob(n, this.zzaCr.getInt(string2));
    }

    public Uri zzh(String string2, int n, int n2) {
        String string3 = this.zzd(string2, n, n2);
        return string3 == null ? null : Uri.parse((String)string3);
    }

    public void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzi(string2, n);
        this.zzaCs[n2].copyStringToBuffer(n, this.zzaCr.getInt(string2), charArrayBuffer);
    }

    public boolean zzi(String string2, int n, int n2) {
        this.zzi(string2, n);
        return this.zzaCs[n2].isNull(n, this.zzaCr.getInt(string2));
    }

    public int getCount() {
        return this.zzaCv;
    }

    public int zzcC(int n) {
        int n2;
        zzac.zzar((n >= 0 && n < this.zzaCv ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zzaCu.length; ++n2) {
            if (n >= this.zzaCu[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzaCu.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzaCs.length; ++i) {
                    this.zzaCs[i].close();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.zzaCw && this.zzaCs.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = String.valueOf(this.toString());
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
        }
        finally {
            super.finalize();
        }
    }

    public static zza zzc(String[] stringArray) {
        return new zza(stringArray, null);
    }

    public static DataHolder zzcD(int n) {
        return DataHolder.zza(n, null);
    }

    public static DataHolder zza(int n, Bundle bundle) {
        return new DataHolder(zzaCx, n, bundle);
    }

    public static class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zzaCq;
        private final ArrayList<HashMap<String, Object>> zzaCy;
        private final String zzaCz;
        private final HashMap<Object, Integer> zzaCA;
        private boolean zzaCB;
        private String zzaCC;

        private zza(String[] stringArray, String string2) {
            this.zzaCq = (String[])zzac.zzw((Object)stringArray);
            this.zzaCy = new ArrayList();
            this.zzaCz = string2;
            this.zzaCA = new HashMap();
            this.zzaCB = false;
            this.zzaCC = null;
        }

        public zza zzb(HashMap<String, Object> hashMap) {
            zzc.zzt(hashMap);
            int n = this.zzc(hashMap);
            if (n == -1) {
                this.zzaCy.add(hashMap);
            } else {
                this.zzaCy.remove(n);
                this.zzaCy.add(n, hashMap);
            }
            this.zzaCB = false;
            return this;
        }

        private int zzc(HashMap<String, Object> hashMap) {
            if (this.zzaCz == null) {
                return -1;
            }
            Object object = hashMap.get(this.zzaCz);
            if (object == null) {
                return -1;
            }
            Integer n = this.zzaCA.get(object);
            if (n == null) {
                this.zzaCA.put(object, this.zzaCy.size());
                return -1;
            }
            return n;
        }

        public zza zza(ContentValues contentValues) {
            zzc.zzt((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            Set set = contentValues.valueSet();
            for (Map.Entry entry : set) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zzb(hashMap);
        }

        public DataHolder zzcE(int n) {
            return new DataHolder(this, n, null);
        }
    }
}

