/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzaai;
import com.google.android.gms.internal.zzaaj;
import com.google.android.gms.internal.zzaak;
import com.google.android.gms.internal.zzaal;
import com.google.android.gms.internal.zzaam;
import com.google.android.gms.internal.zzaau;
import com.google.android.gms.internal.zzabi;
import com.google.android.gms.internal.zzaxn;
import com.google.android.gms.internal.zzaxo;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.internal.zzzy;
import com.google.android.gms.internal.zzzz;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzaan
implements zzaau,
zzzz {
    private final Lock zzazn;
    private final Condition zzaAE;
    private final Context mContext;
    private final zzc zzazw;
    private final zzb zzaAF;
    final Map<Api.zzc<?>, Api.zze> zzaAr;
    final Map<Api.zzc<?>, ConnectionResult> zzaAG = new HashMap();
    final zzg zzazs;
    final Map<Api<?>, Integer> zzazu;
    final Api.zza<? extends zzaxn, zzaxo> zzaxY;
    private volatile zzaam zzaAH;
    private ConnectionResult zzaAI = null;
    int zzaAJ;
    final zzaal zzazd;
    final zzaau.zza zzaAK;

    public zzaan(Context context, zzaal zzaal2, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, zzg zzg2, Map<Api<?>, Integer> map2, Api.zza<? extends zzaxn, zzaxo> zza2, ArrayList<zzzy> arrayList, zzaau.zza zza3) {
        this.mContext = context;
        this.zzazn = lock;
        this.zzazw = zzc2;
        this.zzaAr = map;
        this.zzazs = zzg2;
        this.zzazu = map2;
        this.zzaxY = zza2;
        this.zzazd = zzaal2;
        this.zzaAK = zza3;
        for (zzzy zzzy2 : arrayList) {
            zzzy2.zza(this);
        }
        this.zzaAF = new zzb(looper);
        this.zzaAE = lock.newCondition();
        this.zzaAH = new zzaak(this);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzzv.zza<R, A>> T zza(@NonNull T t) {
        t.zzvf();
        return this.zzaAH.zza(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzzv.zza<? extends Result, A>> T zzb(@NonNull T t) {
        t.zzvf();
        return this.zzaAH.zzb(t);
    }

    @Override
    public void connect() {
        this.zzaAH.connect();
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzaAE.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzawX;
        }
        if (this.zzaAI != null) {
            return this.zzaAI;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzaAE.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzawX;
        }
        if (this.zzaAI != null) {
            return this.zzaAI;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        boolean bl = this.zzaAH.disconnect();
        if (bl) {
            this.zzaAG.clear();
        }
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzuH();
        if (this.zzaAr.containsKey(zzc2)) {
            if (this.zzaAr.get(zzc2).isConnected()) {
                return ConnectionResult.zzawX;
            }
            if (this.zzaAG.containsKey(zzc2)) {
                return this.zzaAG.get(zzc2);
            }
        }
        return null;
    }

    void zzvO() {
        this.zzazn.lock();
        try {
            this.zzaAH = new zzaaj(this, this.zzazs, this.zzazu, this.zzazw, this.zzaxY, this.zzazn, this.mContext);
            this.zzaAH.begin();
            this.zzaAE.signalAll();
        }
        finally {
            this.zzazn.unlock();
        }
    }

    void zzvP() {
        this.zzazn.lock();
        try {
            this.zzazd.zzvL();
            this.zzaAH = new zzaai(this);
            this.zzaAH.begin();
            this.zzaAE.signalAll();
        }
        finally {
            this.zzazn.unlock();
        }
    }

    void zzh(ConnectionResult connectionResult) {
        this.zzazn.lock();
        try {
            this.zzaAI = connectionResult;
            this.zzaAH = new zzaak(this);
            this.zzaAH.begin();
            this.zzaAE.signalAll();
        }
        finally {
            this.zzazn.unlock();
        }
    }

    void zzvQ() {
        for (Api.zze zze2 : this.zzaAr.values()) {
            zze2.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzaAH instanceof zzaai;
    }

    @Override
    public boolean isConnecting() {
        return this.zzaAH instanceof zzaaj;
    }

    @Override
    public boolean zza(zzabi zzabi2) {
        return false;
    }

    @Override
    public void zzuN() {
    }

    @Override
    public void zzvj() {
        if (this.isConnected()) {
            ((zzaai)this.zzaAH).zzvz();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, int n) {
        this.zzazn.lock();
        try {
            this.zzaAH.zza(connectionResult, api, n);
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public void onConnected(@Nullable Bundle bundle) {
        this.zzazn.lock();
        try {
            this.zzaAH.onConnected(bundle);
        }
        finally {
            this.zzazn.unlock();
        }
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.zzazn.lock();
        try {
            this.zzaAH.onConnectionSuspended(n);
        }
        finally {
            this.zzazn.unlock();
        }
    }

    void zza(zza zza2) {
        Message message = this.zzaAF.obtainMessage(1, zza2);
        this.zzaAF.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.zzaAF.obtainMessage(2, runtimeException);
        this.zzaAF.sendMessage(message);
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzaAH);
        for (Api<?> api : this.zzazu.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            Api.zze zze2 = this.zzaAr.get(api.zzuH());
            zze2.dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static abstract class zza {
        private final zzaam zzaAL;

        protected zza(zzaam zzaam2) {
            this.zzaAL = zzaam2;
        }

        public final void zzc(zzaan zzaan2) {
            zzaan2.zzazn.lock();
            try {
                if (zzaan2.zzaAH != this.zzaAL) {
                    return;
                }
                this.zzvA();
            }
            finally {
                zzaan2.zzazn.unlock();
            }
        }

        protected abstract void zzvA();
    }

    final class zzb
    extends Handler {
        zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zza zza2 = (zza)message.obj;
                    zza2.zzc(zzaan.this);
                    break;
                }
                case 2: {
                    throw (RuntimeException)message.obj;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GACStateManager", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }
}

