/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.auth-api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.gms.auth.api.identity.BeginSignInResult;
import com.google.android.gms.auth.api.identity.GetPhoneNumberHintIntentRequest;
import com.google.android.gms.auth.api.identity.GetSignInIntentRequest;
import com.google.android.gms.auth.api.identity.SignInClient;
import com.google.android.gms.auth.api.identity.SignInCredential;
import com.google.android.gms.auth.api.identity.zbn;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.IStatusCallback;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.internal.auth-api.zbai;
import com.google.android.gms.internal.auth-api.zbap;
import com.google.android.gms.internal.auth-api.zbaq;
import com.google.android.gms.internal.auth-api.zbar;
import com.google.android.gms.internal.auth-api.zbas;
import com.google.android.gms.internal.auth-api.zbat;
import com.google.android.gms.internal.auth-api.zbav;
import com.google.android.gms.internal.auth-api.zbax;
import com.google.android.gms.internal.auth-api.zbaz;
import com.google.android.gms.internal.auth-api.zbba;
import com.google.android.gms.internal.auth-api.zbbb;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public final class zbay
extends GoogleApi
implements SignInClient {
    private static final Api.ClientKey zba;
    private static final Api.AbstractClientBuilder zbb;
    private static final Api zbc;
    private final String zbd = zbbb.zba();

    @Override
    public final SignInCredential getSignInCredentialFromIntent(@Nullable Intent intent) throws ApiException {
        Object object;
        if (intent == null) {
            object = new ApiException(Status.RESULT_INTERNAL_ERROR);
            throw object;
        }
        object = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (object == null) {
            object = new ApiException(Status.RESULT_CANCELED);
            throw object;
        }
        if (!object.isSuccess()) {
            intent = new ApiException((Status)object);
            throw intent;
        }
        object = (SignInCredential)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"sign_in_credential", SignInCredential.CREATOR);
        if (object == null) {
            object = new ApiException(Status.RESULT_INTERNAL_ERROR);
            throw object;
        }
        return object;
    }

    @Override
    public final Task<BeginSignInResult> beginSignIn(@NonNull BeginSignInRequest object) {
        Preconditions.checkNotNull((Object)object);
        object = BeginSignInRequest.zba(object);
        ((BeginSignInRequest.Builder)object).zba(this.zbd);
        object = ((BeginSignInRequest.Builder)object).build();
        TaskApiCall.Builder builder = TaskApiCall.builder();
        Object object2 = new Feature[]{zbba.zba};
        builder = builder.setFeatures(object2);
        object2 = new zbap(this, (BeginSignInRequest)((Object)object));
        return this.doRead(builder.run((RemoteCall)object2).setAutoResolveMissingFeatures(false).setMethodKey(1553).build());
    }

    @Override
    public final Task<PendingIntent> getPhoneNumberHintIntent(@NonNull GetPhoneNumberHintIntentRequest getPhoneNumberHintIntentRequest) {
        Preconditions.checkNotNull((Object)((Object)getPhoneNumberHintIntentRequest));
        TaskApiCall.Builder builder = TaskApiCall.builder();
        Object object = new Feature[]{zbba.zbh};
        builder = builder.setFeatures(object);
        object = new zbas(this, getPhoneNumberHintIntentRequest);
        return this.doRead(builder.run((RemoteCall)object).setMethodKey(1653).build());
    }

    @Override
    public final Task<PendingIntent> getSignInIntent(@NonNull GetSignInIntentRequest object) {
        Preconditions.checkNotNull((Object)object);
        object = GetSignInIntentRequest.zba(object);
        ((GetSignInIntentRequest.Builder)object).zba(this.zbd);
        object = ((GetSignInIntentRequest.Builder)object).build();
        TaskApiCall.Builder builder = TaskApiCall.builder();
        Object object2 = new Feature[]{zbba.zbf};
        builder = builder.setFeatures(object2);
        object2 = new zbaq(this, (GetSignInIntentRequest)((Object)object));
        return this.doRead(builder.run((RemoteCall)object2).setMethodKey(1555).build());
    }

    @Override
    public final Task<Void> signOut() {
        this.getApplicationContext().getSharedPreferences("com.google.android.gms.signin", 0).edit().clear().apply();
        TaskApiCall.Builder builder = GoogleApiClient.getAllClients().iterator();
        while (builder.hasNext()) {
            ((GoogleApiClient)builder.next()).maybeSignOut();
        }
        GoogleApiManager.reportSignOut();
        builder = TaskApiCall.builder();
        Object object = new Feature[]{zbba.zbb};
        builder = builder.setFeatures(object);
        object = new zbar(this);
        return this.doWrite(builder.run((RemoteCall)object).setAutoResolveMissingFeatures(false).setMethodKey(1554).build());
    }

    @Override
    public final String getPhoneNumberFromIntent(@Nullable Intent intent) throws ApiException {
        Object object;
        if (intent == null) {
            object = new ApiException(Status.RESULT_INTERNAL_ERROR);
            throw object;
        }
        object = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (object == null) {
            object = new ApiException(Status.RESULT_CANCELED);
            throw object;
        }
        if (!object.isSuccess()) {
            intent = new ApiException((Status)object);
            throw intent;
        }
        object = intent.getStringExtra("phone_number_hint_result");
        if (object == null) {
            object = new ApiException(Status.RESULT_INTERNAL_ERROR);
            throw object;
        }
        return object;
    }

    static {
        Object object;
        zba = object = new Api.ClientKey();
        object = new zbat();
        zbb = object;
        object = new Api("Auth.Api.Identity.SignIn.API", zbb, zba);
        zbc = object;
    }

    public zbay(@NonNull Activity activity, @NonNull zbn zbn2) {
        super(activity, zbc, (Api.ApiOptions)zbn2, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zbay(@NonNull Context context, @NonNull zbn zbn2) {
        super(context, zbc, (Api.ApiOptions)zbn2, GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    final /* synthetic */ void zba(GetPhoneNumberHintIntentRequest getPhoneNumberHintIntentRequest, zbaz zbaz2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zbax zbax2 = new zbax(this, taskCompletionSource);
        ((zbai)zbaz2.getService()).zbd(zbax2, getPhoneNumberHintIntentRequest, this.zbd);
    }

    final /* synthetic */ void zbb(zbaz zbaz2, TaskCompletionSource taskCompletionSource) throws RemoteException {
        zbav zbav2 = new zbav(this, taskCompletionSource);
        ((zbai)zbaz2.getService()).zbf((IStatusCallback)zbav2, this.zbd);
    }
}

