/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Credential
extends zzbgl
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    private final String zzbzd;
    @Nullable
    private final String mName;
    @Nullable
    private final Uri zzekl;
    private final List<IdToken> zzekm;
    @Nullable
    private final String zzekn;
    @Nullable
    private final String zzekb;
    @Nullable
    private final String zzeko;
    @Nullable
    private final String zzekp;
    @Nullable
    private final String zzekq;
    @Nullable
    private final String zzekr;

    /*
     * Unable to fully structure code
     */
    @Hide
    Credential(String var1_1, String var2_2, Uri var3_3, List<IdToken> var4_4, String var5_5, String var6_6, String var7_7, String var8_8, String var9_9, String var10_10) {
        block8: {
            super();
            var11_11 = ((String)zzbq.checkNotNull((Object)var1_1, (Object)"credential identifier cannot be null")).trim();
            zzbq.zzh((String)var11_11, (Object)"credential identifier cannot be empty");
            if (var5_5 != null && TextUtils.isEmpty((CharSequence)var5_5)) {
                throw new IllegalArgumentException("Password must not be empty if set");
            }
            if (var6_6 == null) break block8;
            var12_12 = var6_6;
            if (TextUtils.isEmpty((CharSequence)var12_12)) ** GOTO lbl-1000
            var13_13 = Uri.parse((String)var12_12);
            if (!var13_13.isAbsolute() || !var13_13.isHierarchical() || TextUtils.isEmpty((CharSequence)var13_13.getScheme()) || TextUtils.isEmpty((CharSequence)var13_13.getAuthority())) {
                v0 = false;
            } else if ("http".equalsIgnoreCase(var13_13.getScheme()) || "https".equalsIgnoreCase(var13_13.getScheme())) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!Boolean.valueOf(v0).booleanValue()) {
                throw new IllegalArgumentException("Account type must be a valid Http/Https URI");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)var6_6) && !TextUtils.isEmpty((CharSequence)var5_5)) {
            throw new IllegalArgumentException("Password and AccountType are mutually exclusive");
        }
        if (var2_2 != null && TextUtils.isEmpty((CharSequence)var2_2.trim())) {
            var2_2 = null;
        }
        this.mName = var2_2;
        this.zzekl = var3_3;
        this.zzekm = var4_4 == null ? Collections.emptyList() : Collections.unmodifiableList(var4_4);
        this.zzbzd = var11_11;
        this.zzekn = var5_5;
        this.zzekb = var6_6;
        this.zzeko = var7_7;
        this.zzekp = var8_8;
        this.zzekq = var9_9;
        this.zzekr = var10_10;
    }

    public String getId() {
        return this.zzbzd;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzekl;
    }

    public List<IdToken> getIdTokens() {
        return this.zzekm;
    }

    @Nullable
    public String getPassword() {
        return this.zzekn;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzeko;
    }

    @Nullable
    public String getAccountType() {
        return this.zzekb;
    }

    @Nullable
    public String getGivenName() {
        return this.zzekq;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzekr;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Credential credential = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)credential.getId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)credential.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)credential.getProfilePictureUri(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, credential.getIdTokens(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)credential.getPassword(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)credential.getAccountType(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (String)credential.getGeneratedPassword(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (String)credential.zzekp, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (String)credential.getGivenName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)10, (String)credential.getFamilyName(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zzbzd, (CharSequence)credential.zzbzd) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzbg.equal((Object)this.zzekl, (Object)credential.zzekl) && TextUtils.equals((CharSequence)this.zzekn, (CharSequence)credential.zzekn) && TextUtils.equals((CharSequence)this.zzekb, (CharSequence)credential.zzekb) && TextUtils.equals((CharSequence)this.zzeko, (CharSequence)credential.zzeko);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzbzd, this.mName, this.zzekl, this.zzekn, this.zzekb, this.zzeko});
    }

    public static class Builder {
        private final String zzbzd;
        private String mName;
        private Uri zzekl;
        private List<IdToken> zzekm;
        private String zzekn;
        private String zzekb;
        private String zzeko;
        private String zzekp;
        private String zzekq;
        private String zzekr;

        public Builder(String string) {
            this.zzbzd = string;
        }

        public Builder(Credential credential) {
            this.zzbzd = credential.zzbzd;
            this.mName = credential.mName;
            this.zzekl = credential.zzekl;
            this.zzekm = credential.zzekm;
            this.zzekn = credential.zzekn;
            this.zzekb = credential.zzekb;
            this.zzeko = credential.zzeko;
            this.zzekp = credential.zzekp;
            this.zzekq = credential.zzekq;
            this.zzekr = credential.zzekr;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzekl = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zzekn = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzekb = string;
            return this;
        }

        public Credential build() {
            return new Credential(this.zzbzd, this.mName, this.zzekl, this.zzekm, this.zzekn, this.zzekb, this.zzeko, this.zzekp, this.zzekq, this.zzekr);
        }
    }
}

