/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zzj;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

@Hide
public final class PasswordSpecification
extends zzbgl
implements ReflectedParcelable {
    public static final Parcelable.Creator<PasswordSpecification> CREATOR = new zzj();
    public static final PasswordSpecification zzeli = new zza().zzj(12, 16).zzey("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zze("abcdefghijkmnopqrstxyz", 1).zze("ABCDEFGHJKLMNPQRSTXY", 1).zze("3456789", 1).zzaca();
    private static PasswordSpecification zzelj = new zza().zzj(12, 16).zzey("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zze("abcdefghijklmnopqrstuvwxyz", 1).zze("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zze("1234567890", 1).zzaca();
    @VisibleForTesting
    private String zzelk;
    @VisibleForTesting
    private List<String> zzell;
    @VisibleForTesting
    private List<Integer> zzelm;
    @VisibleForTesting
    private int zzeln;
    @VisibleForTesting
    private int zzelo;
    private final int[] zzelp;
    private final Random zzbje;

    PasswordSpecification(String string, List<String> list, List<Integer> list2, int n, int n2) {
        this.zzelk = string;
        this.zzell = Collections.unmodifiableList(list);
        this.zzelm = Collections.unmodifiableList(list2);
        this.zzeln = n;
        this.zzelo = n2;
        PasswordSpecification passwordSpecification = this;
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n3 = 0;
        Iterator<String> iterator = passwordSpecification.zzell.iterator();
        while (iterator.hasNext()) {
            for (char c : iterator.next().toCharArray()) {
                nArray[c - 32] = n3;
            }
            ++n3;
        }
        this.zzelp = nArray;
        this.zzbje = new SecureRandom();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PasswordSpecification passwordSpecification = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)passwordSpecification.zzelk, (boolean)false);
        zzbgo.zzb((Parcel)parcel2, (int)2, passwordSpecification.zzell, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, passwordSpecification.zzelm, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, (int)passwordSpecification.zzeln);
        zzbgo.zzc((Parcel)parcel2, (int)5, (int)passwordSpecification.zzelo);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzc(int n, int n2, int n3) {
        return n < 32 || n > 126;
    }

    public static final class zzb
    extends Error {
        public zzb(String string) {
            super(string);
        }
    }

    public static final class zza {
        private final TreeSet<Character> zzelq = new TreeSet();
        private final List<String> zzell = new ArrayList<String>();
        private final List<Integer> zzelm = new ArrayList<Integer>();
        private int zzeln = 12;
        private int zzelo = 16;

        public final zza zzey(@NonNull String string) {
            this.zzelq.addAll(zza.zzn(string, "allowedChars"));
            return this;
        }

        public final zza zze(@NonNull String string, int n) {
            TreeSet<Character> treeSet = zza.zzn(string, "requiredChars");
            this.zzell.add(PasswordSpecification.zzb(treeSet));
            this.zzelm.add(1);
            return this;
        }

        public final zza zzj(int n, int n2) {
            this.zzeln = 12;
            this.zzelo = 16;
            return this;
        }

        public final PasswordSpecification zzaca() {
            if (this.zzelq.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            zza zza2 = this;
            int n = 0;
            Iterator<Object> iterator = zza2.zzelm.iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.next();
                n += n2;
            }
            if (n > zza2.zzelo) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
            zza2 = this;
            boolean[] blArray = new boolean[95];
            iterator = zza2.zzell.iterator();
            while (iterator.hasNext()) {
                for (char c : ((String)iterator.next()).toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb(new StringBuilder(58).append("character ").append(c).append(" occurs in more than one required character set").toString());
                    }
                    blArray[c - 32] = true;
                }
            }
            return new PasswordSpecification(PasswordSpecification.zzb(this.zzelq), this.zzell, this.zzelm, this.zzeln, this.zzelo);
        }

        private static TreeSet<Character> zzn(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new zzb(String.valueOf(string2).concat(" cannot be null or empty"));
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string.toCharArray()) {
                if (PasswordSpecification.zzc(c, 32, 126)) {
                    throw new zzb(String.valueOf(string2).concat(" must only contain ASCII printable characters"));
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }
    }
}

