/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.zzd;
import com.google.android.gms.auth.zzf;
import com.google.android.gms.auth.zzg;
import com.google.android.gms.auth.zzh;
import com.google.android.gms.auth.zzi;
import com.google.android.gms.auth.zzj;
import com.google.android.gms.auth.zzk;
import com.google.android.gms.common.BlockingServiceConnection;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesIncorrectManifestValueException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.internal.auth.zzbw;
import com.google.android.gms.internal.auth.zzby;
import com.google.android.gms.internal.auth.zzdc;
import com.google.android.gms.internal.auth.zze;
import com.google.android.gms.internal.auth.zzhr;
import com.google.android.gms.internal.auth.zzhs;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

@ShowFirstParty
public class zzl {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    @ShowFirstParty
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    @ShowFirstParty
    public static final String[] zza;
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @SuppressLint(value={"InlinedApi"})
    @ShowFirstParty
    public static final String zzb;
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzc;
    private static final Logger zzd;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=23)
    @ShowFirstParty
    public static Bundle removeAccount(Context context, Account account) throws GoogleAuthException, IOException {
        Context context2;
        void var1_1;
        Preconditions.checkNotNull((Object)context);
        zzl.zzn((Account)var1_1);
        zzl.zzk(context2, 8400000);
        zzdc.zze(context2);
        if (zzhs.zze() && zzl.zzo(context2)) {
            Task task = com.google.android.gms.internal.auth.zzh.zza(context2).zzd((Account)var1_1);
            String string = "account removal";
            try {
                task = (Bundle)zzl.zzi(task, string);
                zzl.zzj(task);
                return task;
            }
            catch (ApiException apiException) {
                zzl.zzl(apiException, string);
            }
        }
        zzg zzg2 = new zzg((Account)var1_1);
        return (Bundle)zzl.zzh(context2, zzc, zzg2, 0L);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static TokenData zzg(Bundle object) throws GoogleAuthException, IOException {
        void var1_6;
        Bundle bundle;
        ClassLoader classLoader = TokenData.class.getClassLoader();
        if (classLoader != null) {
            object.setClassLoader(classLoader);
        }
        if ((bundle = object.getBundle("tokenDetails")) == null) {
            Object var1_5 = null;
        } else {
            if (classLoader != null) {
                bundle.setClassLoader(classLoader);
            }
            TokenData tokenData = (TokenData)bundle.getParcelable("TokenData");
        }
        if (var1_6 != null) {
            return var1_6;
        }
        String string = object.getString("Error");
        Preconditions.checkNotNull((Object)string);
        Intent intent = (Intent)object.getParcelable("userRecoveryIntent");
        zzby zzby2 = zzby.zza(string);
        if (zzby.zzb(zzby2)) {
            zzd.w("isUserRecoverableError status: ".concat(String.valueOf(String.valueOf((Object)zzby2))), new Object[0]);
            UserRecoverableAuthException userRecoverableAuthException = new UserRecoverableAuthException(string, intent);
            throw userRecoverableAuthException;
        }
        if (!(zzby.zze.equals((Object)zzby2) || zzby.zzf.equals((Object)zzby2) || zzby.zzg.equals((Object)zzby2) || zzby.zzaf.equals((Object)zzby2) || zzby.zzah.equals((Object)zzby2))) {
            GoogleAuthException googleAuthException = new GoogleAuthException(string);
            throw googleAuthException;
        }
        IOException iOException = new IOException(string);
        throw iOException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TokenData zza(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Bundle bundle2;
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        Preconditions.checkNotEmpty((String)string, (Object)"Scope cannot be empty or null.");
        zzl.zzn(account);
        zzl.zzk(context, 8400000);
        bundle = bundle == null ? new Bundle() : (bundle2 = new Bundle(bundle));
        zzl.zzm(context, bundle);
        zzdc.zze(context);
        if (zzhs.zze() && zzl.zzo(context)) {
            Task task = com.google.android.gms.internal.auth.zzh.zza(context).zzc(account, string, bundle);
            String string2 = "token retrieval";
            try {
                Bundle bundle3 = (Bundle)zzl.zzi(task, string2);
                zzl.zzj(bundle3);
                return zzl.zzg(bundle3);
            }
            catch (ApiException apiException) {
                zzl.zzl(apiException, string2);
            }
        }
        zzf zzf2 = new zzf(account, string, bundle);
        return (TokenData)((Object)zzl.zzh(context, zzc, zzf2, 0L));
    }

    static /* synthetic */ TokenData zzb(Account object, String string, Bundle bundle, IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
        object = zze.zzb(iBinder).zze((Account)object, string, bundle);
        if (object == null) {
            object = new IOException("Service call returned null");
            throw object;
        }
        return zzl.zzg((Bundle)object);
    }

    static /* bridge */ /* synthetic */ Logger zzc() {
        return zzd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=26)
    public static Boolean requestGoogleAccountsAccess(Context context) throws GoogleAuthException, IOException {
        String string;
        Object object;
        block6: {
            Context context2;
            Preconditions.checkNotNull((Object)context);
            zzl.zzk(context2, 11400000);
            String string2 = context2.getApplicationInfo().packageName;
            zzdc.zze(context2);
            if (zzhs.zze() && zzl.zzo(context2)) {
                object = com.google.android.gms.internal.auth.zzh.zza(context2).zze(string2);
                String string3 = "google accounts access request";
                try {
                    object = (Bundle)zzl.zzi(object, string3);
                    string = object.getString("Error");
                    object = (Intent)object.getParcelable("userRecoveryIntent");
                    Object object2 = zzby.zza(string);
                    boolean bl = zzby.zzc.equals(object2);
                    if (bl) {
                        return true;
                    }
                    bl = zzby.zzb(object2);
                    if (bl) {
                        Logger logger = zzd;
                        object2 = String.valueOf(object2);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("isUserRecoverableError status: ");
                        stringBuilder.append((String)object2);
                        logger.w(stringBuilder.toString(), new Object[0]);
                        object2 = new UserRecoverableAuthException(string, (Intent)object);
                        throw object2;
                    }
                    break block6;
                }
                catch (ApiException apiException) {
                    zzl.zzl(apiException, string3);
                }
            }
            zzj zzj2 = new zzj(string2);
            return (Boolean)zzl.zzh(context2, zzc, zzj2, 0L);
        }
        object = new GoogleAuthException(string);
        throw object;
    }

    static /* bridge */ /* synthetic */ Object zzd(Object object) {
        zzl.zzj(object);
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object zzh(Context var0, ComponentName var1_2, zzk var2_3, long var3_6) throws IOException, GoogleAuthException {
        block6: {
            block7: {
                var5_7 = new BlockingServiceConnection();
                var0 /* !! */  = GmsClientSupervisor.getInstance((Context)var0 /* !! */ );
                try {
                    var6_8 = var0 /* !! */ .bindService((ComponentName)var1_2 /* !! */ , (ServiceConnection)var5_7, "GoogleAuthUtil");
                    if (!var6_8) break block6;
                }
                catch (SecurityException var0_1) {
                    var1_2 /* !! */  = new Object[]{var0_1.getMessage()};
                    Log.w((String)"GoogleAuthUtil", (String)String.format("SecurityException while bind to auth service: %s", var1_2 /* !! */ ));
                    var1_2 /* !! */  = new IOException("SecurityException while binding to Auth service.", var0_1);
                    throw var1_2 /* !! */ ;
                }
                ** try [egrp 1[TRYBLOCK] [4, 2, 1, 3 : 32->44)] { 
lbl13:
                // 1 sources

                break block7;
lbl14:
                // 1 sources

                catch (Throwable var2_4) {
                    var0 /* !! */ .unbindService((ComponentName)var1_2 /* !! */ , (ServiceConnection)var5_7, "GoogleAuthUtil");
                    throw var2_4;
                }
lbl17:
                // 3 sources

                catch (RemoteException | InterruptedException | TimeoutException var2_5) {
                    ** GOTO lbl-1000
                }
            }
            var2_3 = var2_3.zza(var5_7.getService());
            var0 /* !! */ .unbindService((ComponentName)var1_2 /* !! */ , (ServiceConnection)var5_7, "GoogleAuthUtil");
            return var2_3;
        }
        var0 /* !! */  = new IOException("Could not bind to service.");
        throw var0 /* !! */ ;
lbl-1000:
        // 1 sources

        {
            Log.i((String)"GoogleAuthUtil", (String)"Error on service connection.", (Throwable)var2_5);
            var6_9 = new IOException("Error on service connection.", var2_5);
            throw var6_9;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object zzi(Task object, String string) throws IOException, ApiException {
        ExecutionException executionException2;
        String string2;
        block4: {
            try {
                return Tasks.await((Task)object);
            }
            catch (InterruptedException interruptedException) {
                Object[] objectArray = new Object[]{string2};
                string2 = String.format("Interrupted while waiting for the task of %s to finish.", objectArray);
                zzd.w(string2, new Object[0]);
                IOException iOException = new IOException(string2, interruptedException);
                throw iOException;
            }
            catch (CancellationException cancellationException) {
                Object[] objectArray = new Object[]{string2};
                string2 = String.format("Canceled while waiting for the task of %s to finish.", objectArray);
                zzd.w(string2, new Object[0]);
                IOException iOException = new IOException(string2, cancellationException);
                throw iOException;
            }
            catch (ExecutionException executionException2) {
                Throwable throwable = executionException2.getCause();
                if (!(throwable instanceof ApiException)) break block4;
                throw (ApiException)throwable;
            }
        }
        Object[] objectArray = new Object[]{string2};
        string2 = String.format("Unable to get a result for %s due to ExecutionException.", objectArray);
        zzd.w(string2, new Object[0]);
        IOException iOException = new IOException(string2, executionException2);
        throw iOException;
    }

    private static Object zzj(Object object) throws IOException {
        if (object == null) {
            zzd.w("Service call returned null.", new Object[0]);
            object = new IOException("Service unavailable.");
            throw object;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static String getAccountId(Context ctx, String accountName) throws GoogleAuthException, IOException {
        void var1_1;
        Context context;
        Preconditions.checkNotEmpty((String)accountName, (Object)"accountName must be provided");
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzl.zzk(context, 8400000);
        Bundle bundle = new Bundle();
        return zzl.getToken(context, (String)var1_1, "^^_account_id_^^", bundle);
    }

    /*
     * WARNING - void declaration
     */
    public static String getToken(Context context, Account account, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var2_2;
        void var1_1;
        Context context2;
        Bundle bundle = new Bundle();
        return zzl.getToken(context2, (Account)var1_1, (String)var2_2, bundle);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String getToken(Context context, String accountName, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var2_2;
        Context context2;
        void var1_1;
        Account account = new Account((String)var1_1, GOOGLE_ACCOUNT_TYPE);
        return zzl.getToken(context2, account, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String getToken(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var3_3;
        void var2_2;
        void var1_1;
        Context context2;
        zzl.zzn(account);
        return zzl.zza(context2, (Account)var1_1, (String)var2_2, (Bundle)var3_3).zza();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String getToken(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var3_3;
        void var2_2;
        Context context2;
        void var1_1;
        Account account = new Account((String)var1_1, GOOGLE_ACCOUNT_TYPE);
        return zzl.getToken(context2, account, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, int eventIndex, String accountName) throws GoogleAuthException, IOException {
        void var1_1;
        String string;
        Context context2;
        Preconditions.checkNotEmpty((String)accountName, (Object)"accountName must be provided");
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzl.zzk(context2, 8400000);
        AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest();
        accountChangeEventsRequest.setAccountName(string);
        accountChangeEventsRequest.setEventIndex((int)var1_1);
        zzdc.zze(context2);
        if (zzhs.zzd() && zzl.zzo(context2)) {
            Object object = com.google.android.gms.internal.auth.zzh.zza(context2).zzb(accountChangeEventsRequest);
            string = "account change events retrieval";
            try {
                object = (AccountChangeEventsResponse)((Object)zzl.zzi((Task)object, string));
                zzl.zzj(object);
                return ((AccountChangeEventsResponse)((Object)object)).getEvents();
            }
            catch (ApiException apiException) {
                zzl.zzl(apiException, string);
            }
        }
        zzi zzi2 = new zzi(accountChangeEventsRequest);
        return (List)zzl.zzh(context2, zzc, zzi2, 0L);
    }

    static {
        String[] stringArray = new String[]{GOOGLE_ACCOUNT_TYPE, WORK_ACCOUNT_TYPE, "cn.google"};
        zza = stringArray;
        zzb = "androidPackageName";
        stringArray = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
        zzc = stringArray;
        stringArray = new String[]{"GoogleAuthUtil"};
        zzd = com.google.android.gms.auth.zzd.zza(stringArray);
    }

    zzl() {
    }

    /*
     * WARNING - void declaration
     */
    public static void clearToken(Context context, String token) throws GoogleAuthException, IOException {
        void var1_1;
        zzl.zze(context, (String)var1_1, 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ShowFirstParty
    public static void zze(Context context, String string, long l) throws GoogleAuthException, IOException {
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzl.zzk(context, 8400000);
        Bundle bundle = new Bundle();
        zzl.zzm(context, bundle);
        zzdc.zze(context);
        if (zzhs.zze() && zzl.zzo(context)) {
            com.google.android.gms.internal.auth.zzg zzg2 = com.google.android.gms.internal.auth.zzh.zza(context);
            zzbw zzbw2 = new zzbw();
            zzbw2.zza(string);
            zzg2 = zzg2.zza(zzbw2);
            String string2 = "clear token";
            try {
                zzl.zzi((Task)zzg2, string2);
                return;
            }
            catch (ApiException apiException) {
                zzl.zzl(apiException, string2);
            }
        }
        zzh zzh2 = new zzh(string, bundle);
        zzl.zzh(context, zzc, zzh2, 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void zzk(Context context, int n) throws GoogleAuthException {
        try {
            GooglePlayServicesUtilLight.ensurePlayServicesAvailable((Context)context.getApplicationContext(), (int)n);
            return;
        }
        catch (GooglePlayServicesIncorrectManifestValueException | GooglePlayServicesNotAvailableException throwable) {
            GoogleAuthException googleAuthException = new GoogleAuthException(throwable.getMessage(), throwable);
            throw googleAuthException;
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException = new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
            throw googlePlayServicesAvailabilityException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String token) {
        void var1_1;
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, (String)var1_1);
    }

    private static void zzl(ApiException apiException, String string) {
        Logger logger = zzd;
        Object[] objectArray = new Object[]{string, Log.getStackTraceString((Throwable)apiException)};
        logger.w("%s failed via GoogleAuthServiceClient, falling back to previous approach:\n%s", objectArray);
    }

    private static void zzm(Context object, Bundle bundle) {
        object = object.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", (String)object);
        if (TextUtils.isEmpty((CharSequence)bundle.getString(zzb))) {
            bundle.putString(zzb, (String)object);
        }
        bundle.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
    }

    private static void zzn(Account object) {
        if (object == null) {
            object = new IllegalArgumentException("Account cannot be null");
            throw object;
        }
        if (TextUtils.isEmpty((CharSequence)object.name)) {
            object = new IllegalArgumentException("Account name cannot be empty!");
            throw object;
        }
        String[] stringArray = zza;
        int n = 0;
        while (true) {
            if (n < 3) {
                if (stringArray[n].equals(object.type)) {
                    return;
                }
            } else {
                object = new IllegalArgumentException("Account type not supported");
                throw object;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void zzf(Intent object) {
        if (object == null) {
            object = new IllegalArgumentException("Callback cannot be null.");
            throw object;
        }
        object = object.toUri(1);
        try {
            Intent.parseUri((String)object, (int)1);
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            object = new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
            throw object;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzo(Context object) {
        void var0_3;
        if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(object, 17895000) != 0) {
            return false;
        }
        Iterator iterator = zzhs.zzb();
        iterator = ((zzhr)((Object)iterator)).zzl();
        String string = object.getApplicationInfo().packageName;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals(string)) continue;
            return (boolean)var0_3;
        }
        return (boolean)var0_3;
    }
}

