/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.zza;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="AccountChangeEventCreator")
public class AccountChangeEvent
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<AccountChangeEvent> CREATOR;
    @SafeParcelable.VersionField(id=1)
    final int zza;
    @SafeParcelable.Field(id=2)
    final long zzb;
    @SafeParcelable.Field(id=3)
    final String zzc;
    @SafeParcelable.Field(id=4)
    final int zzd;
    @SafeParcelable.Field(id=5)
    final int zze;
    @SafeParcelable.Field(id=6)
    final String zzf;

    public int getChangeType() {
        return this.zzd;
    }

    public int getEventIndex() {
        return this.zze;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public String getAccountName() {
        return this.zzc;
    }

    @NonNull
    public String getChangeData() {
        return this.zzf;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public String toString() {
        String string;
        switch (this.zzd) {
            default: {
                string = "UNKNOWN";
                break;
            }
            case 1: {
                string = "ADDED";
                break;
            }
            case 4: {
                string = "RENAMED_TO";
                break;
            }
            case 3: {
                string = "RENAMED_FROM";
                break;
            }
            case 2: {
                string = "REMOVED";
            }
        }
        String string2 = this.zzc;
        String string3 = this.zzf;
        int n = this.zze;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AccountChangeEvent {accountName = ");
        stringBuilder.append(string2);
        stringBuilder.append(", changeType = ");
        stringBuilder.append(string);
        stringBuilder.append(", changeData = ");
        stringBuilder.append(string3);
        stringBuilder.append(", eventIndex = ");
        stringBuilder.append(n);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static {
        zza zza2;
        CREATOR = zza2 = new zza();
    }

    /*
     * WARNING - void declaration
     */
    public AccountChangeEvent(long id, @NonNull String accountName, int changeType, int eventIndex, @NonNull String changeData) {
        void var6_5;
        void var5_4;
        void var4_3;
        void var3_2;
        void var1_1;
        this.zza = 1;
        this.zzb = var1_1;
        this.zzc = (String)Preconditions.checkNotNull((Object)var3_2);
        this.zzd = var4_3;
        this.zze = var5_4;
        this.zzf = var6_5;
    }

    @SafeParcelable.Constructor
    AccountChangeEvent(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) int n3, @SafeParcelable.Param(id=6) String string2) {
        this.zza = n;
        this.zzb = l;
        this.zzc = (String)Preconditions.checkNotNull((Object)string);
        this.zzd = n2;
        this.zze = n3;
        this.zzf = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.zza);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)2, (long)this.zzb);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)4, (int)this.zzd);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)5, (int)this.zze);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)6, (String)this.zzf, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object that) {
        AccountChangeEvent accountChangeEvent;
        if (!(that instanceof AccountChangeEvent)) {
            return false;
        }
        if (accountChangeEvent == this) {
            return true;
        }
        accountChangeEvent = accountChangeEvent;
        return this.zza == accountChangeEvent.zza && this.zzb == accountChangeEvent.zzb && Objects.equal((Object)this.zzc, (Object)accountChangeEvent.zzc) && this.zzd == accountChangeEvent.zzd && this.zze == accountChangeEvent.zze && Objects.equal((Object)this.zzf, (Object)accountChangeEvent.zzf);
    }
}

