/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgjl;
import com.google.android.gms.internal.ads.zzgoe;
import com.google.android.gms.internal.ads.zzgox;
import com.google.android.gms.internal.ads.zzgti;
import com.google.android.gms.internal.ads.zzgts;
import com.google.android.gms.internal.ads.zzgui;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class zzgud
implements zzgox {
    private final SecretKey zza;
    private final byte[] zzb;
    private final byte[] zzc;

    private static Cipher zzb() throws GeneralSecurityException {
        if (!zzgjl.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-CMAC in FIPS-mode.");
        }
        return (Cipher)zzgts.zza.zza("AES/ECB/NoPadding");
    }

    public zzgud(byte[] byArray) throws GeneralSecurityException {
        zzgui.zza(byArray.length);
        String string2 = "AES";
        this.zza = new SecretKeySpec(byArray, string2);
        Cipher cipher = zzgud.zzb();
        cipher.init(1, this.zza);
        this.zzb = zzgoe.zza(cipher.doFinal(new byte[16]));
        this.zzc = zzgoe.zza(this.zzb);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final byte[] zza(byte[] byArray, int n) throws GeneralSecurityException {
        Object object;
        if (n > 16) {
            throw new InvalidAlgorithmParameterException("outputLength too large, max is 16 bytes");
        }
        SecretKey secretKey = ((zzgud)object).zza;
        Cipher cipher = zzgud.zzb();
        cipher.init(1, secretKey);
        int n2 = byArray.length;
        int n3 = Math.max(1, (int)Math.ceil((double)n2 / 16.0));
        int n4 = n3 + -1;
        int n5 = n4 * 16;
        if (n3 * 16 == n2) {
            object = zzgti.zzd(byArray, n5, ((zzgud)object).zzb, 0, 16);
        } else {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n5, n2);
            if ((n5 = byArray2.length) >= 16) {
                throw new IllegalArgumentException("x must be smaller than a block.");
            }
            byte[] byArray3 = Arrays.copyOf(byArray2, 16);
            byArray3[n5] = -128;
            object = zzgti.zzc(byArray3, ((zzgud)object).zzc);
        }
        byte[] byArray4 = new byte[16];
        n5 = 0;
        while (n5 < n4) {
            byArray4 = cipher.doFinal(zzgti.zzd(byArray4, 0, byArray, n5 * 16, 16));
            ++n5;
        }
        return Arrays.copyOf(cipher.doFinal(zzgti.zzc((byte[])object, byArray4)), n);
    }
}

