/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgnl;
import com.google.android.gms.internal.ads.zzgnn;
import com.google.android.gms.internal.ads.zzgno;
import com.google.android.gms.internal.ads.zzgnq;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import javax.annotation.Nullable;

public final class zzgnm {
    @Nullable
    private Integer zza = null;
    @Nullable
    private Integer zzb = null;
    private zzgnn zzc = null;
    private zzgno zzd;

    public final zzgnm zza(zzgnn zzgnn2) {
        this.zzc = zzgnn2;
        return this;
    }

    public final zzgnm zzb(int n) throws GeneralSecurityException {
        this.zza = n;
        return this;
    }

    public final zzgnm zzc(int n) throws GeneralSecurityException {
        this.zzb = n;
        return this;
    }

    public final zzgnm zzd(zzgno zzgno2) {
        this.zzd = zzgno2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzgnq zze() throws GeneralSecurityException {
        Object[] objectArray;
        Object[] objectArray2 = objectArray.zza;
        if (objectArray2 == null) {
            throw new GeneralSecurityException("key size is not set");
        }
        if (objectArray.zzb == null) {
            throw new GeneralSecurityException("tag size is not set");
        }
        if (objectArray.zzc == null) {
            throw new GeneralSecurityException("hash type is not set");
        }
        if (objectArray.zzd == null) {
            throw new GeneralSecurityException("variant is not set");
        }
        if (objectArray2.intValue() < 16) {
            objectArray2 = new Object[]{objectArray.zza};
            throw new InvalidAlgorithmParameterException(String.format("Invalid key size in bytes %d; must be at least 16 bytes", objectArray2));
        }
        int n = objectArray.zzb;
        zzgnn zzgnn2 = objectArray.zzc;
        if (n < 10) {
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; must be at least 10 bytes", objectArray));
        }
        if (zzgnn2 == zzgnn.zza) {
            if (n <= 20) return new zzgnq(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 20 bytes for SHA1", objectArray));
        }
        if (zzgnn2 == zzgnn.zzb) {
            if (n <= 28) return new zzgnq(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 28 bytes for SHA224", objectArray));
        }
        if (zzgnn2 == zzgnn.zzc) {
            if (n <= 32) return new zzgnq(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 32 bytes for SHA256", objectArray));
        }
        if (zzgnn2 == zzgnn.zzd) {
            if (n <= 48) return new zzgnq(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
            objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 48 bytes for SHA384", objectArray));
        }
        if (zzgnn2 != zzgnn.zze) {
            throw new GeneralSecurityException("unknown hash type; must be SHA256, SHA384 or SHA512");
        }
        if (n <= 64) {
            return new zzgnq(objectArray.zza, objectArray.zzb, objectArray.zzd, objectArray.zzc, null);
        }
        objectArray = new Object[]{n};
        throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 64 bytes for SHA512", objectArray));
    }

    private zzgnm() {
        throw null;
    }

    /* synthetic */ zzgnm(zzgnl zzgnl2) {
        this.zzd = zzgno.zzd;
    }
}

