/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.ads.zzapg;
import com.google.android.gms.internal.ads.zzaqd;
import com.google.android.gms.internal.ads.zzfnt;
import com.google.android.gms.internal.ads.zzfnv;
import com.google.android.gms.internal.ads.zzfob;
import com.google.android.gms.internal.ads.zzfog;
import com.google.android.gms.internal.ads.zzfoh;
import com.google.android.gms.internal.ads.zzfoi;
import com.google.android.gms.internal.ads.zzfoj;
import com.google.android.gms.internal.ads.zzfok;
import com.google.android.gms.internal.ads.zzfol;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfom {
    private final Context zza;
    private final Executor zzb;
    private final zzfnt zzc;
    private final zzfnv zzd;
    private final zzfol zze;
    private final zzfol zzf;
    private Task zzg;
    private Task zzh;

    public final zzaqd zza() {
        zzfol zzfol2 = this.zze;
        return zzfom.zzg(this.zzg, zzfol2.zza());
    }

    public final zzaqd zzb() {
        zzfol zzfol2 = this.zzf;
        return zzfom.zzg(this.zzh, zzfol2.zza());
    }

    private static zzaqd zzg(@NonNull Task task, @NonNull zzaqd zzaqd2) {
        if (!task.isSuccessful()) {
            return zzaqd2;
        }
        return (zzaqd)task.getResult();
    }

    final /* synthetic */ zzaqd zzc() throws Exception {
        zzapg zzapg2 = zzaqd.zza();
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)((zzfom)object).zza);
        Object object = info.getId();
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzapg2.zzs((String)object);
            zzapg2.zzr(info.isLimitAdTrackingEnabled());
            zzapg2.zzab(6);
        }
        return (zzaqd)zzapg2.zzal();
    }

    final /* synthetic */ zzaqd zzd() throws Exception {
        zzfom zzfom2 = zzfom2.zza;
        PackageInfo packageInfo = zzfom2.getPackageManager().getPackageInfo(zzfom2.getPackageName(), 0);
        zzfom zzfom3 = zzfom2;
        return zzfob.zza((Context)zzfom3, zzfom3.getPackageName(), Integer.toString(packageInfo.versionCode));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzfom zze(@NonNull Context context, @NonNull Executor executor, @NonNull zzfnt zzfnt2, @NonNull zzfnv zzfnv2) {
        zzfom zzfom2 = new zzfom(context, executor, zzfnt2, zzfnv2, new zzfoj(), new zzfok());
        if (zzfom2.zzd.zzd()) {
            zzfom zzfom3 = zzfom2;
            zzfom3.zzg = zzfom3.zzh(new zzfog(zzfom3));
        } else {
            zzfom2.zzg = Tasks.forResult((Object)zzfom2.zze.zza());
        }
        zzfom zzfom4 = zzfom2;
        zzfom4.zzh = zzfom4.zzh(new zzfoh(zzfom4));
        return zzfom2;
    }

    private final Task zzh(@NonNull Callable object) {
        Task task = Tasks.call((Executor)this.zzb, (Callable)object);
        object = new zzfoi(this);
        return task.addOnFailureListener(this.zzb, (OnFailureListener)object);
    }

    @VisibleForTesting
    zzfom(Context context, Executor executor, zzfnt zzfnt2, zzfnv zzfnv2, zzfoj zzfoj2, zzfok zzfok2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfnt2;
        this.zzd = zzfnv2;
        this.zze = zzfoj2;
        this.zzf = zzfok2;
    }

    final /* synthetic */ void zzf(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzc(2025, -1L, exception);
    }
}

